/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.BlockFactory;
import greymerk.roguelike.worldgen.IBlockFactory;
import java.util.Random;
import net.minecraft.world.World;

public class BlockWeightedRandom
implements IBlockFactory {
    private WeightedRandomizer<IBlockFactory> blocks = new WeightedRandomizer();

    public BlockWeightedRandom() {
    }

    public BlockWeightedRandom(JsonElement data) throws Exception {
        this();
        for (JsonElement entry : (JsonArray)data) {
            JsonObject d = entry.getAsJsonObject();
            String type = d.get("type").getAsString();
            JsonElement blockJson = d.get("data");
            int weight = d.get("weight").getAsInt();
            IBlockFactory toAdd = BlockFactory.create(type, blockJson);
            this.addBlock(toAdd, weight);
        }
    }

    public void addBlock(IBlockFactory toAdd, int weight) {
        this.blocks.add(new WeightedChoice<IBlockFactory>(toAdd, weight));
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z) {
        this.setBlock(world, rand, x, y, z, true, true);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z, boolean fillAir, boolean replaceSolid) {
        IBlockFactory block = this.blocks.get(rand);
        block.setBlock(world, rand, x, y, z, fillAir, replaceSolid);
    }
}

