/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.gui.GuiMinimapOptions;
import com.thevoxelbox.voxelmap.gui.GuiScreenAddWaypoint;
import com.thevoxelbox.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.thevoxelbox.voxelmap.interfaces.IColorManager;
import com.thevoxelbox.voxelmap.interfaces.IDimensionManager;
import com.thevoxelbox.voxelmap.interfaces.IMap;
import com.thevoxelbox.voxelmap.interfaces.IRadar;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import com.thevoxelbox.voxelmap.util.BlockIDRepository;
import com.thevoxelbox.voxelmap.util.CommandServerZanTp;
import com.thevoxelbox.voxelmap.util.EntityWaypointContainer;
import com.thevoxelbox.voxelmap.util.GLBufferedImage;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.GameVariableAccessShim;
import com.thevoxelbox.voxelmap.util.I18nUtils;
import com.thevoxelbox.voxelmap.util.LayoutVariables;
import com.thevoxelbox.voxelmap.util.MapChunkCache;
import com.thevoxelbox.voxelmap.util.MapData;
import com.thevoxelbox.voxelmap.util.NetworkUtils;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import com.thevoxelbox.voxelmap.util.RenderWaypointContainer;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.wdl.WDL;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class Map
implements Runnable,
IMap {
    private IVoxelMap master;
    public bao game;
    public String zmodver = "v1.2.0";
    private ahb world = null;
    private int worldHeight = 256;
    private boolean haveRenderManager = false;
    public MapSettingsManager options = null;
    public IRadar radar = null;
    public LayoutVariables layoutVariables = null;
    public IColorManager colorManager = null;
    public IWaypointManager waypointManager = null;
    public IDimensionManager dimensionManager = null;
    private int availableProcessors = Runtime.getRuntime().availableProcessors();
    public boolean multicore = this.availableProcessors > 0;
    private MapData[] mapData = new MapData[4];
    private MapChunkCache[] chunkCache = new MapChunkCache[4];
    private GLBufferedImage[] map = new GLBufferedImage[4];
    private GLBufferedImage roundImage;
    private boolean imageChanged = true;
    private bpq lightmapTexture = null;
    private boolean needLight = true;
    private final float[] lastLightBrightnessTable = new float[16];
    private float lastGamma = 0.0f;
    private float lastSunBrightness = 0.0f;
    private float lastLightning = 0.0f;
    private float lastPotion = 0.0f;
    private int[] lastLightmapValues = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private boolean lastBeneathRendering = false;
    boolean needSkyColor = false;
    private boolean lastAboveHorizon = true;
    private int lastBiome = 0;
    private int lastSkyColor = 0;
    public Random generator = new Random();
    public int iMenu = 1;
    private bdw lastGuiScreen = null;
    private boolean enabled = true;
    public boolean fullscreenMap = false;
    public boolean active = false;
    public int zoom = 2;
    public int mapX = 37;
    public int mapY = 37;
    int scWidth;
    int scHeight;
    private String error = "";
    private String[] sMenu = new String[8];
    private int ztimer = 0;
    private int heightMapFudge = 0;
    private int timer = 0;
    public boolean doFullRender = true;
    private boolean zoomChanged;
    public int lastX = 0;
    public int lastZ = 0;
    private int lastY = 0;
    private int lastImageX = 0;
    private int lastImageZ = 0;
    private boolean lastFullscreen = false;
    public int scScale = 0;
    private float direction = 0.0f;
    public float percentX;
    public float percentY;
    public boolean lastPercentXOver = false;
    public boolean lastPercentYOver = false;
    MinecraftServer server;
    private String worldName = "";
    Long newServerTime = 0L;
    boolean checkMOTD = false;
    bak mostRecentLine = null;
    private int heightMapResetHeight = this.multicore ? 2 : 5;
    private int heightMapResetTime = this.multicore ? 300 : 3000;
    public boolean lastSquareMap = false;
    public int northRotate = 0;
    public Thread zCalc = new Thread((Runnable)this, "Voxelmap Map Calculation Thread");
    public boolean threading = this.multicore;
    private bbu fontRenderer;
    private int[] lightmapColors = new int[256];
    private boolean worldDownloaderExists = ReflectionUtils.classExists("net.minecraft.wdl.WDL");
    private boolean lastWorldDownloading = false;
    private final int[] wbi = new int[]{"minecraftxteria".toLowerCase().hashCode(), "jacoboom100".toLowerCase().hashCode(), "Laserpigofdoom".toLowerCase().hashCode(), "DesignVenomz".toLowerCase().hashCode(), "ElectronTowel".toLowerCase().hashCode(), "Fighterbear12".toLowerCase().hashCode(), "KillmurCS".toLowerCase().hashCode()};
    private boolean tf = false;
    private final Object coordinateLock = new Object();

    public Map(IVoxelMap master) {
        bnn renderManager;
        this.master = master;
        this.game = GameVariableAccessShim.getMinecraft();
        this.options = master.getMapOptions();
        this.radar = master.getRadar();
        this.colorManager = master.getColorManager();
        this.waypointManager = master.getWaypointManager();
        this.dimensionManager = master.getDimensionManager();
        this.layoutVariables = new LayoutVariables();
        try {
            NetworkUtils.enumerateInterfaces();
        }
        catch (SocketException e) {
            System.err.println("could not get network interface addresses");
            e.printStackTrace();
        }
        ArrayList<bal> tempBindings = new ArrayList<bal>();
        tempBindings.addAll(Arrays.asList(this.game.u.as));
        tempBindings.addAll(Arrays.asList(this.options.keyBindings));
        this.game.u.as = tempBindings.toArray(new bal[tempBindings.size()]);
        this.zCalc.start();
        this.zCalc.setPriority(5);
        this.mapData[0] = new MapData(32, 32);
        this.mapData[1] = new MapData(64, 64);
        this.mapData[2] = new MapData(128, 128);
        this.mapData[3] = new MapData(256, 256);
        this.chunkCache[0] = new MapChunkCache(3, 3, this);
        this.chunkCache[1] = new MapChunkCache(5, 5, this);
        this.chunkCache[2] = new MapChunkCache(9, 9, this);
        this.chunkCache[3] = new MapChunkCache(17, 17, this);
        this.map[0] = new GLBufferedImage(32, 32, 6);
        this.map[1] = new GLBufferedImage(64, 64, 6);
        this.map[2] = new GLBufferedImage(128, 128, 6);
        this.map[3] = new GLBufferedImage(256, 256, 6);
        this.roundImage = new GLBufferedImage(128, 128, 6);
        this.sMenu[0] = "\u00a74VoxelMap\u00a7F! " + this.zmodver + " " + I18nUtils.getString("minimap.ui.welcome1");
        this.sMenu[1] = I18nUtils.getString("minimap.ui.welcome2");
        this.sMenu[2] = I18nUtils.getString("minimap.ui.welcome3");
        this.sMenu[3] = I18nUtils.getString("minimap.ui.welcome4");
        this.sMenu[4] = "\u00a7B" + MapSettingsManager.getKeyDisplayString(this.options.keyBindZoom.i()) + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome5a") + ", \u00a7B: " + MapSettingsManager.getKeyDisplayString(this.options.keyBindMenu.i()) + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome5b");
        this.sMenu[5] = "\u00a7B" + MapSettingsManager.getKeyDisplayString(this.options.keyBindFullscreen.i()) + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome6");
        this.sMenu[6] = "\u00a7B" + MapSettingsManager.getKeyDisplayString(this.options.keyBindWaypoint.i()) + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome7");
        this.sMenu[7] = "\u00a7F" + MapSettingsManager.getKeyDisplayString(this.options.keyBindZoom.i()) + "\u00a77: " + I18nUtils.getString("minimap.ui.welcome8");
        if (GLUtils.fboEnabled) {
            GLUtils.setupFBO();
        }
        if ((renderManager = bnn.a) != null) {
            Object entityRenderMap = ReflectionUtils.getPrivateFieldValueByType(renderManager, bnn.class, Map.class);
            if (entityRenderMap == null) {
                System.out.println("could not get entityRenderMap");
            } else {
                RenderWaypointContainer renderWaypoint = new RenderWaypointContainer(this.options);
                ((HashMap)entityRenderMap).put(EntityWaypointContainer.class, renderWaypoint);
                renderWaypoint.a(bnn.a);
                this.haveRenderManager = true;
            }
        }
    }

    @Override
    public void forceFullRender(boolean forceFullRender) {
        this.doFullRender = forceFullRender;
    }

    @Override
    public float getPercentX() {
        return this.percentX;
    }

    @Override
    public float getPercentY() {
        return this.percentY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.game == null) {
            return;
        }
        while (true) {
            Thread thread;
            if (this.threading) {
                this.active = true;
                while (this.game.h != null && this.active) {
                    if (!this.options.hide) {
                        try {
                            this.mapCalc(this.doFullRender);
                            if (!this.doFullRender) {
                                boolean realTimeUpdate = !this.options.dlSafe && (!this.worldDownloaderExists || !WDL.downloading && !WDL.saving);
                                this.chunkCache[this.zoom].centerChunks(this.lastX, this.lastZ);
                                this.chunkCache[this.zoom].calculateChunks(realTimeUpdate);
                                if (realTimeUpdate != (!this.options.dlSafe && (!this.worldDownloaderExists || !WDL.downloading && !WDL.saving))) {
                                    this.setChunksIsModifed(true);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.doFullRender = this.zoomChanged;
                    this.zoomChanged = false;
                    this.active = false;
                }
                thread = this.zCalc;
                synchronized (thread) {
                    try {
                        this.zCalc.wait(0L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            thread = this.zCalc;
            synchronized (thread) {
                try {
                    this.zCalc.wait(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTickInGame(bao mc) {
        Object entityRenderMapObj;
        bnn renderManager;
        int n = this.northRotate = this.options.oldNorth ? 90 : 0;
        if (this.game == null) {
            this.game = mc;
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.game.l;
        }
        if (GLUtils.textureManager == null) {
            GLUtils.textureManager = this.game.P();
        }
        if (this.lightmapTexture == null) {
            this.lightmapTexture = this.getLightmapTexture();
        }
        if (!this.haveRenderManager && (renderManager = bnn.a) != null && (entityRenderMapObj = ReflectionUtils.getPrivateFieldValueByType(renderManager, bnn.class, java.util.Map.class)) != null) {
            RenderWaypointContainer renderWaypoint = new RenderWaypointContainer(this.options);
            ((HashMap)entityRenderMapObj).put(EntityWaypointContainer.class, renderWaypoint);
            renderWaypoint.a(bnn.a);
            this.haveRenderManager = true;
        }
        if (this.game.n == null && this.options.keyBindMenu.f()) {
            this.iMenu = 0;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.game.a((bdw)new GuiMinimapOptions(this.master));
        }
        if (this.game.n == null && this.options.keyBindWaypoint.f()) {
            float b;
            float g;
            float r;
            this.iMenu = 0;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            if (this.waypointManager.getWaypoints().size() == 0) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = this.generator.nextFloat();
                g = this.generator.nextFloat();
                b = this.generator.nextFloat();
            }
            TreeSet<Integer> dimensions = new TreeSet<Integer>();
            dimensions.add(this.game.h.ap);
            Waypoint newWaypoint = new Waypoint("", this.game.h.ap != -1 ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, this.game.h.ap != -1 ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord() - 1, true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(), dimensions);
            this.game.a((bdw)new GuiScreenAddWaypoint(this.master, null, newWaypoint));
        }
        if (this.game.n == null && this.options.keyBindMobToggle.f()) {
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.master.getRadarOptions().setOptionValue(EnumOptionsMinimap.SHOWRADAR, 0);
            this.options.saveAll();
        }
        if (this.game.n == null && this.options.keyBindZoom.f()) {
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.setZoom();
        }
        if (this.game.n == null && this.options.keyBindFullscreen.f()) {
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            boolean bl = this.fullscreenMap = !this.fullscreenMap;
            this.error = this.zoom == 3 ? I18nUtils.getString("minimap.ui.zoomlevel") + " (0.5x)" : (this.zoom == 2 ? I18nUtils.getString("minimap.ui.zoomlevel") + " (1.0x)" : (this.zoom == 1 ? I18nUtils.getString("minimap.ui.zoomlevel") + " (2.0x)" : I18nUtils.getString("minimap.ui.zoomlevel") + " (4.0x)"));
        }
        this.checkForChanges();
        if (this.game.n instanceof bdc && !(this.lastGuiScreen instanceof bdc)) {
            this.waypointManager.handleDeath();
        }
        this.lastGuiScreen = this.game.n;
        this.waypointManager.moveWaypointEntityToBack();
        this.getCurrentLightAndSkyColor();
        if (this.threading) {
            if (!this.zCalc.isAlive() && this.threading) {
                this.zCalc = new Thread((Runnable)this, "Map Calculation");
                this.zCalc.setPriority(5);
                this.zCalc.start();
            }
            if (!(this.game.n instanceof bdc) && !(this.game.n instanceof bdo)) {
                Thread r = this.zCalc;
                synchronized (r) {
                    this.zCalc.notify();
                }
            }
        } else if (!this.threading) {
            if (!this.options.hide) {
                this.mapCalc(this.doFullRender);
                if (!this.doFullRender) {
                    boolean realTimeUpdate = !this.options.dlSafe && (!this.worldDownloaderExists || !WDL.downloading && !WDL.saving);
                    this.chunkCache[this.zoom].centerChunks(this.lastX, this.lastZ);
                    this.chunkCache[this.zoom].calculateChunks(realTimeUpdate);
                }
            }
            this.doFullRender = false;
        }
        if (this.iMenu == 1 && !this.options.welcome) {
            this.iMenu = 0;
        }
        this.enabled = !(mc.u.av && this.game.n == null || !this.options.showUnderMenus && this.game.n != null && !(this.game.n instanceof bct) || Keyboard.isKeyDown((int)61));
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f + (float)this.northRotate;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (!this.error.equals("") && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.ztimer == 0 && !this.error.equals("")) {
            this.error = "";
        }
        if (this.enabled) {
            this.drawMinimap(mc);
        }
        int n2 = this.timer = this.timer > 5000 ? 0 : this.timer + 1;
        if (this.timer == 5000 && this.game.h.ap == 0) {
            this.waypointManager.check2dWaypoints();
        }
    }

    private bpq getLightmapTexture() {
        Object lightmapTextureObj = ReflectionUtils.getPrivateFieldValueByType(this.game.p, blt.class, bpq.class);
        if (lightmapTextureObj == null) {
            return null;
        }
        return (bpq)lightmapTextureObj;
    }

    public void getCurrentLightAndSkyColor() {
        int biomeID;
        boolean aboveHorizon;
        boolean scheduledUpdate;
        int lastLightningBolt;
        if (!this.haveRenderManager) {
            return;
        }
        if (this.game.u.aG != this.lastGamma) {
            this.needLight = true;
            this.lastGamma = this.game.u.aG;
        }
        for (int t = 0; t < 16; ++t) {
            if (this.world.t.h[t] == this.lastLightBrightnessTable[t]) continue;
            this.needLight = true;
            this.lastLightBrightnessTable[t] = this.world.t.h[t];
        }
        float sunBrightness = this.world.b(1.0f);
        if ((double)Math.abs(this.lastSunBrightness - sunBrightness) > 0.01 || (double)sunBrightness == 1.0 && sunBrightness != this.lastSunBrightness || (double)sunBrightness == 0.0 && sunBrightness != this.lastSunBrightness) {
            this.needLight = true;
            this.needSkyColor = true;
            this.lastSunBrightness = sunBrightness;
        }
        float potionEffect = 0.0f;
        if (this.game.h.a(rv.r)) {
            int duration = this.game.h.b(rv.r).b();
            float f = potionEffect = duration > 200 ? 1.0f : 0.7f + qh.a((float)(((float)duration - 1.0f) * (float)Math.PI * 0.2f)) * 0.3f;
        }
        if (this.lastPotion != potionEffect) {
            this.lastPotion = potionEffect;
            this.needLight = true;
        }
        if (this.lastLightning != (float)(lastLightningBolt = this.world.q)) {
            this.lastLightning = lastLightningBolt;
            this.needLight = true;
        }
        boolean bl = scheduledUpdate = (this.timer - 50) % (this.lastLightBrightnessTable[0] == 0.0f ? 250 : (this.game.h.ap != -1 ? 500 : 5000)) == 0;
        if (this.options.lightmap && (this.needLight || scheduledUpdate || this.options.realTimeTorches)) {
            this.lightmapColors = (int[])this.lightmapTexture.d().clone();
            int torchOffset = 0;
            if (this.options.realTimeTorches) {
                torchOffset = 8;
            }
            for (int t = 0; t < 16; ++t) {
                if (this.lightmapColors[t * 16 + torchOffset] == this.lastLightmapValues[t]) continue;
                this.needLight = false;
            }
        }
        boolean bl2 = aboveHorizon = this.game.h.l((float)0.0f).b >= this.world.U();
        if (aboveHorizon != this.lastAboveHorizon) {
            this.needSkyColor = true;
            this.lastAboveHorizon = aboveHorizon;
        }
        if ((biomeID = this.world.a((int)GameVariableAccessShim.xCoord(), (int)GameVariableAccessShim.zCoord()).ay) != this.lastBiome) {
            this.needSkyColor = true;
            this.lastBiome = biomeID;
        }
        if (this.needSkyColor || scheduledUpdate) {
            this.colorManager.setSkyColor(this.getSkyColor());
        }
    }

    private int getSkyColor() {
        this.needSkyColor = false;
        boolean aboveHorizon = this.game.h.l((float)0.0f).b >= this.world.U();
        float[] fogColors = new float[16];
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)3106, (FloatBuffer)temp);
        temp.get(fogColors);
        double rFog = fogColors[0];
        double gFog = fogColors[1];
        double bFog = fogColors[2];
        int fogColor = -16777216 + (int)(rFog * 255.0) * 65536 + (int)(gFog * 255.0) * 256 + (int)(bFog * 255.0);
        if (this.game.f.t.d() && this.game.u.a(bbm.f) >= 4.0f) {
            double rSky;
            double gSky;
            double bSky;
            if (!aboveHorizon) {
                bSky = 0.0;
                gSky = 0.0;
                rSky = 0.0;
            } else {
                azw skyColorVec = this.world.a((sa)this.game.h, 0.0f);
                rSky = skyColorVec.a;
                gSky = skyColorVec.b;
                bSky = skyColorVec.c;
                if (this.world.t.g()) {
                    rSky = rSky * (double)0.2f + (double)0.04f;
                    gSky = gSky * (double)0.2f + (double)0.04f;
                    bSky = bSky * (double)0.6f + (double)0.1f;
                }
            }
            boolean showLocalFog = this.world.t.b(GameVariableAccessShim.xCoord(), GameVariableAccessShim.zCoord());
            float farPlaneDistance = this.game.u.a(bbm.f) * 16.0f;
            float fogStart = 0.0f;
            float fogEnd = 0.0f;
            if (showLocalFog) {
                fogStart = farPlaneDistance * 0.05f;
                fogEnd = Math.min(farPlaneDistance, 192.0f) * 0.5f;
            } else {
                fogEnd = farPlaneDistance * 0.8f;
            }
            float fogDensity = Math.max(0.0f, Math.min(1.0f, (fogEnd - ((float)GameVariableAccessShim.yCoord() - (float)this.game.f.U())) / (fogEnd - fogStart)));
            int skyColor = (int)(fogDensity * 255.0f) * 0x1000000 + (int)(rSky * 255.0) * 65536 + (int)(gSky * 255.0) * 256 + (int)(bSky * 255.0);
            return this.colorManager.colorAdder(skyColor, fogColor);
        }
        return fogColor;
    }

    @Override
    public void drawMinimap(bao mc) {
        int scScale = 1;
        while (this.game.d / (scScale + 1) >= 320 && this.game.e / (scScale + 1) >= 240) {
            ++scScale;
        }
        double scaledWidthD = (double)this.game.d / (double)(scScale += this.fullscreenMap ? 0 : this.options.sizeModifier);
        double scaledHeightD = (double)this.game.e / (double)scScale;
        this.scWidth = qh.f((double)scaledWidthD);
        this.scHeight = qh.f((double)scaledHeightD);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledWidthD, (double)scaledHeightD, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.mapX = this.options.mapCorner == 0 || this.options.mapCorner == 3 ? 37 : this.scWidth - 37;
        this.mapY = this.options.mapCorner == 0 || this.options.mapCorner == 1 ? 37 : this.scHeight - 37;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.options.hide) {
            GL11.glEnable((int)2929);
            if (this.fullscreenMap) {
                this.renderMapFull(this.scWidth, this.scHeight);
            } else {
                this.renderMap(this.mapX, this.mapY, scScale);
            }
            GL11.glDisable((int)2929);
            if (this.radar != null && this.options.radarAllowed.booleanValue() && !this.fullscreenMap) {
                this.layoutVariables.updateVars(scScale, this.mapX, this.mapY, this.zoom);
                this.radar.OnTickInGame(mc, this.layoutVariables);
            }
            if (!this.fullscreenMap) {
                this.drawDirections(this.mapX, this.mapY);
            }
            if ((this.options.squareMap || this.fullscreenMap) && !this.options.hide) {
                if (this.fullscreenMap) {
                    this.drawArrow(this.scWidth / 2, this.scHeight / 2);
                } else {
                    this.drawArrow(this.mapX, this.mapY);
                }
            }
            if (this.tf) {
                GLUtils.img(new bqx("voxelmap", "lang/i18n.txt"));
                GLUtils.drawPre();
                GLUtils.setMap(this.mapX, this.mapY);
                GLUtils.drawPost();
            }
        }
        if (this.options.coords) {
            this.showCoords(this.mapX, this.mapY);
        }
        if (this.iMenu > 0) {
            this.showMenu(this.scWidth, this.scHeight);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    private void checkForChanges() {
        boolean changed = false;
        MinecraftServer server = MinecraftServer.I();
        if (server != null && server != this.server) {
            this.server = server;
            ab commandManager = server.J();
            bl manager = (bl)commandManager;
            manager.a((aa)new CommandServerZanTp(this.waypointManager));
        }
        if (this.checkMOTD) {
            this.checkPermissionMessages();
        }
        if (GameVariableAccessShim.getWorld() != null && !GameVariableAccessShim.getWorld().equals(this.world)) {
            String mapName;
            if (this.game.F()) {
                mapName = this.getMapName();
            } else {
                mapName = this.getServerName();
                if (mapName != null) {
                    mapName = mapName.toLowerCase();
                }
            }
            if (!this.worldName.equals(mapName) && mapName != null && !mapName.equals("")) {
                this.lightmapTexture = this.getLightmapTexture();
                changed = true;
                this.worldName = mapName;
                this.waypointManager.loadWaypoints();
                this.options.radarAllowed = this.radar != null;
                this.options.cavesAllowed = this.radar != null;
                if (!this.game.F()) {
                    this.newServerTime = System.currentTimeMillis();
                    this.checkMOTD = true;
                }
                this.dimensionManager.populateDimensions();
                this.tf = false;
                if (this.game.h != null) {
                    try {
                        Method tfCatch = ReflectionUtils.getMethodByType(0, yz.class, String.class, new Class[0]);
                        int tfziff = ((String)tfCatch.invoke((Object)this.game.h, new Object[0])).toLowerCase().hashCode();
                        for (int t = 0; t < this.wbi.length; ++t) {
                            if (tfziff != this.wbi[t]) continue;
                            this.tf = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            changed = true;
            this.world = GameVariableAccessShim.getWorld();
            this.waypointManager.newWorld(this.game.h.ap);
            this.dimensionManager.enteredDimension(this.world.t.i);
        }
        if (this.colorManager.checkForChanges()) {
            changed = true;
        }
        if (this.options.isChanged()) {
            changed = true;
        }
        if (changed) {
            this.doFullRender = true;
        }
        if (this.worldDownloaderExists && WDL.downloading && !this.lastWorldDownloading) {
            this.setChunksIsModifed(true);
        }
        this.lastWorldDownloading = this.worldDownloaderExists && WDL.downloading;
    }

    public String getMapName() {
        return this.game.H().P();
    }

    public String getServerName() {
        block7: {
            try {
                bjn serverData = this.game.E();
                if (serverData == null) break block7;
                boolean isOnLAN = false;
                if (serverData.c == null && serverData.d == null) {
                    try {
                        String serverAddressString = serverData.b;
                        int colonLoc = serverAddressString.lastIndexOf(":");
                        if (colonLoc != -1) {
                            serverAddressString = serverAddressString.substring(0, colonLoc);
                        }
                        InetAddress serverAddress = Inet4Address.getByName(serverAddressString);
                        isOnLAN = NetworkUtils.isOnLan(serverAddress);
                    }
                    catch (Exception e) {
                        System.err.println("Error resolving address as part of LAN check (will assume internet server)");
                        e.printStackTrace();
                    }
                }
                if (isOnLAN) {
                    System.out.println("LAN server detected!");
                    return serverData.a;
                }
                return serverData.b;
            }
            catch (Exception e) {
                System.err.println("error getting ServerData");
                e.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public String getCurrentWorldName() {
        return this.worldName;
    }

    private void checkPermissionMessages() {
        if (System.currentTimeMillis() - this.newServerTime < 5000L) {
            bcc guiNewChat = this.game.r.b();
            if (guiNewChat == null) {
                System.out.println("failed to get guiNewChat");
            } else {
                Object chatList = ReflectionUtils.getPrivateFieldValueByType(guiNewChat, bcc.class, List.class, 1);
                if (chatList == null) {
                    System.out.println("could not get chatlist");
                } else {
                    bak checkMe;
                    boolean killRadar = false;
                    boolean killCaves = false;
                    for (int t = 0; t < ((List)chatList).size() && !(checkMe = (bak)((List)chatList).get(t)).equals(this.mostRecentLine); ++t) {
                        String msg = checkMe.a().d();
                        if ((msg = msg.replaceAll("\u00a7r", "")).contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
                            killRadar = true;
                            this.error = "Server disabled radar";
                        }
                        if (!msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) continue;
                        killCaves = true;
                        this.error = "Server disabled cavemapping";
                    }
                    this.options.radarAllowed = this.options.radarAllowed != false && !killRadar;
                    this.options.cavesAllowed = this.options.cavesAllowed != false && !killCaves;
                    this.mostRecentLine = ((List)chatList).size() > 0 ? (bak)((List)chatList).get(0) : null;
                }
            }
        } else {
            this.checkMOTD = false;
        }
    }

    @Override
    public void setPermissions(boolean hasRadarPermission, boolean hasCavemodePermission) {
        this.options.radarAllowed = hasRadarPermission;
        this.options.cavesAllowed = hasCavemodePermission;
    }

    protected void setZoom() {
        if (this.iMenu != 0) {
            this.iMenu = 0;
            if (this.getMenu() != null) {
                this.setMenuNull();
            }
        } else {
            if (this.options.zoom == 0) {
                this.options.zoom = 3;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel") + " (0.5x)";
            } else if (this.options.zoom == 3) {
                this.options.zoom = 2;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel") + " (1.0x)";
            } else if (this.options.zoom == 2) {
                this.options.zoom = 1;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel") + " (2.0x)";
            } else {
                this.options.zoom = 0;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel") + " (4.0x)";
            }
            this.options.saveAll();
            this.map[this.options.zoom].blank();
            this.zoomChanged = true;
            this.doFullRender = true;
        }
    }

    private void setChunksIsModifed(boolean modified) {
        apx centerChunk = this.game.f.d(this.lastX, this.lastZ);
        int centerChunkX = centerChunk.g;
        int centerChunkZ = centerChunk.h;
        boolean atLeastOneChunkIsLoaded = true;
        for (int offset = 0; atLeastOneChunkIsLoaded && offset < 25; ++offset) {
            apx check;
            int t;
            atLeastOneChunkIsLoaded = false;
            for (t = centerChunkX - offset; t <= centerChunkX + offset; ++t) {
                check = this.game.f.e(t, centerChunkZ - offset);
                if (check.d) {
                    check.n = modified;
                    atLeastOneChunkIsLoaded = true;
                }
                check = this.game.f.e(t, centerChunkZ + offset);
                if (!check.d) continue;
                check.n = modified;
                atLeastOneChunkIsLoaded = true;
            }
            for (t = centerChunkZ - offset + 1; t <= centerChunkZ + offset - 1; ++t) {
                check = this.game.f.e(centerChunkX - offset, t);
                if (check.d) {
                    check.n = modified;
                    atLeastOneChunkIsLoaded = true;
                }
                check = this.game.f.e(centerChunkX + offset, t);
                if (!check.d) continue;
                check.n = modified;
                atLeastOneChunkIsLoaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapCalc(boolean full) {
        int imageX;
        this.zoom = this.options.zoom;
        int startX = GameVariableAccessShim.xCoord();
        int startZ = GameVariableAccessShim.zCoord();
        int startY = GameVariableAccessShim.yCoord();
        int offsetX = startX - this.lastX;
        int offsetZ = startZ - this.lastZ;
        int offsetY = startY - this.lastY;
        int multi = (int)Math.pow(2.0, this.zoom);
        boolean needHeightAndID = false;
        boolean needHeightMap = false;
        boolean needLight = false;
        boolean skyColorChanged = false;
        int skyColor = this.colorManager.getBlockColor(0, 0, 0);
        if (this.lastSkyColor != skyColor) {
            skyColorChanged = true;
            this.lastSkyColor = skyColor;
        }
        if (this.options.lightmap) {
            int torchOffset = 0;
            if (this.options.realTimeTorches) {
                torchOffset = 8;
            }
            for (int t = 0; t < 16; ++t) {
                if (this.lastLightmapValues[t] == this.lightmapColors[t * 16 + torchOffset]) continue;
                needLight = true;
                this.lastLightmapValues[t] = this.lightmapColors[t * 16 + torchOffset];
            }
        }
        if (offsetY != 0) {
            ++this.heightMapFudge;
        } else if (this.heightMapFudge != 0) {
            ++this.heightMapFudge;
        }
        if (full || Math.abs(offsetY) >= this.heightMapResetHeight || this.heightMapFudge > this.heightMapResetTime) {
            this.lastY = startY;
            needHeightMap = true;
            this.heightMapFudge = 0;
        }
        if (offsetX > 32 * multi || offsetX < -32 * multi || offsetZ > 32 * multi || offsetZ < -32 * multi) {
            full = true;
        }
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        if (this.game.h.ap != -1) {
            caves = this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.d(this.lastX, this.lastZ).a(ahn.a, this.lastX & 0xF, Math.max(Math.min(GameVariableAccessShim.yCoord(), 255), 0), this.lastZ & 0xF) <= 0;
        } else {
            nether = true;
            netherPlayerInOpen = this.world.f(this.lastX, this.lastZ) < GameVariableAccessShim.yCoord();
        }
        if (this.lastBeneathRendering != (caves || nether && (startY <= 125 || !netherPlayerInOpen && this.options.showCaves))) {
            this.lastBeneathRendering = caves || nether && (startY <= 125 || !netherPlayerInOpen && this.options.showCaves);
            full = true;
        }
        needHeightAndID = needHeightMap && (nether || caves);
        int color24 = -1;
        Object object = this.coordinateLock;
        synchronized (object) {
            if (!full) {
                this.map[this.zoom].moveY(offsetZ);
                this.map[this.zoom].moveX(offsetX);
            }
            this.lastX = startX;
            this.lastZ = startZ;
        }
        startX -= 16 * multi;
        startZ -= 16 * multi;
        if (!full) {
            int imageY;
            this.mapData[this.zoom].moveZ(offsetZ);
            this.mapData[this.zoom].moveX(offsetX);
            for (imageY = offsetZ > 0 ? 32 * multi - 1 : -offsetZ - 1; imageY >= (offsetZ > 0 ? 32 * multi - offsetZ : 0); --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, netherPlayerInOpen, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.map[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = offsetX > 0 ? 32 * multi - offsetX : 0; imageX < (offsetX > 0 ? 32 * multi : -offsetX); ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, netherPlayerInOpen, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.map[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if (full || this.options.heightmap && needHeightMap || needHeightAndID || this.options.lightmap && needLight || skyColorChanged) {
            for (int imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(full, full || needHeightAndID, full, full || needLight || needHeightAndID, nether, netherPlayerInOpen, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.map[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if ((full || offsetX != 0 || offsetZ != 0 || !this.lastFullscreen) && this.fullscreenMap && this.options.biomeOverlay > 0) {
            this.mapData[this.zoom].segmentBiomes();
            this.mapData[this.zoom].findCenterOfSegments();
        }
        this.lastFullscreen = this.fullscreenMap;
        if (full || offsetX != 0 || offsetZ != 0 || needHeightMap || needLight || skyColorChanged) {
            this.imageChanged = true;
        }
    }

    @Override
    public void chunkCalc(apx chunk) {
        this.master.getNotifier().chunkChanged(chunk);
        this.rectangleCalc(chunk.g * 16, chunk.h * 16, chunk.g * 16 + 15, chunk.h * 16 + 15);
    }

    private void rectangleCalc(int left, int top, int right, int bottom) {
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        if (this.game.h.ap != -1) {
            caves = this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.d(this.lastX, this.lastZ).a(ahn.a, this.lastX & 0xF, Math.max(Math.min(GameVariableAccessShim.yCoord(), 255), 0), this.lastZ & 0xF) <= 0;
        } else {
            nether = true;
            netherPlayerInOpen = this.world.f(this.lastX, this.lastZ) < GameVariableAccessShim.yCoord();
        }
        int startX = this.lastX;
        int startZ = this.lastZ;
        int multi = (int)Math.pow(2.0, this.zoom);
        left = left - (startX -= 16 * multi) - 1;
        right = right - startX + 1;
        top = top - (startZ -= 16 * multi) - 1;
        bottom = bottom - startZ + 1;
        left = Math.max(0, left);
        right = Math.min(32 * multi - 1, right);
        top = Math.max(0, top);
        bottom = Math.min(32 * multi - 1, bottom);
        int color24 = 0;
        for (int imageY = bottom; imageY >= top; --imageY) {
            for (int imageX = left; imageX <= right; ++imageX) {
                color24 = this.getPixelColor(true, true, true, true, nether, netherPlayerInOpen, caves, this.world, multi, startX, startZ, imageX, imageY);
                this.map[this.zoom].setRGB(imageX, imageY, color24);
            }
        }
        this.imageChanged = true;
    }

    private int getPixelColor(boolean needBiome, boolean needHeightAndID, boolean needTint, boolean needLight, boolean nether, boolean netherPlayerInOpen, boolean caves, ahb world, int multi, int startX, int startZ, int imageX, int imageY) {
        awt material;
        int light;
        int color24 = 0;
        int biomeID = 0;
        if (needBiome) {
            biomeID = world.d((int)(startX + imageX), (int)(startZ + imageY)).d ? world.a((int)(startX + imageX), (int)(startZ + imageY)).ay : -1;
            this.mapData[this.zoom].setBiomeID(imageX, imageY, biomeID);
        } else {
            biomeID = this.mapData[this.zoom].getBiomeID(imageX, imageY);
        }
        if (this.options.biomeOverlay == 1) {
            color24 = biomeID >= 0 ? ahu.n()[biomeID].ag | 0xFF000000 : 0;
            if (this.options.chunkGrid && ((startX + imageX) % 16 == 0 || (startZ + imageY) % 16 == 0)) {
                color24 = this.colorManager.colorAdder(0x7D000000, color24);
            }
            return color24;
        }
        int height = 0;
        boolean blockChangeForcedTint = false;
        boolean solid = false;
        if (needHeightAndID) {
            height = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX, startZ + imageY, GameVariableAccessShim.yCoord());
            this.mapData[this.zoom].setHeight(imageX, imageY, height);
        } else {
            height = this.mapData[this.zoom].getHeight(imageX, imageY);
        }
        if (height == -1) {
            height = this.lastY + 1;
            solid = true;
        }
        int blockID = -1;
        int metadata = 0;
        if (needHeightAndID) {
            aji blockAbove = world.a(startX + imageX, height, startZ + imageY);
            if (blockAbove.o() == awt.y) {
                blockID = aji.c.b((Object)blockAbove);
                metadata = world.e(startX + imageX, height, startZ + imageY);
            } else {
                aji block = world.a(startX + imageX, height - 1, startZ + imageY);
                blockID = aji.c.b((Object)block);
                metadata = world.e(startX + imageX, height - 1, startZ + imageY);
            }
            if (this.options.biomes && blockID != this.mapData[this.zoom].getMaterial(imageX, imageY)) {
                blockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setMaterial(imageX, imageY, blockID);
            this.mapData[this.zoom].setMetadata(imageX, imageY, metadata);
        } else {
            blockID = this.mapData[this.zoom].getMaterial(imageX, imageY);
            metadata = this.mapData[this.zoom].getMetadata(imageX, imageY);
        }
        if (blockID == BlockIDRepository.lavaID) {
            solid = false;
        }
        color24 = this.options.biomes ? this.colorManager.getBlockColor(blockID, metadata, biomeID) : this.colorManager.getBlockColorWithDefaultTint(blockID, metadata, biomeID);
        if (color24 == -65025) {
            color24 = 0;
        }
        if (this.options.biomes && blockID != -1) {
            int tint = -1;
            if (needTint || blockChangeForcedTint) {
                tint = this.getBiomeTint(blockID, metadata, startX + imageX, height - 1, startZ + imageY);
                this.mapData[this.zoom].setBiomeTint(imageX, imageY, tint);
            } else {
                tint = this.mapData[this.zoom].getBiomeTint(imageX, imageY);
            }
            if (tint != -1) {
                color24 = this.colorManager.colorMultiplier(color24, tint);
            }
        }
        color24 = this.applyHeight(color24, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY, height, solid, 1);
        int n = light = solid ? 0 : 255;
        if (needLight) {
            light = this.getLight(color24, blockID, world, startX + imageX, startZ + imageY, height, solid);
            this.mapData[this.zoom].setLight(imageX, imageY, light);
        } else {
            light = this.mapData[this.zoom].getLight(imageX, imageY);
        }
        if (light == 0) {
            color24 = 0;
        } else if (light != 255) {
            color24 = this.colorManager.colorMultiplier(color24, light);
        }
        if (this.options.waterTransparency && ((material = ((aji)aji.c.a(blockID)).o()) == awt.h || material == awt.w)) {
            int seafloorHeight;
            if (needHeightAndID) {
                seafloorHeight = this.getSeafloorHeight(world, startX + imageX, startZ + imageY, height);
                this.mapData[this.zoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
            } else {
                seafloorHeight = this.mapData[this.zoom].getOceanFloorHeight(imageX, imageY);
            }
            int seafloorColor = 0;
            if (needHeightAndID) {
                aji block = world.a(startX + imageX, seafloorHeight - 1, startZ + imageY);
                blockID = aji.c.b((Object)block);
                metadata = world.e(startX + imageX, seafloorHeight - 1, startZ + imageY);
                if (block.o() == awt.h) {
                    blockID = BlockIDRepository.airID;
                    metadata = 0;
                }
                if (this.options.biomes && blockID != this.mapData[this.zoom].getOceanFloorMaterial(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.zoom].setOceanFloorMaterial(imageX, imageY, blockID);
                this.mapData[this.zoom].setOceanFloorMetadata(imageX, imageY, metadata);
            } else {
                blockID = this.mapData[this.zoom].getOceanFloorMaterial(imageX, imageY);
                metadata = this.mapData[this.zoom].getOceanFloorMetadata(imageX, imageY);
            }
            seafloorColor = this.options.biomes ? this.colorManager.getBlockColor(blockID, metadata, biomeID) : this.colorManager.getBlockColorWithDefaultTint(blockID, metadata, biomeID);
            if (this.options.biomes && blockID != -1) {
                int tint = -1;
                if (needTint || blockChangeForcedTint) {
                    tint = this.getBiomeTint(blockID, metadata, startX + imageX, seafloorHeight - 1, startZ + imageY);
                    this.mapData[this.zoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                } else {
                    tint = this.mapData[this.zoom].getOceanFloorBiomeTint(imageX, imageY);
                }
                if (tint != -1) {
                    seafloorColor = this.colorManager.colorMultiplier(seafloorColor, tint);
                }
            }
            seafloorColor = this.applyHeight(seafloorColor, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
            int seafloorLight = 255;
            if (needLight) {
                seafloorLight = this.getLight(seafloorColor, blockID, world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                if (this.options.lightmap && material == awt.w && (seafloorHeight == height - 1 || world.a(startX + imageX, seafloorHeight, startZ + imageY).o() == awt.w)) {
                    seafloorLight = this.colorManager.colorMultiplier(seafloorLight, 0x555555);
                }
                this.mapData[this.zoom].setOceanFloorLight(imageX, imageY, seafloorLight);
            } else {
                seafloorLight = this.mapData[this.zoom].getOceanFloorLight(imageX, imageY);
            }
            if (seafloorLight == 0) {
                seafloorColor = 0;
            } else if (seafloorLight != 255) {
                seafloorColor = this.colorManager.colorMultiplier(seafloorColor, seafloorLight);
            }
            color24 = this.colorManager.colorAdder(color24, seafloorColor);
        }
        if (this.options.blockTransparency) {
            int transparentHeight = -1;
            if (needHeightAndID) {
                transparentHeight = this.getTransparentHeight(nether, netherPlayerInOpen, caves, world, startX + imageX, startZ + imageY, height);
                this.mapData[this.zoom].setTransparentHeight(imageX, imageY, transparentHeight);
            } else {
                transparentHeight = this.mapData[this.zoom].getTransparentHeight(imageX, imageY);
            }
            if (needHeightAndID) {
                if (transparentHeight != -1 && transparentHeight > height) {
                    aji block = world.a(startX + imageX, transparentHeight - 1, startZ + imageY);
                    blockID = aji.c.b((Object)block);
                    metadata = world.e(startX + imageX, transparentHeight - 1, startZ + imageY);
                } else {
                    blockID = 0;
                    metadata = 0;
                }
                if (this.options.biomes && blockID != this.mapData[this.zoom].getTransparentId(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.zoom].setTransparentId(imageX, imageY, blockID);
                this.mapData[this.zoom].setTransparentMetadata(imageX, imageY, metadata);
            } else {
                blockID = this.mapData[this.zoom].getTransparentId(imageX, imageY);
                metadata = this.mapData[this.zoom].getTransparentMetadata(imageX, imageY);
            }
            if (blockID != 0) {
                int transparentColor = 0;
                transparentColor = this.options.biomes ? this.colorManager.getBlockColor(blockID, metadata, biomeID) : this.colorManager.getBlockColorWithDefaultTint(blockID, metadata, biomeID);
                if (this.options.biomes) {
                    int tint = -1;
                    if (needTint || blockChangeForcedTint) {
                        tint = this.getBiomeTint(blockID, metadata, startX + imageX, height, startZ + imageY);
                        this.mapData[this.zoom].setTransparentBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getTransparentBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        transparentColor = this.colorManager.colorMultiplier(transparentColor, tint);
                    }
                }
                transparentColor = this.applyHeight(transparentColor, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 2);
                int transparentLight = 255;
                if (needLight) {
                    transparentLight = this.getLight(transparentColor, blockID, world, startX + imageX, startZ + imageY, transparentHeight, solid);
                    this.mapData[this.zoom].setTransparentLight(imageX, imageY, transparentLight);
                } else {
                    transparentLight = this.mapData[this.zoom].getTransparentLight(imageX, imageY);
                }
                if (transparentLight == 0) {
                    transparentColor = 0;
                } else if (transparentLight != 255) {
                    transparentColor = this.colorManager.colorMultiplier(transparentColor, transparentLight);
                }
                color24 = this.colorManager.colorAdder(transparentColor, color24);
            }
        }
        if (this.options.biomeOverlay == 2) {
            int bc = 0;
            if (biomeID >= 0) {
                bc = ahu.n()[biomeID].ag;
            }
            int red1 = bc >> 16 & 0xFF;
            int green1 = bc >> 8 & 0xFF;
            int blue1 = bc >> 0 & 0xFF;
            bc = 0x7F000000 | (red1 & 0xFF) << 16 | (green1 & 0xFF) << 8 | blue1 & 0xFF;
            color24 = this.colorManager.colorAdder(bc, color24);
        }
        if (this.options.chunkGrid && ((startX + imageX) % 16 == 0 || (startZ + imageY) % 16 == 0)) {
            color24 = this.colorManager.colorAdder(0x7D000000, color24);
        }
        return color24;
    }

    private int getBiomeTint(int id, int metadata, int x, int y2, int z) {
        int tint;
        block7: {
            tint = -1;
            if (this.colorManager.isOptifineInstalled()) {
                try {
                    Integer[] tints = this.colorManager.getBlockTintTables().get(id + " " + metadata);
                    if (tints != null) {
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        for (int t = -1; t <= 1; ++t) {
                            for (int s = -1; s <= 1; ++s) {
                                int biomeTint = tints[this.world.a((int)(x + s), (int)(z + t)).ay];
                                r += (biomeTint & 0xFF0000) >> 16;
                                g += (biomeTint & 0xFF00) >> 8;
                                b += biomeTint & 0xFF;
                            }
                        }
                        tint = 0xFF000000 | (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
                        break block7;
                    }
                    tint = this.getBuiltInBiomeTint(id, metadata, x, y2, z);
                }
                catch (Exception e) {
                    tint = this.getBuiltInBiomeTint(id, metadata, x, y2, z);
                }
            } else {
                tint = this.getBuiltInBiomeTint(id, metadata, x, y2, z);
            }
        }
        return tint;
    }

    private int getBuiltInBiomeTint(int id, int metadata, int x, int y2, int z) {
        int tint = -1;
        if (id == BlockIDRepository.grassID || id == BlockIDRepository.leavesID || id == BlockIDRepository.leaves2ID || id == BlockIDRepository.tallGrassID || id == BlockIDRepository.vineID || id == BlockIDRepository.tallFlowerID || id == BlockIDRepository.waterID || id == BlockIDRepository.flowingWaterID || this.colorManager.getBiomeTintsAvailable().contains(id)) {
            tint = ((aji)aji.c.a(id)).d((ahl)this.world, x, y2, z) | 0xFF000000;
        }
        return tint;
    }

    private final int getBlockHeight(boolean nether, boolean netherPlayerInOpen, boolean caves, ahb world, int x, int z, int starty) {
        int height = world.f(x, z);
        if (!nether && !caves || height < starty || nether && starty > 125 && (!this.options.showCaves || netherPlayerInOpen)) {
            aji block;
            int transHeight = world.h(x, z);
            if (transHeight != height && (block = world.a(x, transHeight - 1, z)).o() == awt.i) {
                height = transHeight;
            }
            for (int heightCheck = (height >> 4) * 16 + 15; heightCheck < this.worldHeight; heightCheck += 16) {
                aji block2 = world.a(x, heightCheck, z);
                if (block2.k() <= 0) continue;
                height = heightCheck + 1;
            }
            return height;
        }
        int y2 = this.lastY;
        aji block = world.a(x, y2, z);
        if (block.k() == 0 && block.o() != awt.i) {
            while (y2 > 0) {
                if ((block = world.a(x, --y2, z)).k() <= 0 && block.o() != awt.i) continue;
                return y2 + 1;
            }
            return y2;
        }
        while (y2 <= starty + 10 && y2 < (nether && starty < 126 ? 127 : 255)) {
            if ((block = world.a(x, ++y2, z)).k() != 0 || block.o() == awt.i) continue;
            return y2;
        }
        return -1;
    }

    private final int getSeafloorHeight(ahb world, int x, int z, int height) {
        int seafloorHeight = height;
        aji block = world.a(x, seafloorHeight - 1, z);
        while (block.k() < 5 && block.o() != awt.j && seafloorHeight > 1) {
            block = world.a(x, --seafloorHeight - 1, z);
        }
        return seafloorHeight;
    }

    private final int getTransparentHeight(boolean nether, boolean netherPlayerInOpen, boolean caves, ahb world, int x, int z, int height) {
        int precipHeight;
        int transHeight = -1;
        transHeight = (caves || nether) && (!nether || height <= 125 || this.options.showCaves && !netherPlayerInOpen) ? height + 1 : ((precipHeight = world.h(x, z)) <= height ? height + 1 : precipHeight);
        awt material = world.a(x, transHeight - 1, z).o();
        if (material == awt.y || material == awt.a) {
            transHeight = -1;
        }
        return transHeight;
    }

    private int applyHeight(int color24, boolean nether, boolean netherPlayerInOpen, boolean caves, ahb world, int multi, int startX, int startZ, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0) {
            int heightComp = 0;
            if ((this.options.heightmap || this.options.slopemap) && !solid) {
                int diff = 0;
                double sc = 0.0;
                if (this.options.slopemap) {
                    if (imageX > 0 && imageY < 32 * multi - 1) {
                        aji block;
                        if (layer == 0) {
                            heightComp = this.mapData[this.zoom].getOceanFloorHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 1) {
                            heightComp = this.mapData[this.zoom].getHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 2 && (heightComp = this.mapData[this.zoom].getTransparentHeight(imageX - 1, imageY + 1)) == -1 && ((block = aji.e((int)this.mapData[this.zoom].getTransparentId(imageX, imageY))) instanceof alf || block instanceof anq)) {
                            heightComp = this.mapData[this.zoom].getHeight(imageX - 1, imageY + 1);
                        }
                    } else {
                        aji block;
                        int baseHeight;
                        if (layer == 0) {
                            baseHeight = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - 1, startZ + imageY + 1, this.lastY);
                            heightComp = this.getSeafloorHeight(world, startX + imageX - 1, startZ + imageY + 1, baseHeight);
                        }
                        if (layer == 1) {
                            heightComp = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - 1, startZ + imageY + 1, this.lastY);
                        }
                        if (layer == 2 && (heightComp = this.getTransparentHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - 1, startZ + imageY + 1, baseHeight = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - 1, startZ + imageY + 1, this.lastY))) == -1 && ((block = world.a(startX + imageX, height - 1, startZ + imageY)) instanceof alf || block instanceof anq)) {
                            heightComp = baseHeight;
                        }
                    }
                    if (heightComp == -1) {
                        heightComp = height;
                    }
                    if ((diff = heightComp - height) != 0) {
                        sc = diff > 0 ? 1.0 : (diff < 0 ? -1.0 : 0.0);
                        sc /= 8.0;
                    }
                    if (this.options.heightmap) {
                        diff = height - this.lastY;
                        double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                        sc = diff > 0 ? sc + heightsc : sc - heightsc;
                    }
                } else if (this.options.heightmap) {
                    diff = height - this.lastY;
                    sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                    if (diff < 0) {
                        sc = 0.0 - sc;
                    }
                }
                int alpha = color24 >> 24 & 0xFF;
                int r = color24 >> 16 & 0xFF;
                int g = color24 >> 8 & 0xFF;
                int b = color24 >> 0 & 0xFF;
                if (sc > 0.0) {
                    r = (int)(sc * (double)(255 - r)) + r;
                    g = (int)(sc * (double)(255 - g)) + g;
                    b = (int)(sc * (double)(255 - b)) + b;
                } else if (sc < 0.0) {
                    sc = Math.abs(sc);
                    r -= (int)(sc * (double)r);
                    g -= (int)(sc * (double)g);
                    b -= (int)(sc * (double)b);
                }
                color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
            }
        }
        return color24;
    }

    private int getLight(int color24, int blockID, ahb world, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (color24 != this.colorManager.getAirColor() && color24 != 0 && this.options.lightmap) {
            apx chunk = world.d(x, z);
            int blockLight = chunk.a(ahn.b, x & 0xF, Math.max(Math.min(height, 255), 0), z & 0xF);
            int skyLight = chunk.a(ahn.a, x & 0xF, Math.max(Math.min(height, 255), 0), z & 0xF);
            if (blockID == BlockIDRepository.lavaID && blockLight < 14) {
                blockLight = 14;
            }
            i3 = this.lightmapColors[blockLight + skyLight * 16];
        }
        return i3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(int x, int y2, int scScale) {
        float multi2;
        boolean scaleChanged = this.scScale != scScale || this.options.squareMap != this.lastSquareMap;
        this.scScale = scScale;
        this.lastSquareMap = this.options.squareMap;
        if (GLUtils.hasAlphaBits) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glBindTexture((int)3553, (int)0);
            GL11.glBlendFunc((int)0, (int)0);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)255.0f);
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)(x - 47), (float)(y2 + 47));
            GL11.glVertex2f((float)(x + 47), (float)(y2 + 47));
            GL11.glVertex2f((float)(x + 47), (float)(y2 - 47));
            GL11.glVertex2f((float)(x - 47), (float)(y2 - 47));
            GL11.glEnd();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glBlendFunc((int)770, (int)771);
            GLUtils.img(new bqx("voxelmap", this.options.squareMap ? "images/square.png" : "images/circle.png"));
            GLUtils.drawPre();
            GLUtils.setMap(x, y2);
            GLUtils.drawPost();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glBlendFunc((int)772, (int)773);
            Object object = this.coordinateLock;
            synchronized (object) {
                if (this.imageChanged) {
                    this.imageChanged = false;
                    this.map[this.zoom].write();
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
            }
            multi2 = 2.0f / (float)Math.pow(2.0, this.zoom);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi2;
            this.percentY *= multi2;
            if (this.zoom == 3) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GLUtils.disp(this.map[this.zoom].index);
                GL11.glPopMatrix();
            } else {
                GLUtils.disp(this.map[this.zoom].index);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
            GL11.glRotatef((float)(this.options.squareMap ? (float)this.northRotate : -this.direction + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
            GL11.glTranslatef((float)(-this.percentX), (float)(-this.percentY), (float)0.0f);
            if (this.options.filtering) {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            }
        } else if (GLUtils.fboEnabled) {
            GL11.glBindTexture((int)3553, (int)0);
            GL11.glPushAttrib((int)22528);
            GL11.glViewport((int)0, (int)0, (int)256, (int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)256.0, (double)256.0, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GLUtils.bindFrameBuffer();
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            if (scaleChanged) {
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glClear((int)16384);
            }
            GL11.glBlendFunc((int)770, (int)0);
            GLUtils.img(new bqx("voxelmap", this.options.squareMap ? "images/square.png" : "images/circle.png"));
            GLUtils.drawPre();
            GLUtils.ldrawthree(0.0, 256.0, 1.0, 0.0, 0.0);
            GLUtils.ldrawthree(256.0, 256.0, 1.0, 1.0, 0.0);
            GLUtils.ldrawthree(256.0, 0.0, 1.0, 1.0, 1.0);
            GLUtils.ldrawthree(0.0, 0.0, 1.0, 0.0, 1.0);
            GLUtils.drawPost();
            GL14.glBlendFuncSeparate((int)1, (int)0, (int)774, (int)0);
            Object multi = this.coordinateLock;
            synchronized (multi) {
                if (this.imageChanged) {
                    this.imageChanged = false;
                    this.map[this.zoom].write();
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
            }
            multi2 = 2.0f / (float)Math.pow(2.0, this.zoom);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi2;
            this.percentY *= multi2;
            if (this.zoom == 3) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GLUtils.disp(this.map[this.zoom].index);
                GL11.glPopMatrix();
            } else {
                GLUtils.disp(this.map[this.zoom].index);
            }
            if (this.options.filtering) {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            }
            GL11.glTranslatef((float)128.0f, (float)128.0f, (float)0.0f);
            if (this.options.squareMap) {
                GL11.glRotatef((float)(-this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)(this.direction - (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)-128.0f, (float)-128.0f, (float)0.0f);
            GL11.glTranslatef((float)(-this.percentX * 4.0f), (float)(this.percentY * 4.0f), (float)0.0f);
            GLUtils.drawPre();
            GLUtils.ldrawthree(0.0, 256.0, 1.0, 0.0, 0.0);
            GLUtils.ldrawthree(256.0, 256.0, 1.0, 1.0, 0.0);
            GLUtils.ldrawthree(256.0, 0.0, 1.0, 1.0, 1.0);
            GLUtils.ldrawthree(0.0, 0.0, 1.0, 0.0, 1.0);
            GLUtils.drawPost();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GLUtils.unbindFrameBuffer();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            GL11.glPushMatrix();
            GL11.glBlendFunc((int)770, (int)0);
            GL11.glEnable((int)3008);
            GLUtils.disp(GLUtils.fboTextureID);
        } else {
            if (this.options.squareMap) {
                if (this.options.filtering && this.zoom == 0 && this.lastPercentXOver != this.percentX > 1.0f) {
                    this.lastPercentXOver = this.percentX > 1.0f;
                    this.imageChanged = true;
                }
                if (this.options.filtering && this.zoom == 0 && this.lastPercentYOver != this.percentY > 1.0f) {
                    this.lastPercentYOver = this.percentY > 1.0f;
                    this.imageChanged = true;
                }
            }
            if (this.imageChanged) {
                this.imageChanged = false;
                if (this.options.squareMap) {
                    multi = this.coordinateLock;
                    synchronized (multi) {
                        this.map[this.zoom].write();
                        this.lastImageX = this.lastX;
                        this.lastImageZ = this.lastZ;
                    }
                }
                int diameter = this.map[this.zoom].getWidth();
                if (this.roundImage != null) {
                    this.roundImage.baleet();
                }
                this.roundImage = new GLBufferedImage(diameter, diameter, 6);
                Ellipse2D.Double ellipse = new Ellipse2D.Double(this.zoom * 10 / 6, this.zoom * 10 / 6, diameter - this.zoom * 2, diameter - this.zoom * 2);
                Graphics2D gfx = this.roundImage.createGraphics();
                gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gfx.setClip(ellipse);
                gfx.setColor(new Color(0.1f, 0.0f, 0.0f, 0.1f));
                gfx.fillRect(0, 0, diameter, diameter);
                Object object = this.coordinateLock;
                synchronized (object) {
                    gfx.drawImage((Image)this.map[this.zoom], 0, 0, null);
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
                gfx.dispose();
                this.roundImage.write();
            }
            multi2 = 2.0f / (float)Math.pow(2.0, this.zoom);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi2;
            this.percentY *= multi2;
            GL11.glBlendFunc((int)770, (int)0);
            if (this.zoom == 3) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GLUtils.disp(this.options.squareMap ? this.map[this.zoom].index : this.roundImage.index);
                GL11.glPopMatrix();
            } else {
                GLUtils.disp(this.options.squareMap ? this.map[this.zoom].index : this.roundImage.index);
            }
            if (this.options.filtering) {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
            GL11.glRotatef((float)(this.options.squareMap ? (float)this.northRotate : -this.direction + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
            GL11.glTranslatef((float)(-this.percentX), (float)(-this.percentY), (float)0.0f);
        }
        GLUtils.drawPre();
        GLUtils.setMap(x, y2);
        GLUtils.drawPost();
        GL11.glPopMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.options.squareMap) {
            this.drawSquareMapFrame(x, y2);
        } else {
            this.drawRoundMapFrame(x, y2);
        }
        double lastXDouble = GameVariableAccessShim.xCoordDouble();
        double lastZDouble = GameVariableAccessShim.zCoordDouble();
        for (Waypoint pt : this.waypointManager.getWaypoints()) {
            if (!pt.isActive()) continue;
            double wayX = lastXDouble - (double)pt.getX() - 0.5;
            double wayY = lastZDouble - (double)pt.getZ() - 0.5;
            float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
            double hypot = Math.sqrt(wayX * wayX + wayY * wayY);
            boolean far = false;
            if (this.options.squareMap) {
                boolean bl2 = far = Math.abs(wayX) / (Math.pow(2.0, this.zoom) / 2.0) > 28.5 || Math.abs(wayY) / (Math.pow(2.0, this.zoom) / 2.0) > 28.5;
                hypot = far ? hypot / Math.max(Math.abs(wayX), Math.abs(wayY)) * 30.0 : (hypot /= Math.pow(2.0, this.zoom) / 2.0);
            } else {
                locate += this.direction;
                boolean bl3 = far = (hypot /= Math.pow(2.0, this.zoom) / 2.0) >= 31.0;
                if (far) {
                    hypot = 34.0;
                }
            }
            if (far) {
                try {
                    GL11.glPushMatrix();
                    GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                    if (scScale >= 3) {
                        GLUtils.img(new bqx("voxelmap", "images/marker" + pt.imageSuffix + ".png"));
                    } else {
                        GLUtils.img(new bqx("voxelmap", "images/marker" + pt.imageSuffix + "Small.png"));
                    }
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
                    GL11.glRotatef((float)(-locate + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
                    GL11.glTranslated((double)0.0, (double)(-hypot), (double)0.0);
                    GLUtils.drawPre();
                    GLUtils.setMap(x, y2, 16);
                    GLUtils.drawPost();
                    continue;
                }
                catch (Exception localException) {
                    this.error = "Error: marker overlay not found!";
                    continue;
                }
                finally {
                    GL11.glPopMatrix();
                    continue;
                }
            }
            try {
                GL11.glPushMatrix();
                GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                if (scScale >= 3) {
                    GLUtils.img(new bqx("voxelmap", "images/waypoint" + pt.imageSuffix + ".png"));
                } else {
                    GLUtils.img(new bqx("voxelmap", "images/waypoint" + pt.imageSuffix + "Small.png"));
                }
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                GL11.glRotatef((float)(-locate + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.0, (double)(-hypot), (double)0.0);
                GL11.glRotatef((float)(-(-locate + (float)this.northRotate)), (float)0.0f, (float)0.0f, (float)1.0f);
                GLUtils.drawPre();
                GLUtils.setMap(x, y2, 16);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                this.error = "Error: waypoint overlay not found!";
            }
            finally {
                GL11.glPopMatrix();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArrow(int x, int y2) {
        try {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushMatrix();
            GLUtils.img(new bqx("voxelmap", "images/mmarrow.png"));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
            GL11.glRotatef((float)this.direction, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
            GLUtils.drawPre();
            GLUtils.setMap(x, y2, 16);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap arrow not found!";
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMapFull(int scWidth, int scHeight) {
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.map[this.zoom].write();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        GLUtils.disp(this.map[this.zoom].index);
        if (this.options.filtering) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)scWidth / 2.0f), (float)((float)scHeight / 2.0f), (float)0.0f);
        GL11.glRotatef((float)this.northRotate, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-((float)scWidth / 2.0f)), (float)(-((float)scHeight / 2.0f)), (float)0.0f);
        GLUtils.drawPre();
        int left = scWidth / 2 - 128;
        int top = scHeight / 2 - 128;
        GLUtils.ldrawone(left, top + 256, 67.0, 0.0, 1.0);
        GLUtils.ldrawone(left + 256, top + 256, 67.0, 1.0, 1.0);
        GLUtils.ldrawone(left + 256, top, 67.0, 1.0, 0.0);
        GLUtils.ldrawone(left, top, 67.0, 0.0, 0.0);
        GLUtils.drawPost();
        GL11.glPopMatrix();
        if (this.options.biomeOverlay > 0) {
            int factor = (int)Math.pow(2.0, 3 - this.zoom);
            int minimumSize = (int)Math.pow(2.0, this.zoom);
            minimumSize *= minimumSize;
            ArrayList<MapData.BiomeLabel> labels = this.mapData[this.zoom].getBiomeLabels();
            GL11.glDisable((int)2929);
            for (int t = 0; t < labels.size(); ++t) {
                MapData.BiomeLabel label = labels.get(t);
                if (label.size <= minimumSize) continue;
                String name = ahu.n()[label.biomeInt].af;
                int nameWidth = this.chkLen(name);
                int x = label.x * factor;
                int z = label.z * factor;
                if (this.options.oldNorth) {
                    this.write(name, left + 256 - z - nameWidth / 2, top + x - 3, 0xFFFFFF);
                    continue;
                }
                this.write(name, left + x - nameWidth / 2, top + z - 3, 0xFFFFFF);
            }
            GL11.glEnable((int)2929);
        }
    }

    private void drawSquareMapFrame(int x, int y2) {
        try {
            GLUtils.disp(this.colorManager.getMapImageInt());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GLUtils.drawPre();
            GLUtils.setMap(x, y2);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "error: minimap overlay not found!";
        }
    }

    private void drawRoundMapFrame(int x, int y2) {
        try {
            GLUtils.img(new bqx("voxelmap", "images/roundmap.png"));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLUtils.drawPre();
            GLUtils.setMap(x, y2);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap overlay not found!";
        }
    }

    private void drawDirections(int x, int y2) {
        float distance;
        float rotate;
        if (this.options.squareMap) {
            rotate = -90.0f;
            distance = 67.0f;
        } else {
            rotate = -this.direction - 90.0f;
            distance = 64.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-((double)rotate - 90.0)))), (double)((double)distance * Math.cos(Math.toRadians(-((double)rotate - 90.0)))), (double)0.0);
        this.write("N", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-rotate))), (double)((double)distance * Math.cos(Math.toRadians(-rotate))), (double)0.0);
        this.write("E", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-((double)rotate + 90.0)))), (double)((double)distance * Math.cos(Math.toRadians(-((double)rotate + 90.0)))), (double)0.0);
        this.write("S", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-((double)rotate + 180.0)))), (double)((double)distance * Math.cos(Math.toRadians(-((double)rotate + 180.0)))), (double)0.0);
        this.write("W", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void showCoords(int x, int y2) {
        int textStart = y2 > this.scHeight - 37 - 32 - 4 - 15 ? y2 - 32 - 4 - 9 : y2 + 32 + 4;
        if (!this.options.hide && !this.fullscreenMap) {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            String xy = "";
            xy = this.dCoord(GameVariableAccessShim.xCoord()) + ", " + this.dCoord(GameVariableAccessShim.zCoord());
            int m = this.chkLen(xy) / 2;
            this.write(xy, x * 2 - m, textStart * 2, 0xFFFFFF);
            xy = Integer.toString(GameVariableAccessShim.yCoord());
            m = this.chkLen(xy) / 2;
            this.write(xy, x * 2 - m, textStart * 2 + 10, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(this.error, x * 2 - m, textStart * 2 + 19, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        } else {
            String stats = "";
            stats = "(" + this.dCoord(GameVariableAccessShim.xCoord()) + ", " + GameVariableAccessShim.yCoord() + ", " + this.dCoord(GameVariableAccessShim.zCoord()) + ") " + (int)this.direction + "'";
            int m = this.chkLen(stats) / 2;
            this.write(stats, this.scWidth / 2 - m, 5, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(this.error, this.scWidth / 2 - m, 15, 0xFFFFFF);
            }
        }
    }

    private String dCoord(int paramInt1) {
        if (paramInt1 < 0) {
            return "-" + Math.abs(paramInt1);
        }
        if (paramInt1 > 0) {
            return "+" + paramInt1;
        }
        return " " + paramInt1;
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.a(paramStr);
    }

    private void write(String paramStr, int paramInt1, int paramInt2, int paramInt3) {
        this.fontRenderer.a(paramStr, paramInt1, paramInt2, paramInt3);
    }

    public void setMenuNull() {
        this.game.n = null;
    }

    public Object getMenu() {
        return this.game.n;
    }

    private void showMenu(int scWidth, int scHeight) {
        int height;
        GL11.glBlendFunc((int)770, (int)771);
        int maxSize = 0;
        int border = 2;
        String head = this.sMenu[0];
        for (height = 1; height < this.sMenu.length - 1; ++height) {
            if (this.chkLen(this.sMenu[height]) <= maxSize) continue;
            maxSize = this.chkLen(this.sMenu[height]);
        }
        int title = this.chkLen(head);
        int centerX = (int)((double)(scWidth + 5) / 2.0);
        int centerY = (int)((double)(scHeight + 5) / 2.0);
        String hide = this.sMenu[this.sMenu.length - 1];
        int footer = this.chkLen(hide);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        double leftX = (double)centerX - (double)title / 2.0 - (double)border;
        double rightX = (double)centerX + (double)title / 2.0 + (double)border;
        double topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border - 20.0;
        double botY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 + (double)border - 10.0;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)maxSize / 2.0 - (double)border;
        rightX = (double)centerX + (double)maxSize / 2.0 + (double)border;
        topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)footer / 2.0 - (double)border;
        rightX = (double)centerX + (double)footer / 2.0 + (double)border;
        topY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 - (double)border + 10.0;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border + 20.0;
        this.drawBox(leftX, rightX, topY, botY);
        GL11.glEnable((int)3553);
        this.write(head, centerX - title / 2, centerY - (height - 1) * 10 / 2 - 19, 0xFFFFFF);
        for (int n = 1; n < height; ++n) {
            this.write(this.sMenu[n], centerX - maxSize / 2, centerY - (height - 1) * 10 / 2 + n * 10 - 9, 0xFFFFFF);
        }
        this.write(hide, centerX - footer / 2, (scHeight + 5) / 2 + (height - 1) * 10 / 2 + 11, 0xFFFFFF);
    }

    private void drawBox(double leftX, double rightX, double topY, double botY) {
        GLUtils.drawPre();
        GLUtils.ldrawtwo(leftX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, topY, 0.0);
        GLUtils.ldrawtwo(leftX, topY, 0.0);
        GLUtils.drawPost();
    }
}

