/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.gui;

import com.thevoxelbox.voxelmap.gui.GuiWaypoints;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.I18nUtils;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

class GuiSlotWaypoints
extends bcm {
    private ArrayList<Waypoint> waypoints;
    final GuiWaypoints parentGui;

    public GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(par1GuiWaypoints.options.game, par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), 54, par1GuiWaypoints.getHeight() - 65 + 4, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(pt);
        }
    }

    protected int b() {
        return this.waypoints.size();
    }

    protected void a(int par1, boolean par2, int par3, int par4) {
        this.parentGui.setSelectedWaypoint(this.waypoints.get(par1));
        int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
        int padding = 3;
        int width = 215;
        if (this.g >= leftEdge + width - 16 - padding && this.g <= leftEdge + width + padding) {
            this.parentGui.toggleWaypointVisibility();
        } else if (par2) {
            Mouse.next();
            this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            return;
        }
    }

    protected boolean a(int par1) {
        return this.waypoints.get(par1).equals(this.parentGui.selectedWaypoint);
    }

    protected int e() {
        return this.b() * 18;
    }

    protected void a() {
        this.parentGui.c();
    }

    protected void a(int par1, int par2, int par3, int par4, bmh par5Tessellator, int par6, int par7) {
        Waypoint waypoint = this.waypoints.get(par1);
        this.parentGui.a(this.parentGui.getFontRenderer(), waypoint.name, this.parentGui.getWidth() / 2, par3 + 3, waypoint.getUnified());
        int padding = 3;
        if (this.g >= par2 - padding && this.h >= par3 && this.g <= par2 + 215 + padding && this.h <= par3 + this.f) {
            String tooltip;
            if (this.g >= par2 + 215 - 16 - padding && this.g <= par2 + 215 + padding) {
                tooltip = waypoint.enabled ? I18nUtils.getString("minimap.waypoints.disable") : I18nUtils.getString("minimap.waypoints.enable");
            } else {
                tooltip = "X: " + waypoint.getX() + " Z: " + waypoint.getZ();
                if (waypoint.getY() > 0) {
                    tooltip = tooltip + " Y: " + waypoint.getY();
                }
            }
            GuiWaypoints.setTooltip(this.parentGui, tooltip);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLUtils.img("textures/gui/container/inventory.png");
        int xOffset = waypoint.enabled ? 72 : 90;
        int yOffset = 216;
        this.parentGui.b(par2 + 198, par3 - 2, xOffset, yOffset, 16, 16);
    }

    protected void sortBy(int sortKey, boolean ascending) {
        int order;
        int n = order = ascending ? 1 : -1;
        if (sortKey == this.parentGui.options.SORT_DATE) {
            final ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                @Override
                public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                    return Double.compare(masterWaypointsList.indexOf(waypoint1), masterWaypointsList.indexOf(waypoint2)) * order;
                }
            });
        } else if (sortKey == this.parentGui.options.SORT_DISTANCE) {
            if (ascending) {
                Collections.sort(this.waypoints);
            } else {
                Collections.sort(this.waypoints, Collections.reverseOrder());
            }
        } else if (sortKey == this.parentGui.options.SORT_NAME) {
            final Collator collator = I18nUtils.getLocaleAwareCollator();
            Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                @Override
                public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                    return collator.compare(waypoint1.name, waypoint2.name) * order;
                }
            });
        } else if (sortKey == this.parentGui.options.SORT_COLOR) {
            Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                @Override
                public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                    float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                    float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                    return Double.compare(hue1, hue2) * order;
                }
            });
        }
    }
}

