/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelpacket.client.VoxelPacketClient;
import com.thevoxelbox.voxelpacket.common.VoxelMessage;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessagePublisher;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessageSubscriber;

public class PacketHandler
implements IVoxelMessageSubscriber {
    private IVoxelMap map;
    protected static PacketHandler instance;

    public PacketHandler(IVoxelMap map) {
        this.map = map;
        VoxelPacketClient.getInstance().subscribe((IVoxelMessageSubscriber)this, "VWNAME");
        VoxelPacketClient.getInstance().subscribe((IVoxelMessageSubscriber)this, "VTHASH");
        instance = this;
    }

    public void onServerConnect(fb netclienthandler) {
        this.map.newSubWorldName("");
        this.map.newSubWorldHash("");
    }

    public void receiveMessage(IVoxelMessagePublisher publisher, VoxelMessage message) {
        if (message.shortCode.equals("VWNAME")) {
            String worldName = (String)message.data();
            System.out.println("New Name: " + worldName);
            this.map.newSubWorldName(worldName);
        } else if (message.shortCode.equals("VTHASH")) {
            String worldHash = (String)message.data();
            System.out.println("New Hash: " + worldHash);
            this.map.newSubWorldHash(worldHash);
        }
    }

    public void receiveMessageClassCastFailure(IVoxelMessagePublisher publisher, VoxelMessage message, ClassCastException ex) {
    }
}

