/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import java.io.Serializable;
import java.util.TreeSet;

public class Waypoint
implements Serializable,
Comparable {
    private static final long serialVersionUID = 8136790917447997951L;
    public String name;
    public String imageSuffix = "";
    public String world = "";
    public TreeSet<Integer> dimensions = new TreeSet();
    public int x;
    public int z;
    public int y;
    public boolean enabled;
    public boolean inWorld = true;
    public boolean inDimension = true;
    public float red = 0.0f;
    public float green = 1.0f;
    public float blue = 0.0f;

    public Waypoint(String name, int x, int z, int y2, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<Integer> dimensions) {
        this.name = name;
        this.x = x;
        this.z = z;
        this.y = y2;
        this.enabled = enabled;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.imageSuffix = suffix;
        this.world = world;
        this.dimensions = dimensions;
    }

    public int getUnified() {
        return -16777216 + ((int)(this.red * 255.0f) << 16) + ((int)(this.green * 255.0f) << 8) + (int)(this.blue * 255.0f);
    }

    public boolean isActive() {
        return this.enabled && this.inWorld && this.inDimension;
    }

    public int getX() {
        return bao.B().h.ap == -1 ? this.x / 8 : this.x;
    }

    public int getZ() {
        return bao.B().h.ap == -1 ? this.z / 8 : this.z;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = bao.B().h.ap == -1 ? x * 8 : x;
    }

    public void setZ(int z) {
        this.z = bao.B().h.ap == -1 ? z * 8 : z;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public int compareTo(Object arg0) {
        double myDistance = this.getDistanceSqToEntity((sa)bao.B().h);
        double comparedDistance = ((Waypoint)arg0).getDistanceSqToEntity((sa)bao.B().h);
        return Double.compare(myDistance, comparedDistance);
    }

    public double getDistanceSqToEntity(sa par1Entity) {
        double var2 = (double)this.getX() - par1Entity.s;
        double var4 = (double)this.getY() - par1Entity.t;
        double var6 = (double)this.getZ() - par1Entity.u;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }
}

