/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.mumfrey.liteloader.HUDRenderListener;
import com.mumfrey.liteloader.InitCompleteListener;
import com.mumfrey.liteloader.JoinGameListener;
import com.mumfrey.liteloader.Permissible;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.permissions.PermissionsManager;
import com.mumfrey.liteloader.permissions.PermissionsManagerClient;
import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.PacketHandler;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import java.io.File;

public class LiteModVoxelMap
implements InitCompleteListener,
HUDRenderListener,
JoinGameListener,
Permissible {
    VoxelMap map;
    PacketHandler packetHandler;
    private long lastTick = 0L;
    private boolean hasVoxelPlugins = true;
    private boolean hasRadarPermission = true;
    private boolean hasCavemodePermission = true;

    public String getName() {
        if (ReflectionUtils.classExists("com.thevoxelbox.voxelmap.Radar")) {
            return "VoxelMap";
        }
        return "VoxelMapNoRadar";
    }

    public String getVersion() {
        return "1.2.0";
    }

    public void init(File configPath) {
        this.hasVoxelPlugins = this.hasVoxelPlugins && ReflectionUtils.classExists("com.thevoxelbox.voxelpacket.client.VoxelPacketClient");
        this.hasVoxelPlugins = this.hasVoxelPlugins && ReflectionUtils.classExists("com.thevoxelbox.voxelpacket.common.VoxelMessage");
        this.hasVoxelPlugins = this.hasVoxelPlugins && ReflectionUtils.classExists("com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessagePublisher");
        this.hasVoxelPlugins = this.hasVoxelPlugins && ReflectionUtils.classExists("com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessageSubscriber");
    }

    public void onInitCompleted(bao minecraft, LiteLoader loader) {
        this.map = new VoxelMap(true, false);
        if (this.hasVoxelPlugins) {
            this.packetHandler = new PacketHandler(this.map);
        }
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    public void onTick(bao minecraft, float partialTicks, boolean inGame, boolean clock) {
    }

    public void onPreRenderHUD(int screenWidth, int screenHeight) {
    }

    public void onPostRenderHUD(int screenWidth, int screenHeight) {
        boolean inGame;
        bao minecraft = bao.B();
        boolean bl = inGame = minecraft.i != null && minecraft.i.o != null;
        if (inGame) {
            this.map.onTickInGame(minecraft);
        }
    }

    public void onJoinGame(fb netHandler, hd joinGamePacket) {
        if (this.hasVoxelPlugins && this.packetHandler != null) {
            this.packetHandler.onServerConnect(netHandler);
        }
    }

    public String getPermissibleModName() {
        return this.getName().toLowerCase();
    }

    public float getPermissibleModVersion() {
        return Float.parseFloat(this.getVersion().replace(".", ""));
    }

    public void registerPermissions(PermissionsManagerClient permissionsManager) {
        permissionsManager.registerModPermission((Permissible)this, "radar");
        permissionsManager.registerModPermission((Permissible)this, "cavemode");
    }

    public void onPermissionsCleared(PermissionsManager manager) {
        this.hasRadarPermission = true;
        this.hasCavemodePermission = true;
    }

    public void onPermissionsChanged(PermissionsManager manager) {
        this.hasRadarPermission = ((PermissionsManagerClient)manager).getModPermission((Permissible)this, "radar");
        this.hasCavemodePermission = manager.getPermissions((Permissible)this).getHasPermission("mod.voxelmap.cavemode");
        this.map.setPermissions(this.hasRadarPermission, this.hasCavemodePermission);
    }
}

