/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class ImageUtils {
    public static BufferedImage createBufferedImageFromGLID(int id) {
        GL11.glBindTexture((int)3553, (int)id);
        return ImageUtils.createBufferedImageFromCurrentGLImage();
    }

    public static BufferedImage createBufferedImageFromCurrentGLImage() {
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        BufferedImage image = new BufferedImage(width, height, 6);
        byteBuffer.position(0);
        byte[] var4 = new byte[byteBuffer.remaining()];
        byteBuffer.get(var4);
        for (int var5 = 0; var5 < width; ++var5) {
            for (int var6 = 0; var6 < height; ++var6) {
                int var7 = var6 * width * 4 + var5 * 4;
                int var8 = 0;
                int var10 = var8 | (var4[var7 + 2] & 0xFF) << 0;
                var10 |= (var4[var7 + 1] & 0xFF) << 8;
                var10 |= (var4[var7 + 0] & 0xFF) << 16;
                image.setRGB(var5, var6, var10 |= (var4[var7 + 3] & 0xFF) << 24);
            }
        }
        return image;
    }

    public static BufferedImage blankImage(String path, int w, int h) {
        return ImageUtils.blankImage(path, w, h, 64, 32);
    }

    public static BufferedImage blankImage(String path, int w, int h, int imageWidth, int imageHeight) {
        return ImageUtils.blankImage(path, w, h, imageWidth, imageHeight, 0, 0, 0, 0);
    }

    public static BufferedImage blankImage(String path, int w, int h, int r, int g, int b, int a) {
        return ImageUtils.blankImage(path, w, h, 64, 32, r, g, b, a);
    }

    public static BufferedImage blankImage(String path, int w, int h, int imageWidth, int imageHeight, int r, int g, int b, int a) {
        try {
            InputStream is = bao.B().Q().a(new bqx(path)).b();
            BufferedImage mobSkin = ImageIO.read(is);
            is.close();
            BufferedImage temp = new BufferedImage(w * mobSkin.getWidth() / imageWidth, h * mobSkin.getWidth() / imageWidth, 6);
            Graphics2D g2 = temp.createGraphics();
            g2.setColor(new Color(r, g, b, a));
            g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
            g2.dispose();
            return temp;
        }
        catch (Exception e) {
            System.err.println("Failed getting mob: " + path + " - " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h) {
        return ImageUtils.blankImage(mobSkin, w, h, 64, 32);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int imageWidth, int imageHeight) {
        return ImageUtils.blankImage(mobSkin, w, h, imageWidth, imageHeight, 0, 0, 0, 0);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int r, int g, int b, int a) {
        return ImageUtils.blankImage(mobSkin, w, h, 64, 32, r, g, b, a);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int imageWidth, int imageHeight, int r, int g, int b, int a) {
        BufferedImage temp = new BufferedImage(w * mobSkin.getWidth() / imageWidth, h * mobSkin.getWidth() / imageWidth, 6);
        Graphics2D g2 = temp.createGraphics();
        g2.setColor(new Color(r, g, b, a));
        g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
        g2.dispose();
        return temp;
    }

    public static BufferedImage addCharacter(BufferedImage image, String character) {
        Graphics2D g2 = image.createGraphics();
        g2.setColor(new Color(0, 0, 0, 255));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(new Font("Arial", 0, image.getHeight()));
        FontMetrics fm = g2.getFontMetrics();
        int x = (image.getWidth() - fm.stringWidth("?")) / 2;
        int y2 = fm.getAscent() + (image.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
        g2.drawString("?", x, y2);
        g2.dispose();
        return image;
    }

    public static BufferedImage loadImage(bqx resourceLocation, int x, int y2, int w, int h) {
        return ImageUtils.loadImage(resourceLocation, x, y2, w, h, 64, 32);
    }

    public static BufferedImage loadImage(bqx resourceLocation, int x, int y2, int w, int h, int imageWidth, int imageHeight) {
        try {
            InputStream is = bao.B().Q().a(resourceLocation).b();
            BufferedImage mobSkin = ImageIO.read(is);
            is.close();
            return ImageUtils.loadImage(mobSkin, x, y2, w, h, imageWidth, imageHeight);
        }
        catch (Exception e) {
            System.err.println("Failed getting mob: " + resourceLocation.toString() + " - " + e.getLocalizedMessage());
            return null;
        }
    }

    public static BufferedImage loadImage(BufferedImage mobSkin, int x, int y2, int w, int h) {
        return ImageUtils.loadImage(mobSkin, x, y2, w, h, 64, 32);
    }

    public static BufferedImage loadImage(BufferedImage mobSkin, int x, int y2, int w, int h, int imageWidth, int imageHeight) {
        if (mobSkin.getType() != 6) {
            BufferedImage temp = new BufferedImage(mobSkin.getWidth(), mobSkin.getHeight(), 6);
            Graphics2D g2 = temp.createGraphics();
            g2.drawImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), null);
            g2.dispose();
            mobSkin = temp;
        }
        float scale = mobSkin.getWidth(null) / imageWidth;
        BufferedImage base = mobSkin.getSubimage((int)((float)x * scale), (int)((float)y2 * scale), (int)((float)w * scale), (int)((float)h * scale));
        return base;
    }

    public static BufferedImage addImages(BufferedImage base, BufferedImage overlay, float x, int y2, int baseWidth, int baseHeight) {
        int scale = base.getWidth() / baseWidth;
        Graphics gfx = base.getGraphics();
        gfx.drawImage(overlay, (int)(x * (float)scale), y2 * scale, null);
        gfx.dispose();
        return base;
    }

    public static BufferedImage scaleImage(BufferedImage image, float scaleBy) {
        BufferedImage tmp = new BufferedImage((int)((float)image.getWidth() * scaleBy), (int)((float)image.getHeight() * scaleBy), image.getType());
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage(image, 0, 0, (int)((float)image.getWidth() * scaleBy), (int)((float)image.getHeight() * scaleBy), null);
        g2.dispose();
        image = tmp;
        return image;
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-image.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage into128(BufferedImage base) {
        BufferedImage frame = new BufferedImage(128, 128, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, 64 - base.getWidth() / 2, 64 - base.getHeight() / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage intoSquare(BufferedImage base) {
        int dim = Math.max(base.getWidth(), base.getHeight());
        int t = 1;
        while (Math.pow(2.0, t - 1) < (double)dim) {
            ++t;
        }
        int size = (int)Math.pow(2.0, t);
        BufferedImage frame = new BufferedImage(size, size, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, (size - base.getWidth()) / 2, (size - base.getHeight()) / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean outline) {
        return ImageUtils.fillOutline(image, outline, false, false, 0);
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean outline, boolean armor, boolean isCustomModel, int entry) {
        if (outline && entry != 2 && entry != 3 && entry != -1) {
            image = ImageUtils.fillOutline(image, true, armor, isCustomModel);
        }
        image = ImageUtils.fillOutline(image, false, armor, isCustomModel);
        return image;
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean solid, boolean armor, boolean isCustomModel) {
        float armorOutlineFraction = isCustomModel ? 2.29f : 4.0f;
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics gfx = temp.getGraphics();
        gfx.drawImage(image, 0, 0, null);
        gfx.dispose();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        for (int t = 0; t < image.getWidth(); ++t) {
            for (int s = 0; s < image.getHeight(); ++s) {
                int newColor;
                int color = image.getRGB(s, t);
                if ((color >> 24 & 0xFF) != 0 || (newColor = ImageUtils.getNonTransparentPixel(s, t, image)) == -420) continue;
                if (solid) {
                    newColor = !armor || (float)t <= (float)imageWidth / armorOutlineFraction || (float)t >= (float)(imageWidth - 1) - (float)imageWidth / armorOutlineFraction || (float)s <= (float)imageHeight / armorOutlineFraction || (float)s >= (float)(imageHeight - 1) - (float)imageHeight / armorOutlineFraction ? -16777216 : 0;
                } else {
                    int red = newColor >> 16 & 0xFF;
                    int green = newColor >> 8 & 0xFF;
                    int blue = newColor >> 0 & 0xFF;
                    newColor = 0 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                }
                temp.setRGB(s, t, newColor);
            }
        }
        return temp;
    }

    public static int getNonTransparentPixel(int x, int y2, BufferedImage image) {
        int color;
        if (x > 0 && ((color = image.getRGB(x - 1, y2)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && ((color = image.getRGB(x + 1, y2)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y2 > 0 && ((color = image.getRGB(x, y2 - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y2 < image.getHeight() - 1 && ((color = image.getRGB(x, y2 + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y2 > 0 && ((color = image.getRGB(x - 1, y2 - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y2 < image.getHeight() - 1 && ((color = image.getRGB(x - 1, y2 + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && y2 > 0 && ((color = image.getRGB(x + 1, y2 - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && y2 < image.getHeight() - 1 && ((color = image.getRGB(x + 1, y2 + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        return -420;
    }

    public static BufferedImage trim(BufferedImage image) {
        int t;
        int left = -1;
        int right = image.getWidth();
        int top = -1;
        int bottom = image.getHeight();
        boolean foundColor = false;
        int color = 0;
        while (!foundColor) {
            ++left;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(left, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor) {
            --right;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(right, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor) {
            ++top;
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, top);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor) {
            --bottom;
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, bottom);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        image = image.getSubimage(left, top, right - left + 1, bottom - top + 1);
        return image;
    }

    public static float percentageOfEdgePixelsThatAreSolid(BufferedImage image) {
        int t;
        int edgePixels = image.getWidth() * 2 + image.getHeight() * 2 - 2;
        int edgePixelsWithColor = 0;
        int color = 0;
        for (t = 0; t < image.getHeight(); ++t) {
            color = image.getRGB(0, t);
            if (color >> 24 != 0) {
                ++edgePixelsWithColor;
            }
            if ((color = image.getRGB(image.getWidth() - 1, t)) >> 24 == 0) continue;
            ++edgePixelsWithColor;
        }
        for (t = 1; t < image.getWidth() - 1; ++t) {
            color = image.getRGB(t, 0);
            if (color >> 24 != 0) {
                ++edgePixelsWithColor;
            }
            if ((color = image.getRGB(t, image.getHeight() - 1)) >> 24 == 0) continue;
            ++edgePixelsWithColor;
        }
        return edgePixelsWithColor / edgePixels;
    }
}

