/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import noppes.mpm.ModelData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.PacketHandlerServer;
import noppes.mpm.PlayerDataController;
import noppes.mpm.Server;
import noppes.mpm.client.ChatMessages;
import noppes.mpm.constants.EnumPackets;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBuf buf = event.packet.payload();
        try {
            this.handlePacket(buf, (EntityPlayer)player, EnumPackets.values()[buf.readInt()]);
        }
        catch (Exception e) {
            System.err.println(player + e.getMessage());
            e.printStackTrace();
        }
    }

    private void handlePacket(ByteBuf buffer, EntityPlayer player, EnumPackets type) throws IOException {
        if (type == EnumPackets.PING) {
            MorePlayerModels.HasServerSide = true;
        } else if (type == EnumPackets.SEND_PLAYER_DATA) {
            EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
            if (pl == null) {
                return;
            }
            ModelData data = PlayerDataController.instance.getPlayerData(pl);
            NBTTagCompound compound = Server.readNBT(buffer);
            data.readFromNBT(compound);
            PlayerDataController.instance.savePlayerData(pl, data);
        } else if (type == EnumPackets.CHAT_EVENT) {
            EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
            if (pl == null) {
                return;
            }
            String message = Server.readString(buffer);
            ChatMessages.getChatMessages(pl.func_70005_c_()).addMessage(message);
        } else if (type == EnumPackets.BACK_ITEM_REMOVE) {
            EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
            if (pl == null) {
                return;
            }
            ModelData data = PlayerDataController.instance.getPlayerData(pl);
            data.backItem = null;
        } else if (type == EnumPackets.BACK_ITEM_UPDATE) {
            EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
            if (pl == null) {
                return;
            }
            NBTTagCompound compound = Server.readNBT(buffer);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)compound);
            ModelData data = PlayerDataController.instance.getPlayerData(pl);
            data.backItem = item;
        } else if (type == EnumPackets.PARTICLE) {
            int animation = buffer.readInt();
            if (animation == 0) {
                EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
                if (pl == null) {
                    return;
                }
                ModelData data = PlayerDataController.instance.getPlayerData(pl);
                data.inLove = 40;
            } else if (animation == 1) {
                player.field_70170_p.func_72869_a("note", buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), 0.0, 0.0);
            } else if (animation == 2) {
                EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
                if (pl == null) {
                    return;
                }
                ModelData data = PlayerDataController.instance.getPlayerData(pl);
                for (int i = 0; i < 5; ++i) {
                    double d0 = player.func_70681_au().nextGaussian() * 0.02;
                    double d1 = player.func_70681_au().nextGaussian() * 0.02;
                    double d2 = player.func_70681_au().nextGaussian() * 0.02;
                    double x = player.field_70165_t + (double)((player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 2.0f);
                    double z = player.field_70161_v + (double)((player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 2.0f);
                    player.field_70170_p.func_72869_a("angryVillager", x, player.field_70163_u + (double)0.8f + (double)(player.func_70681_au().nextFloat() * player.field_70131_O / 2.0f) - player.func_70033_W() - (double)data.getBodyY(), z, d0, d1, d2);
                }
            }
        } else if (type == EnumPackets.ANIMATION) {
            EntityPlayer pl = player.field_70170_p.func_72924_a(Server.readString(buffer));
            if (pl == null) {
                return;
            }
            ModelData data = PlayerDataController.instance.getPlayerData(pl);
            data.setAnimation(buffer.readInt());
            data.animationStart = pl.field_70173_aa;
        }
    }
}

