/*
 * Decompiled with CFR 0.152.
 */
package me.saxon564.mochickens.mobs;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import java.util.UUID;
import me.saxon564.mochickens.MoChickens;
import me.saxon564.mochickens.misc.ChickAITempt;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEnderChicken
extends EntityTameable {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 1.2599999809265137, 0).func_111168_a(false);
    private int stareTimer;
    private Entity lastEntityToAttack;
    private boolean isAggressive;
    private int teleportDelay;
    public boolean field_70885_d = false;
    public float field_70886_e = 0.0f;
    public float destPos = 0.0f;
    public float field_70884_g;
    public float field_70888_h;
    public float field_70889_i = 1.0f;
    private EnumDifficulty checked;
    private boolean despawn;
    private int ran;
    public int timeUntilNextEgg;

    public EntityEnderChicken(World par1World) {
        super(par1World);
        this.checked = this.field_70170_p.field_73013_u;
        this.func_70105_a(0.3f, 0.7f);
        float f = 0.25f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.timeUntilNextEgg = -1;
        this.func_70903_f(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public final void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        String s = "";
        if (par1NBTTagCompound.func_150297_b("OwnerUUID", 8)) {
            s = par1NBTTagCompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = par1NBTTagCompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.func_70903_f(true);
            this.func_152115_b(s);
        }
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return true;
    }

    protected boolean func_70692_ba() {
        if (this.ran == 0) {
            this.ran = 1;
        }
        return this.despawn;
    }

    public void func_70903_f(boolean par1) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 4)));
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
            this.field_70715_bh.field_75782_a.clear();
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new ChickAITempt((EntityCreature)this, 1.0, (Item)Item.field_150901_e.func_82594_a("ender_eye"), false));
            if (!MoChickens.enderTamedDespawn) {
                this.despawn = false;
                this.ran = 0;
                this.func_70692_ba();
            } else {
                this.despawn = true;
                this.ran = 0;
                this.func_70692_ba();
            }
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(2000) + 6000;
        } else {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFB)));
            if (!MoChickens.enderUntamedDespawn) {
                this.despawn = false;
                this.ran = 0;
                this.func_70692_ba();
            } else {
                this.despawn = true;
                this.ran = 0;
                this.func_70692_ba();
            }
        }
        if (this.field_70170_p.field_73013_u.toString() == "PEACEFUL") {
            this.difficultyChange();
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (!this.func_70909_n()) {
            boolean flag;
            EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            float f = 6.0f;
            int i = 0;
            if (entityplayer instanceof EntityLivingBase) {
                f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)entityplayer);
                i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)entityplayer);
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 3));
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 5));
            }
            if (flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
                int j;
                if (i > 0) {
                    entityplayer.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                    entityplayer.func_70015_d(j * 4);
                }
                if (entityplayer instanceof EntityLivingBase) {
                    EnchantmentThorns.func_92094_a((int)i, (Random)this.field_70146_Z);
                }
            }
            return flag;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.setScreaming(true);
        if (par1DamageSource instanceof EntityDamageSource && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            this.isAggressive = true;
        }
        if (par1DamageSource instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return super.func_70097_a(par1DamageSource, par2);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70636_d() {
        float f;
        super.func_70636_d();
        this.field_70888_h = this.field_70886_e;
        this.field_70884_g = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        if (this.destPos < 0.0f) {
            this.destPos = 0.0f;
        }
        if (this.destPos > 1.0f) {
            this.destPos = 1.0f;
        }
        if (!this.field_70122_E && this.field_70889_i < 1.0f) {
            this.field_70889_i = 1.0f;
        }
        this.field_70889_i = (float)((double)this.field_70889_i * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.field_70886_e += this.field_70889_i * 2.0f;
        if (this.field_70170_p.field_73013_u != this.checked) {
            this.difficultyChange();
            this.checked = this.field_70170_p.field_73013_u;
        }
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.lastEntityToAttack != this.field_70789_a) {
            IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attributeinstance.func_111124_b(attackingSpeedBoostModifier);
            if (this.field_70789_a != null) {
                attributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
        }
        this.lastEntityToAttack = this.field_70789_a;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.field_70146_Z.nextInt(2000) == 0) {
            int i = MathHelper.func_76128_c((double)(this.field_70165_t - 1.0 + this.field_70146_Z.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.field_70161_v - 1.0 + this.field_70146_Z.nextDouble() * 2.0));
            Block l = this.field_70170_p.func_147439_a(i, j, k);
            Block i1 = this.field_70170_p.func_147439_a(i, j - 1, k);
        }
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.field_70789_a = null;
            this.setScreaming(false);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if (this.func_70026_G() || this.func_70027_ad()) {
            this.field_70789_a = null;
            this.setScreaming(false);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if (this.isScreaming() && !this.isAggressive && this.field_70146_Z.nextInt(100) == 0) {
            this.setScreaming(false);
        }
        this.field_70703_bu = false;
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70789_a != null) {
                if (this.field_70789_a instanceof EntityPlayer) {
                    if (this.field_70789_a.func_70068_e((Entity)this) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.setScreaming(false);
                this.teleportDelay = 0;
            }
        }
        super.func_70636_d();
        if (!this.func_70631_g_() && !this.field_70170_p.field_72995_K && --this.timeUntilNextEgg == 0) {
            this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_145779_a((Item)Item.field_150901_e.func_82594_a("ender_pearl"), 1);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    private void difficultyChange() {
        if (this.field_70170_p.field_73013_u.toString() == "PEACEFUL") {
            this.func_70778_a(null);
            this.func_70624_b(null);
            this.func_70784_b(null);
            this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
            this.field_70715_bh.field_75782_a.clear();
        } else if (this.func_70902_q() != null) {
            EntityLivingBase s = this.func_70902_q();
            if (s.func_110124_au().toString().length() > 0) {
                this.func_70903_f(true);
                this.func_152115_b(s.toString());
            }
        } else {
            this.func_70903_f(false);
        }
    }

    protected void func_70069_a(float par1) {
    }

    protected String func_70639_aQ() {
        return "mob.chicken.say";
    }

    protected String func_70621_aR() {
        return "mob.chicken.hurt";
    }

    protected String func_70673_aS() {
        return "mob.chicken.hurt";
    }

    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.func_85030_a("mob.chicken.step", 0.15f, 1.0f);
    }

    protected Item getDropItemId() {
        return (Item)Item.field_150901_e.func_82594_a("feather");
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + par2);
        for (int k = 0; k < j; ++k) {
            if (this.func_70909_n()) {
                this.func_145779_a((Item)Item.field_150901_e.func_82594_a("ender_pearl"), 1);
                continue;
            }
            this.func_145779_a((Item)Item.field_150901_e.func_82594_a("egg"), 1);
        }
        if (this.func_70027_ad()) {
            this.func_145779_a((Item)Item.field_150901_e.func_82594_a("cooked_chicken"), 1);
        } else {
            this.func_145779_a((Item)Item.field_150901_e.func_82594_a("chicken"), 1);
        }
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.field_71071_by.func_70448_g();
        if (!this.func_70909_n() && itemstack != null && itemstack.func_77973_b() == (Item)Item.field_150901_e.func_82594_a("ender_eye")) {
            if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0) {
                par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70624_b(null);
                    this.func_70784_b(null);
                    this.func_152115_b(par1EntityPlayer.func_110124_au().toString());
                    this.func_70908_e(true);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    public EntityEnderChicken spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        EntityEnderChicken entitybluechicken = new EntityEnderChicken(this.field_70170_p);
        EntityLivingBase s = this.func_70902_q();
        if (s != null && s.func_110124_au().toString().length() > 0) {
            entitybluechicken.func_152115_b(s.func_110124_au().toString());
            entitybluechicken.func_70903_f(true);
        }
        return entitybluechicken;
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        if (this.func_70909_n()) {
            return par1ItemStack != null && par1ItemStack.func_77973_b() == (Item)Item.field_150901_e.func_82594_a("ender_eye");
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    public void setScreaming(boolean par1) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(par1 ? 1 : 0)));
    }

    protected boolean teleportRandomly() {
        if (!this.func_70909_n()) {
            double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleportTo(d0, d1, d2);
        }
        return false;
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - par1Entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 1.5f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e()), (double)(this.field_70161_v - par1Entity.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

