/*
 * Decompiled with CFR 0.152.
 */
package rafradek.wallpaint;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public abstract class WallPaintMessage
implements IMessage {

    public static class ArrayReturn
    extends WallPaintMessage {
        public int x;
        public int y;
        public ArrayList<int[]> list;

        public ArrayReturn() {
        }

        public ArrayReturn(int x, int y, ArrayList<int[]> arrayList) {
            this.x = x;
            this.y = y;
            this.list = arrayList;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.list = new ArrayList();
            int index = 0;
            int[] array = new int[4];
            while (buf.readableBytes() > 0) {
                array[index] = buf.readInt();
                if (++index <= 3) continue;
                index = 0;
                this.list.add(array);
                array = new int[4];
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            for (int[] array : this.list) {
                for (int value : array) {
                    buf.writeInt(value);
                }
            }
        }
    }

    public static class UpdateSend
    extends WallPaintMessage {
        public int[] data;
        public int currColor;

        public UpdateSend() {
        }

        public UpdateSend(int[] data, int currColor) {
            this.data = data;
            this.currColor = currColor;
        }

        public void fromBytes(ByteBuf buf) {
            this.data = new int[4];
            this.currColor = buf.readByte();
            int index = 0;
            while (buf.readableBytes() > 0) {
                this.data[index] = buf.readInt();
                ++index;
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.currColor);
            for (int value : this.data) {
                buf.writeInt(value);
            }
        }
    }

    public static class ArrayRequest
    extends WallPaintMessage {
        public int x;
        public int y;

        public ArrayRequest() {
        }

        public ArrayRequest(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
        }
    }
}

