package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAjaRedStoneEffect extends Entity
{
	//エイジャの赤石の光のエフェクト

	public EntityPlayer usePlayer;
	public int lightLevel;//取り込んだ光の量を保存

    public EntityAjaRedStoneEffect(World par1World)
    {
        super(par1World);
        setSize(2.0F, 0.0F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定
    }

    public EntityAjaRedStoneEffect(World world,EntityPlayer entityPlayer)
    {
        this(world);
    	setSize(2.0F, 2.0F);
        yOffset = 0.0F;
    	usePlayer = entityPlayer;
    	prevPosX = entityPlayer.posX;
        prevPosY = entityPlayer.posY;
        prevPosZ = entityPlayer.posZ;
    	double sx = entityPlayer.posX - (double)MathHelper.sin(entityPlayer.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    	double sy = entityPlayer.posY - (double)MathHelper.sin(entityPlayer.rotationPitch / 180F * 3.141593F) * 1.2D + entityPlayer.getEyeHeight();
    	double sz = entityPlayer.posZ + (double)MathHelper.cos(entityPlayer.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    	setPosition(sx, sy, sz);//初期位置を設定(x,y,z)
    	setRotation(entityPlayer.rotationYaw,  0.0F);
    	setLightPower(0);
    	lightLevel = 0;
    }
	
	//生成時に呼ばれる
    protected void entityInit()
    {
    	dataWatcher.addObject(19, new Integer(0));
    	lightLevel = 0;
    }

	/**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
	@Override
    protected boolean canTriggerWalking()
    {
        return false;
    }

	//当たり判定の有無　falseだと右クリックの選択ですらできない。trueならsetSize()で設定したボックスの当たり判定が出現する
	@Override
    public boolean canBeCollidedWith()
    {
        return false;
    }
	

	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
    	//エイジャの赤石の使用者がいないなら
    	if(!worldObj.isRemote && (usePlayer == null || usePlayer.isDead) )
    	{
    		//消滅させる
    		setDead();
    		return;
    	}
    	super.onUpdate();
    	
    	//使用者がいるなら
    	if(!worldObj.isRemote && usePlayer != null)
    	{
    		if(!usePlayer.isUsingItem())
    		{
    			//レーザーを発射する
   				float xVec = -MathHelper.sin( rotationYaw / 180F * 3.141593F) * MathHelper.cos( rotationPitch / 180F * 3.141593F);//X方向　水平方向
    			float yVec = -MathHelper.sin( rotationPitch / 180F * 3.141593F);//Y方向　上下
   				float zVec =  MathHelper.cos( rotationYaw / 180F * 3.141593F) * MathHelper.cos( rotationPitch / 180F * 3.141593F);//Z方向　水平方向
    			double px = posX + xVec;
    			double py = posY + yVec;
    			double pz = posZ + zVec;
    			int damage = (int)((double)lightLevel / 50.0);
    			if(damage > 30)//最大ダメージはハート15個分。頑張ってもそこまで
    			{
    				damage = 30;
    			}
    			EntityAjaRedStoneLaser entityAjaRedStoneLaser = new EntityAjaRedStoneLaser(worldObj, usePlayer, this, px, py, pz, xVec, yVec, zVec, 
    				0.1D, 4.0D, 0.3D, 0.3F, damage, 3.0D);
    			if(!worldObj.isRemote)
    			{
    				if(damage != 0)//ダメージが0でないなら、レーザーを発射する
    				{
    					worldObj.spawnEntityInWorld(entityAjaRedStoneLaser);
    				}
    				setDead();
    			}
    		}
    	}
    	
    	//今ある場所の光レベルに合わせて光の量を増やす
    	setLightPower( worldObj.getBlockLightValue((int)posX, (int)posY, (int)posZ));
    	lightLevel += getLightPower();

    	//使用者がいれば目の前に行くようにする
    	if(!worldObj.isRemote && usePlayer != null)
    	{
        	prevPosX = posX;
        	prevPosY = posY;
        	prevPosZ = posZ;

    		/*posX = usePlayer.posX;
    		posY = usePlayer.posY + usePlayer.getEyeHeight();
    		posZ = usePlayer.posZ;*/
    		posX = usePlayer.posX - (double)MathHelper.sin(usePlayer.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(usePlayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    		posY = usePlayer.posY - (double)MathHelper.sin(usePlayer.rotationPitch / 180F * 3.141593F) * 1.2D + usePlayer.getEyeHeight();
    		posZ = usePlayer.posZ + (double)MathHelper.cos(usePlayer.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(usePlayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    		setPosition(posX, posY, posZ);
    		rotationYaw = usePlayer.rotationYaw;
    		rotationPitch = usePlayer.rotationPitch;
    	}

    	if(rotationYaw >  180F)rotationYaw -= 360F;
    	if(rotationYaw < -180F)rotationYaw += 360F;
    	if(rotationPitch >  180F)rotationPitch -= 360F;
    	if(rotationPitch < -180F)rotationPitch += 360F;

    	setRotation(rotationYaw, rotationPitch);
    }
	
	//取り込んでいる光の量を設定
	public void setLightPower(int lightPower)
	{
		dataWatcher.updateObject(19, Integer.valueOf(lightPower));
	}

	//取り込んでいる光の量を返す
	public int getLightPower()
	{
		return dataWatcher.getWatchableObjectInt(19);
	}
	

	protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound)
    {
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound)
    {
    }
}
