package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAjaRedStoneLaser extends EntityTHLaser
{
	//エイジャの赤石のレーザー
	
	
	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityAjaRedStoneLaser(World world)
    {
        super(world);
    }
	
	public EntityAjaRedStoneLaser(World world, EntityLiving entityUser, Entity entity,
		double xPos, double yPos, double zPos,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	float size, int damage, double length)
    {
        super(world, entityUser, entity, xPos, yPos, zPos, xVector, yVector, zVector,
        		firstSpeed, maxSpeed, addSpeed, 0.0D, damage, 0, size, 120, length);
    }
	
	@Override
	public void onUpdate()
	{
		super.onUpdate();
		
		if(shotDamage <= 0)
		{
			if(!worldObj.isRemote)
			{
				setDead();
			}
		}
	}
	

	//ブロックやEntityに当たった時の処理
	@Override
    protected void onImpact(MovingObjectPosition movingobjectposition)
    {
    	//当たった時の処理
    	if (!worldObj.isRemote)
    	{
    		Entity hitEntity = movingobjectposition.entityHit;
        
    		//当たったEntityがいるなら
    		if ( hitEntity != null )
        	{
        		//それがEntityTHShotに属していないなら
        		if(hitEntity instanceof EntityTHShot == false)
        		{
        			//指定したダメージ分の魔法ダメージを与える
        			if(hitEntity instanceof EntityLiving)
        			{
        				EntityLiving entityLiving = (EntityLiving)hitEntity;
        				if(entityLiving.getCreatureAttribute() == EnumCreatureAttribute.UNDEAD)//アンデッドなら
        				{
        					//通常の2倍のダメージを与える
        					entityLiving.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity), shotDamage * 2);
        					entityLiving.setFire(shotDamage);
        					worldObj.playSoundEffect(posX, posY, posZ, "random.fizz", 0.5F, 2.6F + (worldObj.rand.nextFloat() - worldObj.rand.nextFloat()) * 0.8F);
        					for (int l = 0; l < 8; l++)
                    		{
                        		worldObj.spawnParticle("largesmoke", posX + Math.random(), posY + Math.random(), posZ + Math.random(), 0.0D, 0.0D, 0.0D);
                    		}
        				}
        				else
        				{
        					entityLiving.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity), shotDamage);
        				}
        			}
        			else
        			{
        				hitEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity), shotDamage);
        			}
        			shotDamage--;
        		}
        		//EntityTHShotに属しているなら
        		else
        		{
        			EntityTHShot entityTHShot = (EntityTHShot)hitEntity;
        			//弾の強さを比べる
        			//同じなら
        			if(getShotStrength() == entityTHShot.getShotStrength())
        			{
        				//setDead();
        				//entityTHShot.setDead();
        			}
        			//相手の方が強いなら
        			else if(getShotStrength() < entityTHShot.getShotStrength())
        			{
        				//この弾を消滅させる
        				this.setDead();
        			}
        			//自分の方が強いなら
        			else
        			{
        				//相手の弾を消滅させる
        				entityTHShot.setDead();
        			}
        		}
			}
    		else
    		{
    			shotDamage--;
        		//this.setDead();//ブロックに当たったら消滅
    		}
    	}
    } 	
}
