package net.minecraft.thKaguyaMod;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import java.util.Iterator;

public class EntityColorLightningBolt extends EntityLightningBolt
{
	//色つきの雷
	//EntityLightningBoltを継承し、色のデータを付け加えただけ
	public float color_r;
	public float color_g;
	public float color_b;

	/*public EntityColorLightningBolt(World world)
	{
	}*/
	
    public EntityColorLightningBolt(World par1World, double par2, double par4, double par6, float cr, float cg, float cb)
    {
        super(par1World, par2, par4, par6);
		color_r = cr;
    	color_g = cg;
    	color_b = cb;
    	setRedColor(color_r);
    	setGreenColor(color_g);
    	setBlueColor(color_b);
    }
	
	@Override
	protected void entityInit()
    {
    	dataWatcher.addObject(16, new Integer(0));//赤
    	dataWatcher.addObject(17, new Integer(0));//緑
    	dataWatcher.addObject(18, new Integer(0));//青
    }
	
	void setRedColor(float color)
	{
		dataWatcher.updateObject(16, Integer.valueOf((int)(color * 10F)));
	}
	
	public float getRedColor()
	{
		return (float)dataWatcher.getWatchableObjectInt(16) / 10F;
	}
	
	void setGreenColor(float color)
	{
		dataWatcher.updateObject(17, Integer.valueOf((int)(color * 10F)));
	}
	
	public float getGreenColor()
	{
		return (float)dataWatcher.getWatchableObjectInt(17) / 10F;
	}
	
	void setBlueColor(float color)
	{
		dataWatcher.updateObject(18, Integer.valueOf((int)(color * 10F)));
	}
	
	public float getBlueColor()
	{
		return (float)dataWatcher.getWatchableObjectInt(18) / 10F;
	}
}
