package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityHisou extends Entity
{
	//緋想の剣

	private EntityLiving shootingEntity;
	private Entity motherEntity;
	private int count;
	public int num;
	private int damage;

    public EntityHisou(World par1World)
    {
        super(par1World);
        setSize(0.4F, 0.4F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = -0.8F;//高さを設定
    }
	
	public EntityHisou(World par1World,EntityLiving entityLiving, Entity mother, int n, int da)
    {
        this(par1World);

    	setSize(0.4F, 0.4F);
        yOffset = -0.8F;
    	prevPosX = entityLiving.posX;
        prevPosY = entityLiving.posY;
        prevPosZ = entityLiving.posZ;
        setPosition(entityLiving.posX - (double)MathHelper.sin(entityLiving.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F) * 1.2D,
        			entityLiving.posY - (double)MathHelper.sin(entityLiving.rotationPitch / 180F * 3.141593F) * 1.2D +  entityLiving.getEyeHeight() - 0.7D,
        			entityLiving.posZ + (double)MathHelper.cos(entityLiving.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F) * 1.2D);//初期位置を設定(x,y,z)
    	rotationYaw = entityLiving.rotationYaw;
    	shootingEntity = entityLiving;//使用者をshootingEntityに保存
    	motherEntity = mother; //残像に対して本物
    	count = 0;
    	setNum(n);
    	damage = da;
    	worldObj.playSoundAtEntity(this, "random.masterspark", mod_thKaguya.HisoutenVol, 1.0F);
    }

    protected void entityInit()
    {
    	dataWatcher.addObject(17, new Integer(0));
    }

    /**
     * Returns true if this entity should push and be pushed by other entities when colliding.
     */
    public boolean canBePushed()
    {
        return false;
    }

    /**
     * Returns true if other Entities should be prevented from moving through this Entity.
     */
    public boolean canBeCollidedWith()
    {
    	return false;
    }

    /**
     * Called to update the entity's position/logic.
     */
	//Entityが存在する限り毎フレーム呼び出されるメソッド
    public void onUpdate()
    {
    	if(!worldObj.isRemote && shootingEntity == null)
    	{
    		setDead();
    	}

    	//rotationPitch -= 23.0F;
    	rotationPitch = ((float)count+(float)getNum()/3.0F) * 39.0F;
    	//rotationPitch = rotationPitch + 23.0F * (float)(4-num);
    	if(!worldObj.isRemote && shootingEntity != null)//shootingEntityが存在するなら、それをぬるぬる追尾する
    	{
    		float angleXZ,angleY, speed;
    		float disXZ;
    		double px, py, pz;
    		px = shootingEntity.posX - (double)MathHelper.sin(shootingEntity.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(shootingEntity.rotationPitch / 180F * 3.141593F)* 1.2D;
    		py = shootingEntity.posY - (double)MathHelper.sin(shootingEntity.rotationPitch / 180F * 3.141593F) * 1.2D + shootingEntity.getEyeHeight() - 0.8D;
    		pz = shootingEntity.posZ + (double)MathHelper.cos(shootingEntity.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(shootingEntity.rotationPitch / 180F * 3.141593F) * 1.2D;
    		disXZ = (float)Math.sqrt( (px-posX)*(px-posX) + (pz-posZ)*(pz-posZ) );
    		angleXZ = (float)Math.atan2(pz-posZ, px-posX);
    		angleY  = (float)Math.atan2(disXZ, py-posY);
    		speed = (0.25F+((float)num * 0.1F)) * (float)Math.sqrt( (px-posX)*(px-posX) + (py-posY)*(py-posY) + (pz-posZ)*(pz-posZ) );//離れるほど速くなる
    		motionX = shootingEntity.motionX;
    		motionY = shootingEntity.motionY;
    		motionZ = shootingEntity.motionZ;
    		/*setPosition(
    			posX + Math.cos(angleXZ),
    			posY + Math.cos(angleY ) - 0.3D,
    			posZ + Math.sin(angleXZ));*/
    		setPosition(px, py, pz);
    		rotationYaw = shootingEntity.rotationYaw;
    		/*if(getNum() == 8)
    		{
    			shootingEntity.motionX -= (shootingEntity.posX - shootingEntity.prevPosX)*0.6D;
    			shootingEntity.motionZ -= (shootingEntity.posZ - shootingEntity.prevPosZ)*0.6D;
    			shootingEntity.rotationYawHead = shootingEntity.prevRotationYawHead + (shootingEntity.rotationYawHead - shootingEntity.prevRotationYawHead)*0.2F;
    			shootingEntity.rotationYaw = shootingEntity.prevRotationYaw + (shootingEntity.rotationYaw - shootingEntity.prevRotationYaw)*0.2F;
    		}*/
    	}
    	//else//使用者がいないならその場でアイテム化
    	else{
    		if(getNum() == 8)
    		{
    			if(!worldObj.isRemote)
    			{
    				entityDropItem(new ItemStack(mod_thKaguya.hisouItem.itemID, 1, damage), 0.0F);
    			}
    		}
    		if(!worldObj.isRemote)
    		{
    			setDead();
    		}
    	}


	//****気質弾の発射****//
	if(shootingEntity != null && getNum() == 8)
	{
		double ax, ay, az, dx, dy, dz;
		float angleXZ, angleY;

		dx = posX - shootingEntity.posX;
		dy = posY - shootingEntity.posY;
		dz = posZ - shootingEntity.posZ;

		angleY  = (float)Math.atan2(dx, dz);
		angleXZ = (float)Math.atan2( Math.sqrt(dx*dx + dz*dz), dy);
		ax = -MathHelper.sin(shootingEntity.rotationYaw/180F * 3.141593F) * MathHelper.cos(shootingEntity.rotationPitch/180F * 3.141593F);//X方向　水平方向
		ay = -MathHelper.sin(shootingEntity.rotationPitch/180F * 3.141593F);// - 0.10000000149011612D;//Y方向　上下
		az =  MathHelper.cos(shootingEntity.rotationYaw/180F * 3.141593F) * MathHelper.cos(shootingEntity.rotationPitch/180F * 3.141593F);//Z方向　水平方向
		EntityKishitudan[] entityKishitudan = new EntityKishitudan[2];
		for(int i = 0; i < 2; i++)
		{
			//entityKishitudan[i] = new EntityKishitudan(worldObj, this, shootingEntity, ax, ay, az, angleY, angleXZ, 1.0D);
			entityKishitudan[i] = new EntityKishitudan(worldObj, shootingEntity, this,ax, ay, az, 0.01D, 0.6D, 0.05D, 6);
			if(!worldObj.isRemote)
			{
				worldObj.spawnEntityInWorld(entityKishitudan[i]);
			}
		}
	}
	//********//

		//時間で消滅
	if(count >= 100)
	{
		if(getNum() == 8 && shootingEntity != null)
		{
			if(shootingEntity instanceof EntityPlayer)
			{
				EntityPlayer entityPlayer = (EntityPlayer)shootingEntity;
				if(shootingEntity instanceof EntityPlayer)
				{
					if(entityPlayer.capabilities.isCreativeMode)
					{
						setDead();
					}
					else if(entityPlayer.inventory.addItemStackToInventory(new ItemStack(mod_thKaguya.hisouItem, 1, damage)) == false)
					{
						//インベントリが一杯なら使用者の目の前でアイテム化
						//（クリエイティブでは常にインベントリには物が吸収される仕様があるらしく、クリエイティブでは落とさない（false判定がでない)）
						//entityPlayer.dropItemWithOffset(mod_thKaguya.hisouItem.shiftedIndex, 1, 0.0F);
						if(!worldObj.isRemote)
						{
							entityDropItem(new ItemStack(mod_thKaguya.hisouItem.itemID, 1, damage), 0.0F);
						}
					}
				}
			}
			else
			{
				if(!worldObj.isRemote)
				{
					entityDropItem(new ItemStack(mod_thKaguya.hisouItem.itemID, 1, damage), 0.0F);
				}
			}
		}
    	if(!worldObj.isRemote)
    	{
			setDead();
    	}
	}
	else
	{
		count++;
	}
}

    /**
     * (abstract) Protected helper method to write subclass entity data to NBT.
     */
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    	nbttagcompound.setShort("count", (short)count);
    	nbttagcompound.setShort("damage", (short)damage);
    }

    /**
     * (abstract) Protected helper method to read subclass entity data from NBT.
     */
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    	count = nbttagcompound.getShort("count");
    	damage = nbttagcompound.getShort("damage");
    }

    public float getShadowSize()
    {
        return 0.5F;
    }

    
	public void setNum(int num)
	{
		dataWatcher.updateObject(17, Integer.valueOf(num));
	}
	
	public int getNum()
	{
		return dataWatcher.getWatchableObjectInt(17);
	}

    protected boolean isValidLightLevel()
    {
        return true;
    }

    /**
     * Gets how bright this entity is.
     */
    public float getBrightness(float par1)
    {
        return 1.0F;
    }
}
