package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityHomingAmulet extends EntityTHShot
{
	//ホーミングアミュレット
	
	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityHomingAmulet(World par1World)
    {
        super(par1World);
    	setAmuletRotation(0);    	
    }

    public EntityHomingAmulet(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector,
    		double speed, int power, int color, float size)
    {
        super(world, entityLiving, xVector, yVector, zVector, speed, power, color, size);
    	setAmuletRotation(0);
    }
	
	//最初に1回だけ呼び出される処理
	@Override
	protected void entityInit()
	{
		super.entityInit();
		dataWatcher.addObject(16, new Integer(0));
	}
	
	//常時呼び出される処理
	@Override
	public void onUpdate()
	{
		super.onUpdate();
		
		setAmuletRotation( getAmuletRotation() + 23 );
	}
	
	//弾幕の特殊な動きを記述
	@Override
	public void specialMotion()
	{
		//追尾する動きをする
		Entity entity = null;
        List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.addCoord(motionX, motionY, motionZ).expand(10.0D, 10.0D, 10.0D));//指定範囲内のEntityをリストに登録
		
		EntityLiving nearEntity = null;
		double nearDistance = 999.9D;
		double ax, ay, az, dx, dy, dz;
		float angleXZ, angleY;
		float epYaw = (360F - rotationYaw) % 360F;
		float motionYaw = (float)Math.atan2(motionX, motionZ) / 3.141593F * 180F;//atan2は、-PI ～ PIまでの値を返す　ここで-180 ～ 180に変換
		float motionPitch = ((float)Math.atan2( motionY, (motionX*motionX + motionZ*motionZ)) / 3.141593F * 180F) % 90F;
		boolean check;
		boolean rightCheck = false;
		boolean leftCheck = false;
		boolean upCheck = false;
		boolean downCheck = false;
		boolean lastRightCheck = false;
		boolean lastLeftCheck = false;
		boolean lastUpCheck = false;
		boolean lastDownCheck = false;
		
		if(epYaw < 0F)
		{
			epYaw += 360F;
		}
		if(motionYaw < 0F)//motionYawを0 ～ 360に変換
		{
			motionYaw += 360F;
		}
		for (int j = 0; j < list.size(); j++)
        {
        	Entity entitys = (Entity)list.get(j);//entity1にリストの先端のentityを保存
        	if ( (entitys instanceof EntityLiving) == false || entitys == shootingEntity)//生物でないなら反応しない
            {
                continue;
            }
        	EntityLiving entity1 = (EntityLiving)entitys;
        	if(entity1.isDead)
        	{
        		continue;
        	}
        	//始点（現在地）
    		Vec3 vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX, posY, posZ);
    		//終点（現在地に移動量を足した点）
    		Vec3 vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX + motionX, posY + motionY, posZ + motionZ);
        	//始点と終点からブロックとの当たりを取得
    		MovingObjectPosition movingObjectPosition = worldObj.rayTraceBlocks(vec3d, vec3d1);
    		vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX, posY, posZ);
    		vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX + motionX, posY + motionY, posZ + motionZ);
    		//何らかのブロックに当たっているなら
        	if (movingObjectPosition != null)
        	{
        		continue;
        	}
        	check = false;
        	//視野に収まっているEntityLivingを抽出
            //左右 -30 ～ 30度まで、上下も-30 ～ 30度まで感知
        	dx = entity1.posX - posX;//x方向の距離
        	dy = entity1.posY + entity1.getEyeHeight() - posY;//y方向の距離
        	dz = entity1.posZ - posZ;//z方向の距離
        	
        	angleY  = (float)Math.atan2(dx, dz);//対象のEntityまでの平面角度
        	angleXZ = ((float)Math.atan2( dy, Math.sqrt(dx*dx + dz*dz)) / 3.141593F * 180F) % 90F;//対象のEntityまでの垂直方向の角度
        	
        	float angleYDeg = angleY / 3.141593F * 180F;//Degreeに変換（-180° ～ 180°)
        	if(angleYDeg < 0F)//angleYDegを0～360度の範囲に設定
        	{
        		angleYDeg += 360F;
        	}
		
        	//check = true;
        	//進行角度epYawとEntityまでの角度angleYDegを0～360に固定して判定
            //30～330のときはそのまま判定
        	if(motionYaw > 50F && motionYaw < 310F)
        	{
        		if(motionYaw - 50F < angleYDeg && motionYaw + 50F > angleYDeg)
        		{
        			check = true;
        			if(motionYaw < angleYDeg)
        			{
        				check = true;
        				rightCheck = true;
        				leftCheck = false;
        			}
        			else if(motionYaw > angleYDeg)
        			{
        				check = true;
        				leftCheck = true;
        				rightCheck = false;
        			}
        		}
        	}
            //30以下のときは少し特殊な判定を与えないとできない
	        else if(motionYaw <= 50F)
	        {
	            if(0F <= angleYDeg && motionYaw+50F >= angleYDeg )
	            {
	            	check = true;
	            	if(motionYaw > angleYDeg || motionYaw < 360F - (50F - angleYDeg))
        			{
        				check = true;
        				leftCheck = true;
        				rightCheck = false;
        			}
        			else if(motionYaw < angleYDeg)
        			{
        				check = true;
        				rightCheck = true;
        				leftCheck = false;
        			}
	            }
	        	if(360F-motionYaw < angleYDeg && 360F > angleYDeg)
	            {
	            	check = true;
	            	if(motionYaw < angleYDeg || motionYaw > 360F - angleYDeg)
        			{
        				check = true;
        				rightCheck = true;
        				leftCheck = false;
        			}
        			else if(motionYaw > angleYDeg)
        			{
        				check = true;
        				leftCheck = true;
        				rightCheck = false;
        			}
	            }
	        }
            //330以上　同上
	        else
	        {
	            if(50F-(360F-motionYaw) >= angleYDeg && 0F <= angleYDeg )
	            	
	            {
	            	check = true;
	            	if(motionYaw < angleYDeg || motionYaw > 360F - angleYDeg)
        			{
        				check = true;
        				rightCheck = true;
        				leftCheck = false;
        			}
        			else if(motionYaw > angleYDeg)
        			{
        				check = true;
        				leftCheck = true;
        				rightCheck = false;
        			}
	            }
	            if(motionYaw-50F < angleYDeg && 360F > angleYDeg)
	            {
	            	check = true;
	            	if(motionYaw > angleYDeg || motionYaw < 360F - (50F - angleYDeg))
        			{
        				check = true;
        				leftCheck = true;
        				rightCheck = false;
        			}
        			else if(motionYaw < angleYDeg)
        			{
        				check = true;
        				rightCheck = true;
        				leftCheck = false;
        			}
	            }
	        }
		
			if(motionPitch > -80F && motionPitch < 80F)
			{
				if(	angleXZ > motionPitch - 10F && angleXZ < motionPitch + 10F)
				{
				}
				else
				{
					check = false;
				}
			}
			else if(motionPitch <= -80F)
			{
				if(angleXZ < motionPitch + 10F)
				{
				}
				else
				{
					check = false;
				}
			}
			else
			{
				if(angleXZ < motionPitch - 10F)
				{
				}
				else
				{
					check = false;
				}
			}
        	
        	double toEntity1Distance;
        	if(check && (toEntity1Distance = getDistanceToEntity(entity1)) < nearDistance)
        	{
        		nearEntity = entity1;
        		nearDistance = toEntity1Distance;
        		lastRightCheck = rightCheck;
        		lastLeftCheck = leftCheck;
        	}
        }
		
		//追尾対象がいるならば
		if(nearEntity != null)
		{
			//setPosition(nearEntity.posX, nearEntity.posY, nearEntity.posZ);
			/*float rotationSpan =13.3F;
			//対象が右側にいるなら
			if(lastRightCheck)
			{
				rotationYaw += rotationSpan;
			}
			//対象が左側にいるなら
			if(lastLeftCheck)
			{
				rotationYaw -= rotationSpan;
			}
			//対象が上部にいるなら
			if(lastUpCheck)
			{
			}
			//対象が下部にいるなら
			if(lastDownCheck)
			{
			}*/
			double xDistance = nearEntity.posX - posX;
			double yDistance = nearEntity.posY + nearEntity.getEyeHeight() - posY;
			double zDistance = nearEntity.posZ - posZ;
			//worldObj.playSoundAtEntity(this, "random.orb", 0.5F, 6.0F);
			rotationYaw = 360F - ((float)Math.atan2(xDistance, zDistance)) / 3.141593F * 180F;
			rotationPitch = (float)Math.atan2( yDistance, Math.sqrt(xDistance * xDistance + zDistance * zDistance)) / 3.141593F * 180F;
			rotationPitch = 360F - (rotationPitch % 90F);
			setRotation(rotationYaw, rotationPitch);
			accelerationX = -MathHelper.sin(rotationYaw / 180F * 3.141593F) * MathHelper.cos( rotationPitch / 180F * 3.141593F) * shotMaxSpeed * shotAddSpeed;
			accelerationY = -MathHelper.sin( rotationPitch / 180F * 3.141593F) * shotMaxSpeed * shotAddSpeed;
			accelerationZ = MathHelper.cos(rotationYaw / 180F * 3.141593F) * MathHelper.cos( rotationPitch / 180F * 3.141593F) * shotMaxSpeed * shotAddSpeed;
			if(getSpeed() >= shotMaxSpeed)
			{
				motionX = -MathHelper.sin(rotationYaw / 180F * 3.141593F) * MathHelper.cos(rotationPitch / 180F * 3.141593F) * shotMaxSpeed;
				motionY = -MathHelper.sin(rotationPitch / 180F * 3.141593F) * shotMaxSpeed;
				motionZ = MathHelper.cos(rotationYaw / 180F * 3.141593F) * MathHelper.cos( rotationPitch / 180F * 3.141593F) * shotMaxSpeed;
			}
			//setPosition(posX, posY, posZ);
		}
	}
	
	//ホーミングアミュレットの角度を設定
	public void setAmuletRotation(int par1)
	{
		dataWatcher.updateObject(16, Integer.valueOf(par1));
	}
	
	//ホーミングアミュレットの角度を取得
	public int getAmuletRotation()
	{
		return dataWatcher.getWatchableObjectInt(16);
	}

	
}
