package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityKinkakuzi extends Entity
{
	//Entityの上に乗ることでダメージを与える　ボートを改造

    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
	@SideOnly(Side.CLIENT)
    private double velocityX;
	@SideOnly(Side.CLIENT)
    private double velocityY;
	@SideOnly(Side.CLIENT)
    private double velocityZ;
	private EntityLiving shootingEntity;

	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityKinkakuzi(World par1World)
    {
        super(par1World);
        preventEntitySpawning = true;
        setSize(6F, 0.2F);//サイズを設定　6x6の高さ0.2ということか？
        yOffset = 0.0F;//高さを設定
    }

    /**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    protected boolean canTriggerWalking()
    {
        return false;
    }

	//最初に一度だけ呼ばれるメソッド
    protected void entityInit()
    {
        dataWatcher.addObject(17, new Integer(0));//dataWatcharの17～19を使用
        dataWatcher.addObject(18, new Integer(1));
        dataWatcher.addObject(19, new Integer(0));
    }

    /**
     * Returns a boundingBox used to collide the entity with other entities and blocks. This enables the entity to be
     * pushable on contact, like boats or minecarts.
     */
	//他の物体と衝突したときのその物体の当たり判定？
    public AxisAlignedBB getCollisionBox(Entity par1Entity)
    {
        return par1Entity.boundingBox;
    }

	//当たり判定を設定
    public AxisAlignedBB getBoundingBox()
    {
        return boundingBox;
    }

	//押すことができるかどうか
    public boolean canBePushed()
    {
        return true;
    }

	//出現時に呼び出されるコンストラクト
    public EntityKinkakuzi(World par1World,EntityLiving entityLiving, double pow)
    {
        this(par1World);

    	setSize(6F, 0.2F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
    	motionX = -Math.sin(entityLiving.rotationYaw/180F*(float)Math.PI)*0.2D;//出現時の移動速度　向いている方向に動く
        motionY = pow;//少し上方向に持ち上げる
    	motionZ = Math.cos(entityLiving.rotationYaw/180F*(float)Math.PI)*0.2D;
    	rotationYaw = entityLiving.rotationYaw;
    	rotationPitch = 0.0F;
    	setLocationAndAngles(entityLiving.posX, entityLiving.posY+(double)entityLiving.getEyeHeight() - 0.10000000149011612D, entityLiving.posZ, rotationYaw, rotationPitch);
    	shootingEntity = entityLiving;//使用者をshootingEntityに保存
    }

	//Entityが乗ったときのそのEntityを置く高さ
    public double getMountedYOffset()
    {
        return (double)height * 0.0D + 0.3D;//- 0.30000001192092896D;
    }

	//Entityに攻撃されたときに呼び出されるメソッド　破壊とか関係なしに攻撃されれば呼び出される
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2)
    {
        if (worldObj.isRemote || isDead)
        {
            return true;
        }

        setForwardDirection(-getForwardDirection());
        setTimeSinceHit(10);
        setDamageTaken(getDamageTaken() + par2 * 10);
        setBeenAttacked();

        if (getDamageTaken() > 40)
        {
            if (riddenByEntity != null)
            {
                riddenByEntity.mountEntity(this);
            }

            dropItemWithOffset(mod_thKaguya.kinkakuziItem.itemID, 1, 0.0F);//破壊されたら、金閣寺の一枚天井を一つ落とす

            setDead();//このEntity（金閣寺の一枚天井）を消す
        }

        return true;
    }

    /**
     * Setups the entity to do the hurt animation. Only used by packets in multiplayer.
     */
	@SideOnly(Side.CLIENT)
    public void performHurtAnimation()
    {
        setForwardDirection(-getForwardDirection());
        setTimeSinceHit(10);
        setDamageTaken(getDamageTaken() * 11);
    }

    /**
     * Returns true if other Entities should be prevented from moving through this Entity.
     */
    public boolean canBeCollidedWith()
    {
        return !isDead;
    }

    /**
     * Sets the position and rotation. Only difference from the other one is no bounding on the rotation. Args: posX,
     * posY, posZ, yaw, pitch
     */
	@SideOnly(Side.CLIENT)
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int par9)
    {
		double xDistance = x - this.posX;
        double yDistance = y - this.posY;
        double zDistance = z - this.posZ;
        double distance = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;

        if (distance <= 1.0D)
        {
            return;
        }
    	
        boatX = x;
        boatY = y;
        boatZ = z;
        boatYaw = yaw;
        boatPitch = pitch;
        boatPosRotationIncrements = par9 + 4;
        motionX = velocityX;
        motionY = velocityY;
        motionZ = velocityZ;
    }

    /**
     * Sets the velocity to the args. Args: x, y, z
     */
	@SideOnly(Side.CLIENT)
    public void setVelocity(double x, double y, double z)
    {
        velocityX = motionX = x;
        velocityY = motionY = y;
        velocityZ = motionZ = z;
    }

	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
        super.onUpdate();

        if (getTimeSinceHit() > 0)
        {
            setTimeSinceHit(getTimeSinceHit() - 1);
        }

        if (getDamageTaken() > 0)
        {
            setDamageTaken(getDamageTaken() - 1);
        }

        prevPosX = posX;
        prevPosY = posY;
        prevPosZ = posZ;
        int i = 5;
        double d = 0.0D;

        for (int j = 0; j < i; j++)
        {
            double d2 = (boundingBox.minY + ((boundingBox.maxY - boundingBox.minY) * (double)(j + 0)) / (double)i) - 0.125D;
            double d8 = (boundingBox.minY + ((boundingBox.maxY - boundingBox.minY) * (double)(j + 1)) / (double)i) - 0.125D;
            //AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBoxFromPool(boundingBox.minX, d2, boundingBox.minZ, boundingBox.maxX, d8, boundingBox.maxZ);
        	AxisAlignedBB axisalignedbb = AxisAlignedBB.getAABBPool().getAABB(this.boundingBox.minX, d2, this.boundingBox.minZ, this.boundingBox.maxX, d8, this.boundingBox.maxZ);

            if (worldObj.isAABBInMaterial(axisalignedbb, Material.water))
            {
                d += 1.0D / (double)i;
            }
        }

        double d1 = Math.sqrt(motionX * motionX + motionZ * motionZ);

    	MovingObjectPosition movingobjectposition = new MovingObjectPosition(this);

        if (worldObj.isRemote)
        {
            if (boatPosRotationIncrements > 0)
            {
                double d4 = posX + (boatX - posX) / (double)boatPosRotationIncrements;
                double d10 = posY + (boatY - posY) / (double)boatPosRotationIncrements;
                double d13 = posZ + (boatZ - posZ) / (double)boatPosRotationIncrements;
                double d17;

                for (d17 = boatYaw - (double)rotationYaw; d17 < -180D; d17 += 360D) { }

                for (; d17 >= 180D; d17 -= 360D) { }

                rotationYaw += d17 / (double)boatPosRotationIncrements;
                rotationPitch += (boatPitch - (double)rotationPitch) / (double)boatPosRotationIncrements;
                boatPosRotationIncrements--;
                setPosition(d4, d10, d13);
                setRotation(rotationYaw, rotationPitch);
            }
            else
            {
                double d5 = posX + motionX;
                double d11 = posY + motionY;
                double d14 = posZ + motionZ;
                setPosition(d5, d11, d14);

                if (onGround)
                {
                    motionX *= 0.5D;
                    motionY *= 0.5D;
                    motionZ *= 0.5D;
                }

                motionX *= 0.99000000953674316D;
                motionY *= 0.94999998807907104D;
                motionZ *= 0.99000000953674316D;
            }

            return;
        }

        if (d < 1.0D)
        {
            double d6 = d * 2D - 1.0D;
            motionY += 0.039999999105930328D * d6;
        }
        else
        {
            if (motionY < 0.0D)
            {
                motionY /= 2D;
            }

            motionY += 0.0070000002160668373D;
        }

        if (riddenByEntity != null)
        {
            motionX += riddenByEntity.motionX * 0.20000000000000001D;
            motionZ += riddenByEntity.motionZ * 0.20000000000000001D;
        }

        double d7 = 0.40000000000000002D;

        if (motionX < -d7)
        {
            motionX = -d7;
        }

        if (motionX > d7)
        {
            motionX = d7;
        }

        if (motionZ < -d7)
        {
            motionZ = -d7;
        }

        if (motionZ > d7)
        {
            motionZ = d7;
        }

        if (onGround)
        {
            motionX *= 0.5D;
            motionY *= 0.5D;
            motionZ *= 0.5D;
        }

    	//motionX *= 1.5D;
    	//motionZ *= 1.5D;
        moveEntity(motionX, motionY, motionZ);

        if (isCollidedHorizontally && d1 > 0.20000000000000001D)
        {
        }
        else
        {
            motionX *= 0.99000000953674316D;
            motionY *= 0.94999998807907104D;
            motionZ *= 0.99000000953674316D;
        }

        rotationPitch = 0.0F;
        double d12 = rotationYaw;
        double d15 = prevPosX - posX;
        double d18 = prevPosZ - posZ;

        if (d15 * d15 + d18 * d18 > 0.001D)
        {
            d12 = (float)((Math.atan2(d18, d15) * 180D) / Math.PI);
        }

        double d20;

        for (d20 = d12 - (double)rotationYaw; d20 >= 180D; d20 -= 360D) { }

        for (; d20 < -180D; d20 += 360D) { }

        if (d20 > 20D)
        {
            d20 = 20D;
        }

        if (d20 < -20D)
        {
            d20 = -20D;
        }

        rotationYaw += d20;
        setRotation(rotationYaw, rotationPitch);

    	//***********　金閣寺の一枚天井とEntityの当たり判定を取る****************//
    	//ほとんどボートと同じだけど、ここはボートにない処理
    	Entity entity = null;
        List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(MathHelper.sin((float)boatYaw / 180.0F * (float)Math.PI) * 0.1D, 0.5D,MathHelper.cos((float)boatYaw / 180.0F * (float)Math.PI)* 0.1D));//(0.20000000298023224D, 0.0D, 0.20000000298023224D));
		//List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(1.2D, 1.2D,1.2D));//(0.20000000298023224D, 0.0D, 0.20000000298023224D));

        if (list != null && list.size() > 0)
        {
            for (int j1 = 0; j1 < list.size(); j1++)
            {
                entity = (Entity)list.get(j1);
                if (entity != riddenByEntity && entity.canBePushed() && (entity instanceof EntityKinkakuzi))
                {
                    entity.applyEntityCollision(this);
                }
            	if (entity != null )
        		{
            		movingobjectposition = new MovingObjectPosition(entity);
        		}
        		if (movingobjectposition.entityHit != riddenByEntity && movingobjectposition != null && entity instanceof EntityKinkakuzi == false)
        		{
            		hitOnEntity(movingobjectposition);//ダメージを与える処理とかしてる
        		}
            }
        }

        //************************************************************************************//

        if (riddenByEntity != null && riddenByEntity.isDead)
        {
            riddenByEntity = null;
        }
    }
    
    //Entityと衝突したときの処理
    protected void hitOnEntity(MovingObjectPosition movingobjectposition)
    {
    	//金閣寺の一枚天井が当たったEntityより上にあり、当たったEntityが、金閣寺の一枚天井、アイテム、使用者、プレイヤー、経験値オーブでないなら
    	if(!worldObj.isRemote && movingobjectposition.entityHit != null)
    	{
    		if ( movingobjectposition.entityHit.posY < this.posY &&
    			!(movingobjectposition.entityHit instanceof EntityItem)
    			&& !(movingobjectposition.entityHit instanceof EntityXPOrb)
    	    	&& movingobjectposition.entityHit != shootingEntity)
       		{
       			double ymove = prevPosY - posY;
       			if(ymove >= 0.0)
       			{
       				int damage = (int)((prevPosY - posY)*40.0)+2;//ダメージは落下速度依存　最低でもハート１個分はダメージを与える
                	movingobjectposition.entityHit.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, shootingEntity), damage);
       			}
            }
        }
    }

	//金閣寺の一枚天井に乗っているEntityの位置の更新
    public void updateRiderPosition()
    {
        if (riddenByEntity == null)
        {
            return;
        }
        else
        {
            double d = Math.cos(((double)rotationYaw * Math.PI) / 180D)*0.5D;// * 0.40000000000000002D;
            double d1 = Math.sin(((double)rotationYaw * Math.PI) / 180D)*0.5D;// * 0.40000000000000002D;
            riddenByEntity.setPosition(posX + d, posY + getMountedYOffset() + riddenByEntity.getYOffset(), posZ + d1);
            return;
        }
    }

	//Entityのデータを書き込む
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    }

	//Entityのデータを読み込む
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    }
    
	@SideOnly(Side.CLIENT)
    public float getShadowSize()
    {
        return 10.0F;
    }

    /**
     * Called when a player interacts with a mob. e.g. gets milk from a cow, gets into the saddle on a pig.
     */
    public boolean interact(EntityPlayer par1EntityPlayer)
    {
        if (riddenByEntity != null && (riddenByEntity instanceof EntityPlayer) && riddenByEntity != par1EntityPlayer)
        {
            return true;
        }

        if (!worldObj.isRemote)
        {
            par1EntityPlayer.mountEntity(this);
        }

        return true;
    }

    /**
     * Sets the damage taken from the last hit.
     */
    public void setDamageTaken(int par1)
    {
        dataWatcher.updateObject(19, Integer.valueOf(par1));
    }

    /**
     * Gets the damage taken from the last hit.
     */
    public int getDamageTaken()
    {
        return dataWatcher.getWatchableObjectInt(19);
    }

    /**
     * Sets the time to count down from since the last time entity was hit.
     */
    public void setTimeSinceHit(int par1)
    {
        dataWatcher.updateObject(17, Integer.valueOf(par1));
    }

    /**
     * Gets the time since the last hit.
     */
    public int getTimeSinceHit()
    {
        return dataWatcher.getWatchableObjectInt(17);
    }

	//正面方向を設定する
    public void setForwardDirection(int par1)
    {
        dataWatcher.updateObject(18, Integer.valueOf(par1));
    }
    
	//正面方向を取得する
    public int getForwardDirection()
    {
        return dataWatcher.getWatchableObjectInt(18);
    }


}
