package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityKishitudan extends EntityTHShot
{
	//緋想の剣の気質弾　ガストの火球を改造　　重力の影響を受けない

	private int count;

    public EntityKishitudan(World par1World)
    {
        super(par1World);
    	count = 0;
    }

    public EntityKishitudan(World world, EntityLiving entity_p, Entity entity_s, double xVector, double yVector, double zVector,
    		double firstSpeed, double maxSpeed, double addSpeed, int damage)
    {
        super(world, entity_p, entity_s, xVector, yVector, zVector, firstSpeed, maxSpeed, addSpeed, 0.0D, 0.0D, 0.0D, damage, 0, 1.0F, 40);
        xVec += rand.nextGaussian() * 0.4D;
        yVec += rand.nextGaussian() * 0.4D;
        zVec += rand.nextGaussian() * 0.4D;
    	count = 0;
    }

	//気質弾が存在する限り呼び出されるメソッド
	@Override
    public void onUpdate()
    {
        super.onUpdate();

    	//時間停止した際に消えないときの対処用
    	count++;
    	if(count == 40)
    	{
    		if(!worldObj.isRemote)
    		{
    			setDead();
    		}
    	}

    }
	
	//ブロックやEntityに当たった時の処理
	@Override
    protected void onImpact(MovingObjectPosition movingObjectPosition)
    {
    	//当たった時の処理
    	if (!worldObj.isRemote)
    	{
    		Entity hitEntity = movingObjectPosition.entityHit;
        
    		//当たったEntityがいるなら
    		if ( hitEntity != null )
        	{
        		//それがEntityTHShotに属していないなら
        		if(hitEntity instanceof EntityTHShot == false)
        		{
        			//指定したダメージ分の魔法ダメージを与える
					if (!hitEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity), shotDamage));
        			//弾を消滅させる
        			setDead();
        		}
        		//EntityTHShotに属しているなら
        		else
        		{
        			EntityTHShot entityTHShot = (EntityTHShot)hitEntity;
        			if(userEntity != entityTHShot.userEntity)//使用者の違う弾同士は打ち消し合う
        			{
        				setDead();
        				entityTHShot.setDead();
        			}
        		}
			}
    		else
    		{
    			for(int i = 0; i < 12; i++)
    			{
	    			EntityTHShot entityTHShot;
	    			double xVector, yVector, zVector;
	    			float angleXZ, angleY;
	    			angleXZ = ((float)rand.nextInt(36000) / 100F) / 180F * 3.141593F;
	    			angleY  = ((float)rand.nextInt(36000) / 100F) / 180F * 3.141593F;
	    			xVector = -MathHelper.sin(angleXZ) * MathHelper.cos(angleY);
	    			yVector = -MathHelper.sin(angleY);
	    			zVector =  MathHelper.cos(angleXZ) * MathHelper.cos(angleY);
	    			entityTHShot = new EntityTHShot( worldObj, userEntity, this, posX, posY, posZ,
	    				xVector, yVector, zVector, 0.01D, 0.15D, 0.01D, 0.0D, 0.0D, 0.0D,
	    				4, 40, 0.3F, 90);
	    			worldObj.spawnEntityInWorld(entityTHShot);
    			}
    			this.setDead();//ブロックに当たったら消滅
    		}
    	}
    }
}
