package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMasterSpark extends EntityTHShot
{
	/*
	マスタースパーク
	地形破壊、高火力のレーザーを発射する
	*/
	public int count;
	public int flagtime;
	public double speed;
	public float size;
	public float oldSize;
	public int endtime;
	public int inicount;

	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityMasterSpark(World world)
    {
        super(world);
    	setSize(5.0F, 5.0F);
    	count = 0;
    	//endtime = 120;
    }

    public EntityMasterSpark(World world, EntityLiving entityUser, Entity entity,
    	double xPos, double yPos, double zPos,
    	double xVector, double yVector, double zVector, double firstSpeed,
    	float size, int flagt, int endt, int ini, float angleXZ, float angleY)
    {
        super(world, entityUser, entity, xPos, yPos, zPos, xVector, yVector, zVector, firstSpeed, firstSpeed, 1.0D, 0.0D, 0.0D, 0.0D, 6, 0, size, 120);
        setSize(5.0F, 5.0F);
    	setRotation(angleXZ, angleY);
    	speed = firstSpeed;
    	count = 0;
    	inicount = ini;
    	setIniTime(inicount);
    }
	
	public EntityMasterSpark(World world, EntityLiving entityUser, Entity entity,
    	double xVector, double yVector, double zVector, double firstSpeed,
    	float size, int flagt, int endt, int ini, float angleXZ, float angleY)
    {
    	this(world, entityUser, entity, entity.posX, entity.posY, entity.posZ, xVector, yVector, zVector, firstSpeed, size, flagt, endt, ini, angleXZ, angleY);
    }
	
	public EntityMasterSpark(World world, EntityLiving entityUser, Entity entity,
		double xPos, double yPos, double zPos,
		double xVector, double yVector, double zVector, float size,
		double length, int iniTime)
	{
		super(world, entityUser, entity, xPos, yPos, zPos, xVector, yVector, zVector, 0.5D, 0.5D, 1.0D, 0.0D, 0.0D, 0.0D, 4, 0, size, 5);
        setSize(5.0F, 5.0F);
    	//setRotation(angleXZ, angleY);

    	//setOldSize(0.3F);
    	//setNowSize(0.3F);
    	count = 0;
		setMaxLength(length);
		setIniTime(iniTime);
		motionX = xVector;
		motionY = yVector;
		motionZ = zVector;
		//rotationYaw = 
		//setVector();
    	//setFlagTime(30);
    	/*if(endt < 20)
    	{
    		setEndTime(endt);
    	}
    	else
    	{
    		setEndTime(20);
    	}*/
		//setEndTime(1);
	}
	
	@Override
	protected void entityInit()
	{
		super.entityInit();
		dataWatcher.addObject(15, new Integer(0));
		dataWatcher.addObject(16, new Integer(0));
	}
	
	/*
	*わからんので、翻訳機使用　描画判定のチェックか？
	*エンティティかどうかをチェックするには、遠くに過去を使用し、その平均エッジと比較することで、レンダリングする範囲内にある
	*長さ* 64 * renderDistanceWeightの引数：距離
	*/
	@SideOnly(Side.CLIENT)
    public boolean isInRangeToRenderDist(double d)
    {
        return true;
    }

	/*@Override
	public boolean canBePushed()
    {
        return true;
    }*/

	//マスタースパークが存在する限り呼び出されるメソッド
	@Override
    public void onUpdate()
    {
        //super.onUpdate();

    	if(!worldObj.isRemote)
    	{
    		setDead();
    	}
    }
	

	//弾が当たったときの処理
	@Override
    protected void onImpact(MovingObjectPosition movingobjectposition)
    {
    	//当たった時の処理　　気質弾同士のあたり判定はとらない
    }
	
	public void setIniTime(int par1)
	{
		dataWatcher.updateObject(15, Integer.valueOf(par1));
	}
	
	public int getIniTime()
	{
		return dataWatcher.getWatchableObjectInt(15);
	}
	
	public void setMaxLength(double par1)
	{
		dataWatcher.updateObject(16, Integer.valueOf((int)(par1 * 100.0D)));
	}
	
	public double getMaxLength()
	{
		return (double)dataWatcher.getWatchableObjectInt(16) / 100.0D;
	}
	
	@Override
	public boolean canBeCollidedWith()
    {
        return false;
    }
	
}
