package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMazinkyoukan extends Entity
{
	//魔人経巻

	public EntityPlayer userPlayer;
	public int count;
	public float turnAngle;
	public int befUseCount;

	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityMazinkyoukan(World par1World)
    {
        super(par1World);
        //preventEntitySpawning = true;
        setSize(2.0F, 2.0F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定
    }

	//出現時に呼び出されるコンストラクト
    public EntityMazinkyoukan(World par1World,EntityPlayer entityPlayer)
    {
        this(par1World);
    	setSize(2.0F, 2.0F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
    	userPlayer = entityPlayer;
    	prevPosX = entityPlayer.posX;
        prevPosY = entityPlayer.posY;
        prevPosZ = entityPlayer.posZ;
        setPosition(entityPlayer.posX, entityPlayer.posY+1.4D, entityPlayer.posZ);//初期位置を設定(x,y,z)
    	setRotation(entityPlayer.rotationYaw,  0.0F);
    	count = 0;
    	befUseCount = 0;
    	turnAngle = 0F;
    }

	//生成時に呼ばれる
    protected void entityInit()
    {
    }
	
	/**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    protected boolean canTriggerWalking()
    {
        return false;
    }

	//当たり判定の有無　falseだと右クリックの選択ですらできない。trueならsetSize()で設定したボックスの当たり判定が出現する
    public boolean canBeCollidedWith()
    {
        return false;
    }

	//位置を更新
	public void updatePosition()
	{
		prevPosX = userPlayer.posX;
        prevPosY = userPlayer.posY;
        prevPosZ = userPlayer.posZ;
		posX = userPlayer.posX - Math.sin(rotationYaw / 180F * (float)Math.PI) * 0.5D;
		posY = userPlayer.posY + 1.4D;
		posZ = userPlayer.posZ + Math.cos(rotationYaw / 180F * (float)Math.PI) * 0.5D;
		setPosition(posX, posY, posZ);
	}

	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
    	//使用者がいないなら消す
    	if(!worldObj.isRemote && (userPlayer == null || userPlayer.isDead) )
    	{
    		setDead();
    	}
    	//super.onUpdate();
    	
    	//使用者が右クリックをやめたら消す
    	if(userPlayer != null)
    	{
    		//if(userPlayer.getItemInUseCount() == 0)
    		if(!userPlayer.isUsingItem())
    		{
    			int time = count;
    			time /= 3;
    			if( userPlayer.inventory.hasItem(Item.redstone.itemID))
    			{
    				if(!worldObj.isRemote)
    				{
    					userPlayer.addPotionEffect(new PotionEffect( 1, time * 20, 1));//スピードアップ
        				userPlayer.addPotionEffect(new PotionEffect( 5, time * 20, 1));//攻撃力アップ
        				userPlayer.addPotionEffect(new PotionEffect( 8, time * 20, 1));//跳躍力アップ
        				userPlayer.addPotionEffect(new PotionEffect(11, time * 20, 1));//防御力アップ
        				//entityPlayer.addPotionEffect(new PotionEffect(12, 15 * 20, 1));//炎耐性
        				userPlayer.inventory.consumeInventoryItem(Item.redstone.itemID);//レッドストーン消費
    				}
    			}
    			setDead();
    		}
    		else
    		{
    			updatePosition();
    			rotationYaw = userPlayer.rotationYaw;
    			rotationPitch = 0F;
    		}
    	}

    	count++;
    	if(count > 114)
    	{
    		count = 114;
    	}
    	else if(count > 50)
    	{
    		    turnAngle += 2.88F;
    	}


    	if(rotationYaw >  180F)rotationYaw -= 360F;
    	if(rotationYaw < -180F)rotationYaw += 360F;
    	if(rotationPitch >  180F)rotationPitch -= 360F;
    	if(rotationPitch < -180F)rotationPitch += 360F;
	}

	protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound)
    {
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound)
    {
    }
}
