package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMiniHakkero extends Entity
{
	//ミニ八卦炉

	private EntityLiving shootingEntity;
	private EntityLiving tgEntity;
	public int count;
	private float circleAngle;
	private int moveTexture;
	public int num;
	private int damage;

    public EntityMiniHakkero(World world)
    {
        super(world);
        preventEntitySpawning = true;
        setSize(0.4F, 0.4F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定
    }
	
    public EntityMiniHakkero(World world,EntityLiving entityLiving, int da)
    {
        this(world);

    	setSize(0.4F, 0.4F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
        setPosition(entityLiving.posX - MathHelper.sin(entityLiving.rotationYaw / 180F * 3.141593F) * MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F),
        			entityLiving.posY - MathHelper.sin(entityLiving.rotationPitch / 180F * 3.141593F) + (double)entityLiving.getEyeHeight() - 0.10000000149011612D ,
					entityLiving.posZ + MathHelper.cos(entityLiving.rotationYaw / 180F * 3.141593F) * MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F));//初期位置を設定(x,y,z)
    	rotationYaw = entityLiving.rotationYaw;
    	rotationPitch = entityLiving.rotationPitch;
    	shootingEntity = entityLiving;//使用者をshootingEntityに保存
    	tgEntity = null;
    	count = 0;
    	circleAngle = 0F;
    	moveTexture = 0;
    	damage = da;
    	worldObj.playSoundAtEntity(this, "random.masterspark", mod_thKaguya.MasterSparkVol, 1.0F);
    }
	
    public EntityMiniHakkero(World world,EntityLiving entityLiving, EntityLiving target)
    {
        this(world);

    	setSize(0.4F, 0.4F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
        setPosition(entityLiving.posX - MathHelper.sin(entityLiving.rotationYaw / 180F * 3.141593F) * MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F),
        			entityLiving.posY - MathHelper.sin(entityLiving.rotationPitch / 180F * 3.141593F) + (double)entityLiving.getEyeHeight() - 0.10000000149011612D ,
					entityLiving.posZ + MathHelper.cos(entityLiving.rotationYaw / 180F * 3.141593F) * MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F));//初期位置を設定(x,y,z)
    	//rotationYaw = (float)Math.atan2(target.posZ - posZ, target.posX - posX) / 3.141593F * 180F;
    	//rotationPitch = (float)Math.atan2( target.posY - posY, getDistance(target.posX, posY, target.posZ)) / 3.141593F * 180F;
    	rotationYaw = entityLiving.rotationYaw;
    	rotationPitch = entityLiving.rotationPitch;
    	shootingEntity = entityLiving;//使用者をshootingEntityに保存
    	tgEntity = target;
    	count = 0;
    	circleAngle = 0F;
    	moveTexture = 0;
    	damage = 1;
    	worldObj.playSoundAtEntity(this, "random.masterspark", mod_thKaguya.MasterSparkVol, 1.0F);
    }

	//
    protected void entityInit()
    {
    }

    /**
     * Returns true if this entity should push and be pushed by other entities when colliding.
     */
    public boolean canBePushed()
    {
        return false;
    }

    /**
     * Returns true if other Entities should be prevented from moving through this Entity.
     */
    public boolean canBeCollidedWith()
    {
    	return false;
    }

	//Entityの消滅処理
	private void finish()
	{
		/*if(damage == 1)
		{
			setDead();
		}*/
		if(shootingEntity instanceof EntityPlayer)
		{
			EntityPlayer entityPlayer = (EntityPlayer)shootingEntity;
			if(entityPlayer.capabilities.isCreativeMode)
			{
				setDead();
			}
			else if(entityPlayer.inventory.addItemStackToInventory(new ItemStack(mod_thKaguya.hakkeroItem, 1, 0)) == false)
			{
				//インベントリが一杯なら使用者の目の前でアイテム化
				//（クリエイティブでは常にインベントリには物が吸収される仕様があるらしく、クリエイティブでは落とさない（false判定がでない)）
				if(!shootingEntity.worldObj.isRemote)
				{
					dropItemWithOffset(mod_thKaguya.hakkeroItem.itemID, 1, 0.0F);
				}
			}
		}
		else
		{
			if(!shootingEntity.worldObj.isRemote)
			{
				dropItemWithOffset(mod_thKaguya.hakkeroItem.itemID, 1, 0.0F);
			}
		}
		setDead();
	}
	
	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
        super.onUpdate();
    	if(!worldObj.isRemote && shootingEntity == null)
    	{
    		setDead();
    	}

    	circleAngle += 4.7F;

    
	    double length = 0.0D;
	    double speed = 0.0D;
	    Vec3 vec3d;
	    Vec3 vec3d1;
	    MovingObjectPosition movingObjectPosition;
	    float yawRad = rotationYaw / 180F * 3.141593F;
	    float pitchRad = rotationPitch / 180F * 3.141593F;
	    double sinYaw = MathHelper.sin(yawRad);
	    double cosYaw = MathHelper.cos(yawRad);
	    double sinPitch = MathHelper.sin(pitchRad);
	    double cosPitch = MathHelper.cos(pitchRad);
	    double ax, ay, az, dx, dy, dz, px, py, pz;
	    
	    if(shootingEntity != null)
	    {
	    	do
	    	{	
	    		
	    		vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX - sinYaw * cosPitch * length, posY - sinPitch * length, posZ + cosYaw * cosPitch * length);
	    		if(speed < 1.6D)
	    		{
	    			speed += 0.2D;
	    		}
	    		else
	    		{
	    			speed = 1.6D;
	    		}
	    		length += speed;
	    		ax = -sinYaw * cosPitch * length;
	    		ay = -sinPitch * length;
	    		az =  cosYaw * cosPitch * length;
	    		px = posX + ax;
	    		py = posY + ay;
	    		pz = posZ + az;
	    		vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(px, py, pz);
	    		movingObjectPosition = worldObj.rayTraceBlocks(vec3d, vec3d1);
				float angleXZ, angleY;

				dx = posX - shootingEntity.posX;
				dy = posY - shootingEntity.posY;
				dz = posZ - shootingEntity.posZ;

				angleY  = (float)Math.atan2(dx, dz);
				angleXZ = (float)Math.atan2( Math.sqrt(dx*dx + dz*dz), dy);
			}while(movingObjectPosition == null && length < 30.0D);
	    	
	    	ax = -sinYaw * cosPitch;
	    	ay = -sinPitch;
	    	az =  cosYaw * cosPitch;

	    	EntityMasterSpark entityMasterSpark;
			entityMasterSpark = new EntityMasterSpark(worldObj, shootingEntity, this, posX + ax, posY + ay, posZ + az, ax, ay, az, 0.3F, length, ticksExisted);

			if(!worldObj.isRemote)
			{
				worldObj.spawnEntityInWorld(entityMasterSpark);
    		}
	    	if(ticksExisted > 20)//20ticks以上ならマスタースパークの当たり判定を出現させる
	    	{	
	    		double shotSize = 4.0D;
	        	List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.addCoord(-sinYaw * cosPitch * length, -sinPitch * length, cosYaw * cosPitch * length).expand(shotSize*2D, shotSize*2D, shotSize*2D));//指定範囲内のEntityをリストに登録
	    		Entity entity = null;
	    		double d = 0.0D;
	    		vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX - sinYaw * cosPitch, posY - sinPitch, posZ + cosYaw * cosPitch);
	    		vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX - sinYaw * cosPitch * length, posY - sinPitch * length, posZ + cosYaw * cosPitch * length);
	    		
	    		for (int j = 0; j < list.size(); j++)
	        	{
	            	Entity entity1 = (Entity)list.get(j);//entity1にリストの先端のentityを保存
	        		//entity1に当たり判定があり、ミニ八卦炉ではなく、使用者でもなく、弾幕でもなければ
	            	if ( entity1.canBeCollidedWith() && entity1 instanceof EntityMiniHakkero == false && !entity1.isEntityEqual(shootingEntity) && entity1 instanceof EntityTHShot == false)
	            	{
	            		AxisAlignedBB axisalignedbb = entity1.boundingBox.expand(shotSize, shotSize, shotSize);
	            		MovingObjectPosition movingObjectPosition1 = axisalignedbb.calculateIntercept(vec3d, vec3d1);
	            		if (movingObjectPosition1 != null)
	            		{
	            			//当たっているならここからその点までの距離を取得
            				double d1 = vec3d.distanceTo(movingObjectPosition1.hitVec);
        					//今までの一番近くにいるなら、一番近いEntityを更新する
            				if (d1 < d || d == 0.0D)
            				{
                				entity = entity1;
                				d = d1;
            				}
	            		}
	            	}
	        	}
				if (entity != null)
	        	{
	            	movingObjectPosition = new MovingObjectPosition(entity);
	        	}

	        	if (movingObjectPosition != null && movingObjectPosition.entityHit != null)//Entityに当たっているなら
	        	{
	        		if(tgEntity != null)
	    			{
	    				if (!movingObjectPosition.entityHit.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, shootingEntity), 8));
	    			}
	        		else
	        		{
	            		if(!worldObj.isRemote)
	    				{
	    					//威力5.0の強力な爆発を起こす。ブロックを破壊するかはコンフィグで設定（デフォは破壊する）
	    					worldObj.createExplosion(shootingEntity, movingObjectPosition.entityHit.posX, movingObjectPosition.entityHit.posY, movingObjectPosition.entityHit.posZ, getExplosionLevel(), tgEntity == null && mod_thKaguya.MasterSparkDestroysBlocks);
	    				}
	        		}
	        	}
	    		else if( movingObjectPosition != null && tgEntity == null)//ブロックに当たっているなら
	    		{
	    			if(!worldObj.isRemote)
	    			{
	    				//同上
	    				worldObj.createExplosion(shootingEntity, movingObjectPosition.hitVec.xCoord, movingObjectPosition.hitVec.yCoord, movingObjectPosition.hitVec.zCoord, getExplosionLevel(), tgEntity == null && mod_thKaguya.MasterSparkDestroysBlocks);
	    			}
	    		}
	    	}
    	}

		//時間で消滅
		if(count >= 99)
		{
			if(!worldObj.isRemote)
			{
				finish();
			}
		}
		else
		{
			count++;
		}
	}
	
	//マスパの爆発力
	private float getExplosionLevel()
	{
		return 5.0F;
	}

    /**
     * (abstract) Protected helper method to write subclass entity data to NBT.
     */
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    	nbttagcompound.setShort("count", (short)count);
    	nbttagcompound.setShort("damage", (short)damage);
    }

    /**
     * (abstract) Protected helper method to read subclass entity data from NBT.
     */
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    	count = nbttagcompound.getShort("count");
    	damage = nbttagcompound.getShort("damage");
    }

    public float getShadowSize()
    {
        return 0.5F;
    }

    protected boolean isValidLightLevel()
    {
        return true;
    }

    public int getBrightnessForRender(float par1)
    {
        return 0xf000f0;
    }

    /**
     * Gets how bright this entity is.
     */
    public float getBrightness(float par1)
    {
        return 0.5F;
    }

	public float getCircleAngle()
	{
		return circleAngle;
	}
}
