package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMiracleCircle extends Entity
{
	//風祝のお祓い棒の詠唱時のサークル

	public EntityPlayer usePlayer;
	private int color;
	public int count;
	public float turnAngle;
	public int befUseCount;

    public EntityMiracleCircle(World par1World)
    {
        super(par1World);
    }

    public EntityMiracleCircle(World par1World,EntityPlayer entityPlayer, int cl)
    {
        this(par1World);
    	setSize(2.0F, 0.0F);
        yOffset = 0.0F;
    	usePlayer = entityPlayer;
    	posX = usePlayer.posX - (double)MathHelper.sin((usePlayer.rotationYaw + turnAngle) / 180F * 3.141593F) * (double)MathHelper.cos(usePlayer.rotationPitch / 180F * 3.141593F) * 3.0D;
    	posY = usePlayer.posY - (double)MathHelper.sin(usePlayer.rotationPitch / 180F * 3.141593F) * (double)MathHelper.cos(turnAngle / 180F * 3.141593F) * 3.0D + usePlayer.getEyeHeight();
    	posZ = usePlayer.posZ + (double)MathHelper.cos((usePlayer.rotationYaw + turnAngle) / 180F * 3.141593F) * (double)MathHelper.cos(usePlayer.rotationPitch / 180F * 3.141593F) * 3.0D;
        setPosition(posX, posY, posZ);//初期位置を設定(x,y,z)
    	setRotation(entityPlayer.rotationYaw,  0.0F);
    	color = cl;
    	setColor(color);
    	//ticksExisted = color * 1000000;
    	count = 0;
    	befUseCount = 0;
    	turnAngle = 0F;
    }
	
	//生成時に呼ばれる
    protected void entityInit()
    {
    	dataWatcher.addObject(19, new Integer(0));
    }

	/**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
	@Override
    protected boolean canTriggerWalking()
    {
        return false;
    }

	//当たり判定の有無　falseだと右クリックの選択ですらできない。trueならsetSize()で設定したボックスの当たり判定が出現する
	@Override
    public boolean canBeCollidedWith()
    {
        return false;
    }

	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
    	if(!worldObj.isRemote && usePlayer == null)
    	{
    		setDead();
    	}
    	super.onUpdate();
    	if(usePlayer != null)
    	{
    		//if(usePlayer.getItemInUseCount() == 0)
    		if(!usePlayer.isUsingItem())
    		{
    			if(-befUseCount >= 250 && usePlayer.experienceLevel >= 40)//大奇跡「八坂の神風」の使用条件を満たしているなら
    			{
    				EntitySanaeWind entitySanaeWind = new EntitySanaeWind(worldObj, usePlayer, this, 0.6D, 1);//強力な風になる
    				if(!worldObj.isRemote)
    				{
    					worldObj.spawnEntityInWorld(entitySanaeWind);
    				}
    			}
    			if(!worldObj.isRemote)
    			{
    				setDead();
    			}
    		}
    	}
    	count++;
    	/*if(count == 50 && getColor() < 4)//カウントが50なら
    	{
    		EntityMiracleCircle entityMiracle = new EntityMiracleCircle(worldObj, usePlayer, getColor() + 1);//次の五芒星を作る
    		if(!worldObj.isRemote)
    		{
    			worldObj.spawnEntityInWorld(entityMiracle);
    		}
    	}*/

    	if(usePlayer != null)
    	{
        	prevPosX = posX;
        	prevPosY = posY;
        	prevPosZ = posZ;

    		posX = usePlayer.posX - (double)MathHelper.sin((usePlayer.rotationYaw + turnAngle) / 180F * 3.141593F) * (double)MathHelper.cos(usePlayer.rotationPitch / 180F * 3.141593F) * 3.0D;
    		posY = usePlayer.posY - (double)MathHelper.sin(usePlayer.rotationPitch / 180F * 3.141593F) * (double)MathHelper.cos(turnAngle / 180F * 3.141593F) * 3.0D + usePlayer.getEyeHeight();
    		posZ = usePlayer.posZ + (double)MathHelper.cos((usePlayer.rotationYaw + turnAngle) / 180F * 3.141593F) * (double)MathHelper.cos(usePlayer.rotationPitch / 180F * 3.141593F) * 3.0D;
    		rotationYaw = usePlayer.rotationYaw;
    		rotationPitch = usePlayer.rotationPitch;
    		befUseCount = getColor() * 50 + count;//usePlayer.getItemInUseCount();
    	}
    	setPosition(posX, posY, posZ);

    	if(count > 50)
    	{
    		turnAngle += 2.88F;
    	}

    	if(rotationYaw >  180F)rotationYaw -= 360F;
    	if(rotationYaw < -180F)rotationYaw += 360F;
    	if(rotationPitch >  180F)rotationPitch -= 360F;
    	if(rotationPitch < -180F)rotationPitch += 360F;

    	setRotation(rotationYaw, rotationPitch);
    }
	
	public void setColor(int par1)
	{
		dataWatcher.updateObject(19, Integer.valueOf(par1));
	}

	//現在の色のパターンを返す
	public int getColor()
	{
		return dataWatcher.getWatchableObjectInt(19);
	}

	//現在の五芒星の書いた線の数を返す
	public int getNumberOfDrewLine()
	{
		int time = count;
		if(time > 50)
		{
			return 5;
		}
		else
		{
			return time / 10 + 1;
		}
	}

	//今書いている線のカウント
	public int getLastLineTime()
	{
		int time = count;
		if(time > 50)
		{
			return 10;
		}
		else
		{
			return time % 10;
		}
	}

	protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound)
    {
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound)
    {
    }
}
