package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMusouFuuin extends EntityTHShot
{
	//夢想封印の光弾
	
	Entity tgEntity;//スペルカードを使用した相手
	
	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityMusouFuuin(World world)
    {
        super(world);
    }

    public EntityMusouFuuin(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector,
    		double firstSpeed, double maxSpeed, double addSpeed, int damage, int color, float size, Entity target)
    {
        super(world, entityLiving, xVector, yVector, zVector, firstSpeed, maxSpeed, addSpeed, damage, color, size);
    	tgEntity = target;
    }
	
	//弾幕の特殊な動きを記述
	@Override
	public void specialMotion()
	{
		if(ticksExisted < 10)
		{
			motionX *= 0.6D;
			motionY *= 0.6D;
			motionZ *= 0.6D;
		}
		else
		{
			if(tgEntity != null)
			{
				double xzDistance = Math.sqrt( (tgEntity.posX - posX) * (tgEntity.posX - posX) + (tgEntity.posZ - posZ) * (tgEntity.posZ - posZ));
				rotationYaw = (float)Math.atan2( tgEntity.posX - posX, tgEntity.posZ - posZ) / 3.141593F * 180F;
				rotationPitch = (float)Math.atan2( (tgEntity.posY + 1.0D) - posY, xzDistance) / 3.141593F * 180F;
				setRotation(rotationYaw, rotationPitch);
			}
		}
	}
}
