package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityPendulum extends Entity
{
	//ナズーリンのペンデュラム
	//指定したブロックが近くにあるか探す

	private EntityPlayer shootingEntity;
	private int mode;
	private int searchBlockID;
	private int searchCount;
	private int searchLength;
	private int searchX;
	private int searchY;
	private int searchZ;
	private int searchMaxX;
	private int searchMaxY;
	private int searchMaxZ;
	private float pendulumRotation;

    public EntityPendulum(World par1World)
    {
        super(par1World);
        preventEntitySpawning = true;
        setSize(0.4F, 0.4F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定

    	pendulumRotation = 0.0F;
    }

	//最初に一度呼び出される
    protected void entityInit()
    {
		dataWatcher.addObject(16, new Integer(0));
    	dataWatcher.addObject(17, new Integer(0));
    }

	//押すことができるか
    public boolean canBePushed()
    {
        return false;
    }

    public EntityPendulum(World par1World,EntityPlayer entityLiving, int pmode, int blockID)
    {
        this(par1World);

    	setSize(0.4F, 0.4F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
    	prevPosX = entityLiving.posX;
        prevPosY = entityLiving.posY;
        prevPosZ = entityLiving.posZ;
        setPosition(entityLiving.posX - (double)MathHelper.sin((entityLiving.rotationYaw+30.0F) / 180F * 3.141593F),
        			entityLiving.posY + entityLiving.getEyeHeight() - 0.5D,
        			entityLiving.posZ + (double)MathHelper.cos((entityLiving.rotationYaw+30.0F) / 180F * 3.141593F));//初期位置を設定(x,y,z)
    	rotationYaw = 0F;//entityLiving.rotationYaw;
		mode = pmode;
    	if(mode == 1)
		{
			searchLength = 24;
		}
    	else
    	{
    		searchLength = 12;
    	}
    	shootingEntity = entityLiving;//使用者をshootingEntityに保存
    	searchBlockID = blockID;
    	searchCount = 0;
    	pendulumRotation = 0.0F;
    }

	//当たることができるか
    public boolean canBeCollidedWith()
    {
        return false;
    }

	//ペンデュラムを終了した時の処理
	private void finish()
	{
		if(shootingEntity instanceof EntityPlayer)
		{
			EntityPlayer entityPlayer = (EntityPlayer)shootingEntity;
			if(entityPlayer.capabilities.isCreativeMode)
			{
				setDead();
				return;
			}
		}
		if(shootingEntity != null)
		{
			if(shootingEntity.inventory.addItemStackToInventory(new ItemStack(mod_thKaguya.pendulumItem, 1)) == false)
			{
				//インベントリが一杯なら使用者の目の前でアイテム化
				//（クリエイティブでは常にインベントリには物が吸収される仕様があるらしく、クリエイティブでは落とさない（false判定がでない)）
				if(!worldObj.isRemote)
				{
					shootingEntity.dropItemWithOffset(mod_thKaguya.pendulumItem.itemID, 1, 0.0F);
				}
			}
			//}
		}
		else//使用者がいない場合（再起動した際など）にはその場にアイテム化
		{
			if(!worldObj.isRemote)
			{
				dropItemWithOffset(mod_thKaguya.pendulumItem.itemID, 1, 0.0F);
			}
    	}
		setDead();
	}

	//Entityが存在する限り毎フレーム呼び出されるメソッド
    public void onUpdate()
    {
        super.onUpdate();

    	if(!worldObj.isRemote && shootingEntity == null)
    	{
    		finish();
    	}

    	if(!worldObj.isRemote && shootingEntity != null)
    	{
    		if(ticksExisted > 10 && shootingEntity.isSneaking())
    		{
    			finish();
    		}
    		if(shootingEntity.hurtTime > 0)
    		{
    			finish();
    		}
    	}

        prevPosX = posX;
        prevPosY = posY;
        prevPosZ = posZ;

    	//サーチの処理
    	//if(ticksExisted % 10 == 0)
		{
			searchCount = 0;
			searchX = (int)posX - searchLength;
			searchZ = (int)posZ - searchLength;
			searchY = (int)posY - searchLength;
			searchMaxX = searchX + searchLength * 2 + 1;
			searchMaxY = searchY + searchLength * 2 + 1;
			searchMaxZ = searchZ + searchLength * 2 + 1;

			for(int si = searchX; si < searchMaxX; si++)
			{
				for(int sk = searchZ; sk < searchMaxZ; sk++)
				{
					for(int sj = searchY; sj < searchMaxY; sj++)
					{
						if( worldObj.getBlockId( si, sj, sk) == searchBlockID)
						{
							searchCount++;
						}
					}
				}
			}
			if(searchCount > 32)
			{
				searchCount = 32;
			}
			
		}
    	setSearchCount(searchCount);

    	//動作の処理
    	if(shootingEntity != null)//shootingEntityが存在するなら、それをぬるぬる追尾する
    	{
    		float angleXZ,angleY, speed;
    		float disXZ;
    		double px, py, pz;
    		px = shootingEntity.posX - (double)MathHelper.sin((shootingEntity.rotationYaw + 30F) / 180F * 3.141593F) * 1.2D;
    		py = shootingEntity.posY + shootingEntity.getEyeHeight() - 0.5D;//若干目の高さより下に設置
    		pz = shootingEntity.posZ + (double)MathHelper.cos((shootingEntity.rotationYaw + 30F) / 180F * 3.141593F) * 1.2D;
    		disXZ = (float)Math.sqrt( (px-posX)*(px-posX) + (pz-posZ)*(pz-posZ) );
    		angleXZ = (float)Math.atan2(pz-posZ, px-posX);
    		angleY  = (float)Math.atan2(disXZ, py-posY);
    		speed = 0.3F * (float)Math.sqrt( (px-posX)*(px-posX) + (py-posY)*(py-posY) + (pz-posZ)*(pz-posZ) );//離れるほど速くなる
    		/*setPosition(
    			posX + Math.cos(angleXZ)*speed,
    			posY + Math.cos(angleY )*speed,
    			posZ + Math.sin(angleXZ)*speed);*/
    		/*setPosition(
    			posX + Math.cos(pendulumRotation / 180F * (float)Math.PI) * (double)searchCount / 300.0,
    			posY + shootingEntity.yOffset,
    			posZ + Math.sin(pendulumRotation / 180F * (float)Math.PI) * (double)searchCount / 300.0);*/
    		motionX = shootingEntity.motionX + (px - posX);
    		motionY = shootingEntity.motionY + (py - posY);
    		motionZ = shootingEntity.motionZ + (pz - posZ);
    		setPosition(px, py, pz);
    		/*setPosition(
    			px + Math.cos(pendulumRotation / 180F * (float)Math.PI) * (double)searchCount / 300.0,
    			py + shootingEntity.yOffset + 1.2D,
    			pz + Math.sin(pendulumRotation / 180F * (float)Math.PI) * (double)searchCount / 300.0);
    		*/
    	}
    	/*else
    	{
    		setPosition(
    			posX,
    			posY,
    			posZ);
    	}*/
    	if(searchCount != 0)
    	{
    		pendulumRotation = getSearchAngle();
    		pendulumRotation += (float)getSearchCount() / 3.0F;
    		setSearchAngle( pendulumRotation );
        	//rotationYaw += (float)getSearchCount() / 3.0F;
    		rotationYaw += 3.0F;
    	}
	}

    public float getShadowSize()
    {
        return 0.5F;
    }

    //データを保存する処理
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    	//nbttagcompound.setShort("searchBlockID", (short)searchBlockID);
    }

	//保存したデータの読み出す処理
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    	//searchBlockID = nbttagcompound.getShort("searchBlockID");
    }
    
    public void setSearchAngle(float angle)
	{
		dataWatcher.updateObject(16, Integer.valueOf((int)(angle * 100.0F)));
	}
	
	@SideOnly(Side.CLIENT)
	public float getSearchAngle()
	{
		return (float)dataWatcher.getWatchableObjectInt(16) / 100.0F;
	}
	
	public void setSearchCount(int count)
	{
		dataWatcher.updateObject(17, Integer.valueOf(count));
	}
	
	public int getSearchCount()
	{
		return dataWatcher.getWatchableObjectInt(17);
	}
}
