package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.client.audio.SoundManager;

public class EntityPrivateSquare extends Entity
{
	//時間を停止させる空間

	private EntityPlayer shootingEntity;
	private int count;
	private int mode;
	private float watchRotation;

    public EntityPrivateSquare(World par1World)
    {
        super(par1World);
        preventEntitySpawning = true;
        setSize(0.4F, 0.4F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定
    	mode = 1;
    	shootingEntity = null;
    }
	
    public EntityPrivateSquare(World par1World,EntityPlayer entityLiving, int pmode)
    {
        this(par1World);

    	setSize(0.4F, 0.4F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
    	prevPosX = entityLiving.posX;
        prevPosY = entityLiving.posY;
        prevPosZ = entityLiving.posZ;
        setPosition(entityLiving.posX - (double)MathHelper.sin((entityLiving.rotationYaw + 30.0F) / 180F * 3.141593F),
        			entityLiving.posY + entityLiving.getEyeHeight() - 0.5D,
        			entityLiving.posZ + (double)MathHelper.cos((entityLiving.rotationYaw + 30.0F) / 180F * 3.141593F));//初期位置を設定(x,y,z)
    	rotationYaw = entityLiving.rotationYaw;
		mode = pmode;
    	shootingEntity = entityLiving;//使用者をshootingEntityに保存
    	count = 0;
    	watchRotation = 0.0F;
    }
	
	protected void entityInit()
    {
    }

    /**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    protected boolean canTriggerWalking()
    {
        return false;
    }

    /**
     * Returns true if this entity should push and be pushed by other entities when colliding.
     */
    public boolean canBePushed()
    {
        return false;
    }

	//他のEntityと衝突するか
    public boolean canBeCollidedWith()
    {
        return false;
    }

	//懐中時計の効果が切れた時の処理
	public void finish()
	{
		if(shootingEntity instanceof EntityPlayer)
		{
			EntityPlayer entityPlayer = (EntityPlayer)shootingEntity;
			if(entityPlayer.capabilities.isCreativeMode)
			{
				setDead();
				return;
			}
		}
		if(shootingEntity != null)
		{
			if(shootingEntity.isDead)
			{
				if(!worldObj.isRemote)
				{
					worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(mod_thKaguya.sakuyawatchItem)));
				}
			}

			if(shootingEntity.inventory.addItemStackToInventory(new ItemStack(mod_thKaguya.sakuyawatchItem, 1)) == false)
			{
				//インベントリが一杯なら使用者の目の前でアイテム化
				//（クリエイティブでは常にインベントリには物が吸収される仕様があるらしく、クリエイティブでは落とさない（false判定がでない)）
				if(!worldObj.isRemote)
				{
					worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(mod_thKaguya.sakuyawatchItem)));
				}
			}
		}
		else//使用者がいない場合（再起動した際など）にはその場にアイテム化
		{
			if(!worldObj.isRemote)
			{
				worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(mod_thKaguya.sakuyawatchItem)));
			}
    	}
		setDead();
	}

	//Entityが存在する限り毎フレーム呼び出されるメソッド
    public void onUpdate()
    {
        super.onUpdate();

    	if(!worldObj.isRemote && shootingEntity == null)//shootingEntityがいないなら終了
    	{
    		finish();
    	}
    	if(shootingEntity != null)
    	{
    		if(!shootingEntity.capabilities.isCreativeMode)//クリエイティブモードでないなら
    		{
    			if(mode == 0)//時間停止モードなら
    			{
    				shootingEntity.addExhaustion(0.25F);
    			}
    			else//時間減速モードなら
    			{
    				shootingEntity.addExhaustion(0.10F);
    			}
    		}
    		if(ticksExisted > 10 && shootingEntity.isSneaking())//出現から時間が経っていて、スニークモードなら終了
    		{
    			if(!worldObj.isRemote)
    			{
    				finish();
    			}
    		}
    		if(shootingEntity.hurtTime > 0)//shootingEntityがダメージを受けたら終了
    		{
    			if(!worldObj.isRemote)
    			{
    				finish();
    			}
    		}
    	}

    	//世界の時間を止める
    	/*if(mode == 0)
    	{
    		worldObj.worldInfo.setWorldTime(worldObj.worldInfo.getWorldTime() - 1L);
    	}
    	else if(count % 2 == 0)//世界の時間を遅くする
    	{
    		worldObj.worldInfo.setWorldTime(worldObj.worldInfo.getWorldTime() - 1L);
    	}*/


    	if(shootingEntity != null)//shootingEntityが存在するなら、それをぬるぬる追尾する
    	{
    		float angleXZ,angleY, speed;
    		float disXZ;
    		double px, py, pz;
    		px = shootingEntity.posX - (double)MathHelper.sin((shootingEntity.rotationYaw + 30F) / 180F * 3.141593F) * 1.2D;
    		py = shootingEntity.posY + shootingEntity.getEyeHeight() - 0.5D;
    		pz = shootingEntity.posZ + (double)MathHelper.cos((shootingEntity.rotationYaw + 30F) / 180F * 3.141593F) * 1.2D;
    		disXZ = (float)Math.sqrt( (px-posX)*(px-posX) + (pz-posZ)*(pz-posZ) );
    		angleXZ = (float)Math.atan2(pz-posZ, px-posX);
    		angleY  = (float)Math.atan2(disXZ, py-posY);
    		speed = 0.3F * (float)Math.sqrt( (px-posX)*(px-posX) + (py-posY)*(py-posY) + (pz-posZ)*(pz-posZ) );//離れるほど速くなる
    		motionX = shootingEntity.motionX + (px - posX);
    		motionY = shootingEntity.motionY + (py - posY);
    		motionZ = shootingEntity.motionZ + (pz - posZ);
    		setPosition(
    			px ,
    			py + shootingEntity.yOffset + 1.4D,
    			pz );
    	}
    	else//shootingEntityが存在しないならその場待機
    	{
    		setPosition(
    			posX,
    			posY,
    			posZ);
    	}

    	watchRotation += 10.0F;
    	if(watchRotation > 180F)
    	{
    		watchRotation -= 360F;
    	}
    	rotationYaw = watchRotation;
    	/*rotationYaw += 10.0F;
    	if(rotationYaw > 180F)
    	{
    		rotationYaw -= 360F;
    	}*/

    	int playerCount = 0;//停止空間内のプレイヤーの数を数える　誰もいなければ消滅させる
    	//***********　停止空間（時計じゃなくてもっと大きな見えない壁）とEntityの当たり判定を取る　よくわからん****************//
    	MovingObjectPosition movingobjectposition = new MovingObjectPosition(this);
    	Entity entity = null;
    	List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(20.0D, 20.0D,20.0D));

        if (list != null && list.size() > 0)
        {
            for (int j1 = 0; j1 < list.size(); j1++)
            {
                entity = (Entity)list.get(j1);
            	if (entity != null )
        		{
            		movingobjectposition = new MovingObjectPosition(entity);
        		}
            	if(entity instanceof EntityPlayer)
            	{
            		playerCount++;
            	}
            	if(entity instanceof EntityPrivateSquare)
            	{
            		EntityPrivateSquare entityPS = (EntityPrivateSquare)entity;
            		entityPS.finish();
            	}
            	/*if(movingobjectposition.entityHit instanceof EntityPrivateSquare)
            	{
            		finish();
            		EntityPrivateSquare eps2 = (EntityPrivateSquare)movingobjectposition.entityHit;
            		eps2.finish();
            	}*/
        		if (!worldObj.isRemote && movingobjectposition != null && movingobjectposition.entityHit != shootingEntity)
        		{
            		inPrivateSquare(movingobjectposition);//時間操作空間の処理
        		}
            }
        }

    	if(playerCount == 0)
    	{
    		if(!worldObj.isRemote)
    		{
    			finish();
    		}
    	}

        //************************************************************************************//

		count ++;
    	if(count % 20 == 19)
    	{
    		worldObj.playSoundAtEntity(this, "random.orb", 0.5F, 6.0F);
    		worldObj.playSoundAtEntity(this, "random.click", 0.5F, 4.0F);
    	}
}

    //EntityのデータをNBTに書き込む
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    	nbttagcompound.setShort("count", (short)count);
    }

	//NBTからEntityのデータを読み込む
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    	count = nbttagcompound.getShort("count");
    }

    public float getShadowSize()
    {
        return 0.5F;
    }


	//時間操作空間に入っていた時の処理
	protected void inPrivateSquare(MovingObjectPosition movingobjectposition)
    {
    	//SoundManager soundManager = new SoundManager();
    	//Entityが誕生してから２フレーム経過したもののみ判定
    	if(movingobjectposition.entityHit != null && movingobjectposition.entityHit.ticksExisted > 2)
    	{
    		//====時間停止空間の場合====//
    		if(mode == 0)
    		{
    		//Entityを１フレーム前の状態に、できる限りもっていく処理
	    		movingobjectposition.entityHit.setPosition( movingobjectposition.entityHit.prevPosX,
	    													movingobjectposition.entityHit.prevPosY,
	    													movingobjectposition.entityHit.prevPosZ);
    			//worldObj.removeEntity(movingobjectposition.entityHit);
    			movingobjectposition.entityHit.motionX *= 0.000000001;
	    		movingobjectposition.entityHit.motionY *= 0.000000001;
	    		movingobjectposition.entityHit.motionZ *= 0.000000001;
	    		//movingobjectposition.entityHit.rotationPitch = movingobjectposition.entityHit.prevRotationPitch;
	    		//movingobjectposition.entityHit.rotationYaw = movingobjectposition.entityHit.prevRotationYaw;
    			/*movingobjectposition.entityHit.setLocationAndAngles(	movingobjectposition.entityHit.prevPosX,
    									movingobjectposition.entityHit.posY,
    									movingobjectposition.entityHit.prevPosZ,
    									movingobjectposition.entityHit.rotationPitch,
    									movingobjectposition.entityHit.rotationYaw);*/
	    		movingobjectposition.entityHit.ticksExisted--;//誕生してからのカウントを増やさない
	    		movingobjectposition.entityHit.fallDistance -= 0.076865F;//落下距離を変動しないように　この値はフレームに比例するが、どこに書いてあるかわからん（一応かなり近い値ではある）
    			if(movingobjectposition.entityHit instanceof EntityLiving)
    			{
    				EntityLiving entityliving = (EntityLiving)movingobjectposition.entityHit;
    				entityliving.rotationYawHead = entityliving.prevRotationYawHead;
    				entityliving.setAttackTarget(null);
    				//entityliving.rotationPitchHead = entityliving.prevRotationPitchHead;
    				/*if(entityliving.hurtTime > 0)
    				{
    					entityliving.hurtTime++;
    				}*/
    				/*if(entityliving.deathTime > 1)
    				{
    					entityliving.deathTime--;
    				}*/
    				entityliving.attackTime--;
    				//entityliving.livingSoundTime--;
    				//entityliving.setLastAttackingEntity(null);

    				if(entityliving instanceof EntityCreeper)
    				{
    					EntityCreeper entityCreeper = (EntityCreeper)entityliving;
    					if(count % 2 == 0)
    					{
    						entityCreeper.setCreeperState(-1);
    					}
    					//entitycreeper.timeSinceIgnited --;
    				}
    				/*else if(entityliving instanceof EntitySkeleton)
    				{
    					EntitySkeleton entityskeleton = (EntitySkeleton)entityliving;
    					//entityskeleton.resetTask();
    					entitySkelton.func_48090_aM()
    				}*/
    				else if(entityliving instanceof EntityGhast)
    				{
    					EntityGhast entityghast = (EntityGhast)entityliving;
    					entityghast.attackCounter--;
    				}

    				if(entityliving instanceof EntityTameable)
    				{
    					//EntityTameable entitytameable = (EntityTameable)entityliving;
    					//if(entitytameable.isTamed())
    					//{
    						entityliving.motionY-=0.000001D;//座っている動物は重力がなくなると立つみたい　わからない程度に重力をかける処理
    						//entitytameable.motionY-=0.000001D;
    						//entitytameable.func_48140_f(true);
    						//entitytameable.aiSit.func_48407_a(entitytameable.isSitting());
    						//entitytameable.setPathToEntity(null);
    					//}
    					//entitytameable.aiSit.func_48407_a(false);
    				}
    			}
    			//soundManager.stopEntitySound(movingobjectposition.entityHit);
    			
	    		//加速だけは全Entityが処理していないため無理そう　　だから重力の影響を受けるものは扱いにくい
    		}
    		//====時間減速空間の場合====//
    		else//時間を1/2の進みにする
    		{
    			movingobjectposition.entityHit.motionX -= (movingobjectposition.entityHit.posX-(movingobjectposition.entityHit.prevPosX))/2.0F;
    			movingobjectposition.entityHit.motionY -= (movingobjectposition.entityHit.posY-(movingobjectposition.entityHit.prevPosY))/2.0F;
    			movingobjectposition.entityHit.motionZ -= (movingobjectposition.entityHit.posZ-(movingobjectposition.entityHit.prevPosZ))/2.0F;
	    		//movingobjectposition.entityHit.setPosition( movingobjectposition.entityHit.prevPosX,// - movingobjectposition.entityHit.motionX,
	    		//											movingobjectposition.entityHit.prevPosY,// - movingobjectposition.entityHit.motionY,
	    		//											movingobjectposition.entityHit.prevPosZ);// - movingobjectposition.entityHit.motionZ);
	    		//movingobjectposition.entityHit.rotationPitch = movingobjectposition.entityHit.prevRotationPitch;
	    		//movingobjectposition.entityHit.rotationYaw = movingobjectposition.entityHit.prevRotationYaw;
    			movingobjectposition.entityHit.fallDistance -= 0.076865F/2F;//落下距離を半減（空中待機時間で変動してしまう）
    			if( count % 2 == 0)//偶数フレームのみ処理
    			{
	    			movingobjectposition.entityHit.ticksExisted--;//誕生してからのカウントを増やさない
    				if(movingobjectposition.entityHit instanceof EntityLiving)
    				{
    					EntityLiving entityliving = (EntityLiving)movingobjectposition.entityHit;
    					entityliving.rotationYawHead = entityliving.prevRotationYawHead;
    					entityliving.setLastAttackingEntity(null);

    					if(entityliving instanceof EntityCreeper)
    					{
    						EntityCreeper entityCreeper = (EntityCreeper)entityliving;
    						if(count % 4 == 0)
    						{
    							entityCreeper.setCreeperState(-1);
    						}
    						//entitycreeper.timeSinceIgnited --;
    					}
    					else if(entityliving instanceof EntityGhast)
    					{
    						EntityGhast entityghast = (EntityGhast)entityliving;
    						entityghast.attackCounter--;
    					}
    				}
    			}
	    		//加速だけは全Entityが処理していないため無理そう　　だから重力の影響を受けるものは扱いにくい
    		}
        }
    }

}
