package net.minecraft.thKaguyaMod;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityGhast;;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityRyuuLightningBolt extends EntityTHShot
{
	//龍の頸の玉　雪玉を改造　着地点に雷を落とす

	public float color_r;
	public float color_g;
	public float color_b;

    public EntityRyuuLightningBolt(World par1World)
    {
        super(par1World);
    }

    public EntityRyuuLightningBolt(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector, float cr, float cg, float cb)
    {
    	super(world, entityLiving, (Entity)entityLiving, xVector, yVector, zVector, 0.7D, 0.7D, 1.0D, 0.0D, GRAVITY_DEFAULT, 0.0D,  7, 0, 1.0F, 120);
    	color_r = cr;
    	color_g = cg;
    	color_b = cb;
    }

    public EntityRyuuLightningBolt(World world, EntityLiving entityLiving, double x, double y, double z, double xVector, double yVector, double zVector, float cr, float cg, float cb)
    {
        super(world, entityLiving, (Entity)entityLiving, xVector, yVector, zVector, 0.7D, 0.7D, 1.0D, 0.0D, GRAVITY_DEFAULT, 0.0D, 7, 0, 1.0F, 120);
    	color_r = cr;
    	color_g = cg;
    	color_b = cb;
    }

	//ブロックやEntityに当たったときの処理
	@Override
    protected void onImpact(MovingObjectPosition par1MovingObjectPosition)
    {
    	super.onImpact(par1MovingObjectPosition);
        /*if (par1MovingObjectPosition.entityHit != null && !(par1MovingObjectPosition.entityHit instanceof EntityRyuuLightningBolt))
        {
            byte damage = 3;//直接当てるとハート1.5ダメージ

        	//ネザーのモンスターに当たったなら（炎に耐性のある敵に変えようかな？）
            if (par1MovingObjectPosition.entityHit instanceof EntityBlaze ||
            	par1MovingObjectPosition.entityHit instanceof EntityPigZombie ||
            	par1MovingObjectPosition.entityHit instanceof EntityGhast ||
            	par1MovingObjectPosition.entityHit instanceof EntityMagmaCube
            )
            {
                damage = 10;//ネザーのモンスターにはハート５つ分のダメージになる
            }

            if (!par1MovingObjectPosition.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, shootingEntity), damage));
        }*/
    	
    	EntityTHLaser[] entityTHLaser = new EntityTHLaser[5];
    	int colors[] = {0, 2, 4, 5, 6};
    	float angle = (float)rand.nextInt(3600) / 10F;
    	for(int i = 0; i < 5; i++)
    	{
    		double xVector = -MathHelper.sin((rotationYaw + angle) / 180F * 3.141593F) * 0.4D;
			double yVector = 0.1D;
			double zVector =  MathHelper.cos((rotationYaw + angle) / 180F * 3.141593F) * 0.4D;
			entityTHLaser[i] = new EntityTHLaser(worldObj, userEntity, this, posX, posY + 0.3D, posZ, xVector, yVector, zVector, 0.1D, 0.3D, 0.1D, 0.0D, 3, colors[i], 0.15F, 40, 3.0D);
			if(!worldObj.isRemote)
			{
				worldObj.spawnEntityInWorld(entityTHLaser[i]);
			}
    		angle += 72F;
    	}
    	EntityTHShot[] entityTHShot = new EntityTHShot[10];
    	for(int i = 0; i < 10; i++)
    	{
    		double xVector = rand.nextGaussian() * 0.2D;
    		double yVector = 0.8D + (double)rand.nextInt(100) / 500.0D;
    		double zVector = rand.nextGaussian() * 0.2D;
    		entityTHShot[i] = new EntityTHShot(worldObj, userEntity, this, xVector, yVector, zVector,
    			0.4D, 0.4D, 0.05D, 0.0D, -0.02, 0.0D, 3, colors[rand.nextInt(5)], 0.8F, 120);
    		if(!worldObj.isRemote)
    		{
    			worldObj.spawnEntityInWorld(entityTHShot[i]);
    		}
    	}

    	//EntityColorLightningBolt entitylightningbolt = new EntityColorLightningBolt(worldObj, posX, posY, posZ, color_r, color_g, color_b);

		EntityLightningBolt entitylightningbolt = new EntityLightningBolt(worldObj, posX, posY, posZ);

    	//if(!worldObj.isRemote)
    	{
    		worldObj.spawnEntityInWorld(entitylightningbolt);//雷を落とす
    	}
    	if(!worldObj.isRemote)
    	{
    		setDead();
    	}
    }
	
	@Override
	public boolean hitCheckEx(Entity entity)
	{
		return entity instanceof EntityTHLaser || entity instanceof EntityRyuuLightningBolt;
	}
}
