package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySpellCard extends Entity
{
	//スペルカード

	private EntityLiving userEntity;
	private EntityLiving tgEntity;
	public int count;
	private int spellCardNumber;
	Vec3 tgVec;

    public EntitySpellCard(World world)
    {
        super(world);
        preventEntitySpawning = true;
        setSize(0.4F, 0.4F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定
    }
	
    public EntitySpellCard(World world,EntityLiving entityLiving, EntityLiving target, int num)
    {
        this(world);

    	setSize(0.4F, 0.4F);
        yOffset = 0.0F;
        setPosition(entityLiving.posX - (double)MathHelper.sin((entityLiving.rotationYaw + 30F) / 180F * 3.141593F) * (double)MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F),
        			entityLiving.posY - (double)MathHelper.sin(entityLiving.rotationPitch / 180F * 3.141593F) + (double)entityLiving.getEyeHeight() - 0.10000000149011612D ,
        			entityLiving.posZ + (double)MathHelper.cos((entityLiving.rotationYaw + 30F) / 180F * 3.141593F) * (double)MathHelper.cos(entityLiving.rotationPitch / 180F * 3.141593F));//初期位置を設定(x,y,z)
    	rotationYaw = entityLiving.rotationYaw;
    	rotationPitch = entityLiving.rotationPitch;
    	setRotation(rotationYaw, rotationPitch);
    	tgVec = entityLiving.getLookVec();
    	userEntity = entityLiving;//使用者をuserEntityに保存
    	tgEntity = target;//ターゲットした相手
    	spellCardNumber = num;
    	setSpellCardNumber(num);
    	count = 0;
    	worldObj.playSoundAtEntity(this, "random.spellcard", mod_thKaguya.SpellCardVol, 1.0F);
    }

	//
    protected void entityInit()
    {
    	dataWatcher.addObject(18, new Integer(0));
    }

    /**
     * Returns true if this entity should push and be pushed by other entities when colliding.
     */
    public boolean canBePushed()
    {
        return false;
    }

    /**
     * Returns true if other Entities should be prevented from moving through this Entity.
     */
    public boolean canBeCollidedWith()
    {
    	return false;
    }

	//Entityの消滅処理
	private void finish()
	{
		setDead();
	}
	
	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
        super.onUpdate();
    	if(!worldObj.isRemote && userEntity == null)
    	{
    		setDead();
    	}
    	
    	switch(spellCardNumber)
    	{
    		case 0://霊符「夢想封印」
    			spellCard_0();
    			break;
    		case 1://恋符「マスタースパーク」
    			spellCard_1();
    			break;
    		case 2://死蝶「華胥の永眠」
    			spellCard_2();
    			break;
    		case 3://星符「メテオニックシャワー」
    			spellCard_3();
    			break;
    		default://境符「波と粒の境界」
    			spellCard_4();
    	}
    	
    	//rotationYaw += 21F;

		//時間で消滅
		if(count >= 99)
		{
			if(!worldObj.isRemote)
			{
				finish();
			}
		}
		else
		{
			count++;
		}
	}
	
	//霊符「夢想封印」
	private void spellCard_0()
	{
		if(ticksExisted % 2 == 0 && ticksExisted > 15 && ticksExisted < 50)
		{
			float angle = (float)ticksExisted * 33F;
			double xVec = -(double)MathHelper.sin(angle / 180F * 3.141593F);
			double yVec = 0.0D;
			double zVec = (double)MathHelper.cos(angle / 180F * 3.141593F);
			if(userEntity != null && tgEntity != null)
			{
				EntityMusouFuuin entityMusouFuuin = new EntityMusouFuuin(worldObj, userEntity, xVec, yVec, zVec, 4.0D, 1.6D, 0.1D, 9, rand.nextInt(7), 2.0F, tgEntity);
				if(!worldObj.isRemote)
       			{
        			worldObj.spawnEntityInWorld(entityMusouFuuin);//夢想封印の光弾を出現させる
       			}
			}
		}
	}
	
	//恋符「マスタースパーク」
	private void spellCard_1()
	{
		if(ticksExisted == 1)
		{
			EntityMiniHakkero entityMiniHakkero;
    			
    		entityMiniHakkero = new EntityMiniHakkero(worldObj, userEntity, tgEntity);
       		if(!worldObj.isRemote)
       		{
        			worldObj.spawnEntityInWorld(entityMiniHakkero);//ミニ八卦炉を出す
       		}
		}
		if(/*ticksExisted % 3 == 0 &&*/ ticksExisted > 20 && ticksExisted < 90)
		{
			EntityTHShot[] entityTHShot = new EntityTHShot[7];
    		double xVector, yVector, zVector, xVectorG, yVectorG, zVectorG, gRate, angleXZ = 0, angleY = 0, X1, Z1, X2, Z2;
			Vec3 lookAt = tgVec;
			lookAt.xCoord = -MathHelper.sin(rotationYaw / 180F * 3.141593F) * MathHelper.cos((rotationPitch + 90F) / 180F * 3.141593F);
    		lookAt.yCoord =	-MathHelper.sin((rotationPitch + 90F) / 180F * 3.141593F);
    		lookAt.zCoord =	 MathHelper.cos(rotationYaw / 180F * 3.141593F) * MathHelper.cos((rotationPitch + 90F) / 180F * 3.141593F);
			lookAt.rotateAroundY((float)Math.PI * 2);
			float angle = (float)ticksExisted * 6F ;
			float angleSpan = 360F / 7F;
			//gRate = (double)(ticksExisted % 9) / 9D + 0.1D;
			gRate = 0.04 + 0.03D * Math.sin(angle / 180F *3.141593F);
    		for(int i = 0; i < 7; i++)
    		{
				angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
				angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る

				X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(rotationYaw/ 180.0F * Math.PI);
				Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(rotationYaw/ 180.0F * Math.PI);
				X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((rotationPitch + 90F)/ 180.0F * Math.PI) * Math.sin(rotationYaw/ 180.0F * Math.PI);
				Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((rotationPitch + 90F)/ 180.0F * Math.PI) * Math.cos(rotationYaw/ 180.0F * Math.PI);
						
				yVector = -Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((rotationPitch + 90F - angleY)/ 180.0F * Math.PI);//Y方向　上下
				xVector =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
				zVector =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
    			xVectorG = -MathHelper.sin(rotationYaw / 180F * 3.141593F) * MathHelper.cos(rotationPitch / 180F * 3.141593F) * gRate;
    			yVectorG = -MathHelper.sin(rotationPitch / 180F * 3.141593F) * gRate;
    			zVectorG =  MathHelper.cos(rotationYaw / 180F * 3.141593F) * MathHelper.cos(rotationPitch / 180F * 3.141593F) * gRate;
    			entityTHShot[i] = new EntityTHShot(worldObj, userEntity, this, xVector, yVector, zVector,
    				0.2D, 0.3D, 0.05D, xVectorG, yVectorG, zVectorG, 8, 48 + ticksExisted % 7, 0.8F, 35);
    			angle += angleSpan;
    			if(!worldObj.isRemote)
    			{
    				worldObj.spawnEntityInWorld(entityTHShot[i]);
    			}
    		}
		}
	}
	
	//死蝶「華胥の永眠」
	private void spellCard_2()
	{
		if(ticksExisted % 6 == 3)
		{
			//EntityButterflyShot[] entityButterflyShot = new EntityButterflyShot[64];
			EntityTHShot[] entityTHShot = new EntityTHShot[32];
			double X1,X2,Z1,Z2,angleXZ = (double)ticksExisted,angleXZ2, angleY = 0,px, py, pz, vy,vx,vz;
			Vec3 lookAt = userEntity.getLookVec();
			float shootPitch = userEntity.rotationPitch;
			float shootPitchSpan = 360F / 32F;
			lookAt.rotateAroundY((float)Math.PI*2);
			float angle = -30F;
    		float spanAngle = 360F / 32F * 2F;
			int color = 3 + (ticksExisted / 6) % 2;
			//if(color == 1)color = 3;
			color += 32;
			
			//for(int j = 0; j < 8; j++)
			{
	    		for(int i = 0; i < 32; i+=2)
	    		{		
	    			//飛ぶ方向を設定
					angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
	    			angleXZ2 = angleXZ + 60F;
					angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る
	    			
					X1 =  Math.sin(angleXZ2 / 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z1 =  Math.sin(angleXZ2 / 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					X2 =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z2 =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
	    			vy = -Math.cos(angleXZ2/ 180.0F * Math.PI) * Math.sin((shootPitch - angleY)/ 180.0F * Math.PI);//Y方向　上下
					vx =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
					vz =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
					
	    			X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
	    			py = userEntity.posY - Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((shootPitch - angleY)/ 180.0F * Math.PI) * 2.0D;//Y方向　上下
					px = userEntity.posX + Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord * 2.0D + X1 - X2;//X方向　水平方向
					pz = userEntity.posZ + Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord * 2.0D + Z1 + Z2;//Z方向　水平方向
	    			
	    			//entityButterflyShot[i] = new EntityButterflyShot(worldObj, userEntity, userEntity, px, py, pz, vx, vy, vz, 0.1D, 0.2D, 0.01D, 6, color, 0.2F);//蝶弾の配列に方向、色などを代入
	    			entityTHShot[i] = new EntityTHShot(worldObj, userEntity, userEntity, px, py, pz, vx, vy, vz, 0.1D, 0.2D, 0.01D, 0.0D, 0.0D, 0.0D, 5, color, 0.6F, 60);//蝶弾の配列に方向、色などを代入
	    			
	    			angleXZ2 = angleXZ - 60F;
	    			
	    			X1 =  Math.sin(angleXZ2 / 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z1 =  Math.sin(angleXZ2 / 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					X2 =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z2 =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
	    			vy = -Math.cos(angleXZ2/ 180.0F * Math.PI) * Math.sin((shootPitch - angleY)/ 180.0F * Math.PI);//Y方向　上下
					vx =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
					vz =  Math.cos(angleXZ2 / 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
					
	    			X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.sin(userEntity.rotationYaw/ 180.0F * Math.PI);
					Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((shootPitch)/ 180.0F * Math.PI) * Math.cos(userEntity.rotationYaw/ 180.0F * Math.PI);
	    			py = userEntity.posY - Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((shootPitch - angleY)/ 180.0F * Math.PI) * 2.0D;//Y方向　上下
					px = userEntity.posX + Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord * 2.0D + X1 - X2;//X方向　水平方向
					pz = userEntity.posZ + Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord * 2.0D + Z1 + Z2;//Z方向　水平方向
	    			
	    			//entityButterflyShot[i + 1] = new EntityButterflyShot(worldObj, userEntity, userEntity, px, py, pz, vx, vy, vz, 0.1D, 0.2D, 0.01D, 6, color, 0.2F);//蝶弾の配列に方向、色などを代入
	    			entityTHShot[i + 1] = new EntityTHShot(worldObj, userEntity, userEntity, px, py, pz, vx, vy, vz, 0.1D, 0.2D, 0.01D, 0.0D, 0.0D, 0.0D, 5, color, 0.6F, 60);//蝶弾の配列に方向、色などを代入
					
	    			angle += spanAngle;//飛ばす方向を360/弾数分増やす
				}
				if(!worldObj.isRemote)
	    		{
	    			for(int i = 0; i < 32; i++)
	    			{
	    				//worldObj.spawnEntityInWorld(entityButterflyShot[i]);
	    				worldObj.spawnEntityInWorld(entityTHShot[i]);
	    			}
	    		}
				//shootPitch += shootPitchSpan;
			}
		}
	}
	
	//星符「メテオニックシャワー」
	private void spellCard_3()
	{
		if(ticksExisted > 10)
		{
			EntityTHShot entityTHShot;
			double vectorX, vectorY, vectorZ;
			Random rand = new Random();
			int colors[] = {0, 2, 3, 4};
			int color = colors[rand.nextInt(4)] + 48;
			float size = 0.3F + (float)rand.nextInt(50) / 100F;
			int damage = (int)(size * 10F);
			float yaw = userEntity.rotationYaw + (float)rand.nextInt(2000) / 100F - 10F;
			float pitch = userEntity.rotationPitch + (float)rand.nextInt(2000) / 100F - 10F;
			vectorX = -MathHelper.sin(yaw / 180F * 3.141593F) * MathHelper.cos(pitch / 180F * 3.141593F) ;
			vectorY = -MathHelper.sin(pitch / 180F * 3.141593F) ;
			vectorZ =  MathHelper.cos(yaw / 180F * 3.141593F) * MathHelper.cos(pitch / 180F * 3.141593F) ;
			entityTHShot = new EntityTHShot(worldObj, userEntity, vectorX, vectorY, vectorZ, 0.1D, 2.0D, 0.1D, damage, color, size);
			if(!worldObj.isRemote)
			{
				worldObj.spawnEntityInWorld(entityTHShot);
			}
		}
		if(ticksExisted > 40)
		{
			setDead();
		}
	}
	
	//境符「波と粒の境界」
	private void spellCard_4()
	{
		rotationYaw += MathHelper.sin((float)ticksExisted / 20F) * 20F;
		rotationPitch = MathHelper.sin(MathHelper.sin(ticksExisted / 10F) * 3.14F) * 10F;
		float angle = 0F;
		float spanAngle = 360F / 7F;
		EntityTHShot entityTHShot;
		double vectorX, vectorY, vectorZ;
		int color = 44;
		float size = 0.3F;
		float yaw, pitch;
		int damage = 5;
		
		for(int i = 0; i < 7; i++)
		{
			yaw = (rotationYaw + angle) / 180F * 3.141593F;
			pitch = (rotationPitch) / 180F * 3.141593F;
			vectorX = -MathHelper.sin(yaw) * MathHelper.cos(pitch) ;
			vectorY = -MathHelper.sin(pitch) ;
			vectorZ =  MathHelper.cos(yaw) * MathHelper.cos(pitch) ;
			//entityTHShot = new EntityTHShot(worldObj, userEntity, vectorX, vectorY, vectorZ, 0.01D, 0.2D, 0.1D, damage, color, size);
			entityTHShot = new EntityTHShot(worldObj, userEntity, userEntity, vectorX, vectorY, vectorZ, 
				0.1D, 0.3D, 0.1D, 0.0D, 0.0D, 0.0D, damage, color, size, 80);
			if(!worldObj.isRemote)
			{
				worldObj.spawnEntityInWorld(entityTHShot);
			}
			angle += spanAngle;
		}
		userEntity.motionX = 0.0D;
		userEntity.motionY = 0.0D;
		userEntity.motionZ = 0.0D;
		if(ticksExisted > 120)
		{
			setDead();
		}
	}

    /**
     * (abstract) Protected helper method to write subclass entity data to NBT.
     */
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    	nbttagcompound.setShort("count", (short)count);
    }

    /**
     * (abstract) Protected helper method to read subclass entity data from NBT.
     */
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    	count = nbttagcompound.getShort("count");
    }
	
	//
	public void setSpellCardNumber(int number)
	{
		dataWatcher.updateObject(18, Integer.valueOf(number));
	}
	//
	public int getSpellCardNumber()
	{
		return dataWatcher.getWatchableObjectInt(18);
	}

    /*public float getShadowSize()
    {
        return 0.5F;
    }

    protected boolean isValidLightLevel()
    {
        return true;
    }

    public int getBrightnessForRender(float par1)
    {
        return 0xf000f0;
    }*/

    /**
     * Gets how bright this entity is.
     */
    public float getBrightness(float par1)
    {
        return 0.5F;
    }

}
