package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;

import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySukima extends Entity
{
	
	//瞬間移動できるスキマ
	
	private int count;
	
	double warpPosX;
	double warpPosY;
	double warpPosZ;
	EntityLiving userEntity;
	float warpAngle;
	boolean warp;
	private int pattern;//スキマのアニメーション用　未使用
	private int color;//スキマの色　同じ色のスキマ同士しか移動できない

    public EntitySukima(World par1World)
    {
        super(par1World);
        preventEntitySpawning = true;
        setSize(1.5F, 1.0F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.5F;//高さを設定
    	pattern = 0;
    }
	
	public EntitySukima(World par1World,EntityLiving entityLiving, double x, double y, double z)
    {
        this(par1World);
    	 
    	setSize(1.5F, 1.0F);
        yOffset = 0.5F;
    	double x2 = (double)((int)x);
    	double z2 = (double)((int)z);
    	
        setPosition( x2+0.5D, (double)((int)y)+1.0D, z2+0.5D );//初期位置を設定(x,y,z)
    	rotationYaw = entityLiving.rotationYaw;
    	rotationYaw = (float)Math.atan2(x - entityLiving.posX, z - entityLiving.posZ) / 3.141593F * 180F;
    	//rotationYaw = rotationYaw % 180F;
    	if(rotationYaw < 0F)
    	{
    		rotationYaw += 360F;
    	}
    	if(rotationYaw % 90F < 45F)
    	{
    		rotationYaw = rotationYaw - (rotationYaw % 45F);
    	}
    	else
    	{
    		rotationYaw = rotationYaw - (rotationYaw % 45F) + 45F;
    	}
    	//rotationYaw = entityLiving.rotationYaw - (entityLiving.rotationYaw % 90F);
    	setRotation( 360F - rotationYaw,  0.0F);
    	count = 0;
    	pattern = 0;
    	color = 1;
    	setColor(color);
    	setNewWarpPoint();
    	userEntity = entityLiving;

    }
	
	public EntitySukima(World par1World,EntityLiving entityLiving, double x, double y, double z, double wx, double wy, double wz)
    {
        this(par1World);
    	 
    	setSize(1.5F, 1.0F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.5F;//同上
    	
        setPosition( x, y + 1.0D, z );//初期位置を設定(x,y,z)
    	rotationYaw = entityLiving.rotationYaw;
    	rotationYaw = (float)Math.atan2(x - entityLiving.posX, z - entityLiving.posZ) / 3.141593F * 180F;
    	setRotation( 360F - rotationYaw,  0.0F);
    	count = 0;
    	pattern = 0;
    	color = 16;
    	setColor(color);
    	setNewWarpPoint();
    	userEntity = entityLiving;

    }

    /**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    protected boolean canTriggerWalking()
    {
        return false;
    }

	//生成時に一度呼ばれる
    protected void entityInit()
    {
    	dataWatcher.addObject(16, new Integer(0));//スキマの色
    }

	//押すことができるか
    public boolean canBePushed()
    {
        return false;
    }

	//出現時に呼び出されるコンストラクト


	//当たり判定の有無　falseだと右クリックの選択ですらできない。trueならsetSize()で設定したボックスの当たり判定が出現する
    public boolean canBeCollidedWith()
    {
        return true;
    }

	//Entityが存在する限り毎フレーム呼び出されるメソッド
    public void onUpdate()
    {
        super.onUpdate();

        prevPosX = posX;
        prevPosY = posY;
        prevPosZ = posZ;
    	
    	//直接ワープスキマは時間消滅する
    	if(getColor() == 16)
    	{
    		if(ticksExisted > 24)
    		{
    			setDead();
    		}
    	}
    	
    	MovingObjectPosition movingobjectposition = new MovingObjectPosition(this);
    	
    	//***********スキマとEntityの当たり判定を取る****************//
    	Entity entity = null;
    	List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(10.0D, 10.0D,10.0D));//判定を行う箱の大きさ

	
		double minX, minY, minZ, maxX, maxY, maxZ;
		float angleRad = rotationYaw / 180F * 3.141593F;
		minX = posX - 1.0D;
		minY = posY - 1.5D;
		minZ = posZ - 1.0D;
		maxX = posX + 1.0D;
		maxY = posY + 1.0D;
		maxZ = posZ + 1.0D;

        if (list != null && list.size() > 0)
        {
            for (int j1 = 0; j1 < list.size(); j1++)
            {
                entity = (Entity)list.get(j1);
        		if( entity.posX > minX && entity.posX < maxX &&
        			entity.posY > minY && entity.posY < maxY &&
        			entity.posZ > minZ && entity.posZ < maxZ)
        		{
        			//通常のスキマなら新しいワープポイントを探す
        			//if(getColor() != 16)
        			//{
        				setNewWarpPoint();
        			//}
        			if(warp)//ワープが有効だった場合の入ったEntityの処理
        			{
        				entity.prevPosX += warpPosX - entity.posX;
        				//entity.prevPosY += warpPosY - entity.posY;
        				entity.prevPosZ += warpPosZ - entity.posZ;
        				entity.setPosition(warpPosX, warpPosY+entity.yOffset, warpPosZ);
        				entity.prevPosY = 0.0D;
        				entity.rotationYaw += warpAngle;
        				entity.motionX *= -Math.sin(entity.rotationYaw);
        				entity.motionZ *= Math.cos(entity.rotationYaw);
        				entity.fallDistance = 0.0F;
        				worldObj.playSoundAtEntity(entity, mod_thKaguya.sukimaWarpSE, 0.5F, 0.4F);
        			}
        		}
            }
        }
	}

	//プレイヤーが、Entityに対して右クリックしたときに呼び出される
	public boolean interact(EntityPlayer par1EntityPlayer)
    {
    	if(getColor() == 16)
    	{
    		return false;
    	}
    	ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();//プレイヤーの選択しているアイテムを取得
    	if(!par1EntityPlayer.worldObj.isRemote)
    	{
	    	if(itemstack != null && itemstack.itemID == Item.dyePowder.itemID)//プレイヤーが染料を持っていれば
	    	{
	    		worldObj.playSoundAtEntity(par1EntityPlayer, mod_thKaguya.sukimaWarpSE, 0.5F, 0.4F);
	    		//itemstack.stackSize--;
	    		//color = itemstack.getItemDamage();//スキマの色を、染料のダメージ値に対応する色にする
	    		setColor(itemstack.getItemDamage());
	    		color = getColor();
	    	}
	    	else if(itemstack != null && itemstack.itemID == mod_thKaguya.kaigoItem.itemID)//悔悟の棒を持った状態
	    	{
	    		dropItemWithOffset(mod_thKaguya.sukimaItem.itemID, 1, 0.0F);//アイテム：スキマをドロップさせる
	    		setDead();//消滅させる
	    	}
	    	else if(par1EntityPlayer.isSneaking())//染料も持ってなく、スニークなら
	    	{
	    		dropItemWithOffset(mod_thKaguya.sukimaItem.itemID, 1, 0.0F);//アイテム：スキマをドロップさせる
	    		setDead();//消滅させる
	    	}
    	}
        return true;
    }
    
	//保存しておきたい変数を設定
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    	nbttagcompound.setShort("color", (short)getColor());
    }

	//保存した変数の読み込みの設定
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    	setColor(nbttagcompound.getShort("color"));
    	
    }

    public float getShadowSize()
    {
        return 2.0F;
    }
    
	//スキマの色を取得する
	public void setColor(int par1)
	{
		dataWatcher.updateObject(16, Integer.valueOf(par1));
	}
    //スキマの色を取得する
	public int getColor()
	{
		return dataWatcher.getWatchableObjectInt(16);
	}
    
    //新しいワープポイントを取得する
	public void setNewWarpPoint()
	{
		double nearDistance = 1000.0D;//一番スキマの距離として、ありえないデタラメな値を保存
		double distance;
		double dx, dy, dz;
		EntitySukima setSukima = null;
		EntitySukima nearSukima = null;
		MovingObjectPosition movingobjectposition = new MovingObjectPosition(this);
		Entity entity = null;
    	List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(128.0D, 128.0D,128.0D));//周囲256x256x256の立方体内が有効範囲 おそらくチャンクの読み込みの関係でこれが限界サイズ
		
        if (list != null && list.size() > 0)//範囲内のEntityをチェック
        {
            for (int j1 = 0; j1 < list.size(); j1++)
            {
            	entity = (Entity)list.get(j1);
            	if(entity instanceof EntitySukima)//スキマのみチェック
            	{
            		setSukima = (EntitySukima)entity;
            		if( getColor() == setSukima.getColor() )//スキマ同士の色が同じ場合のみ判定
            		{
            			distance = getDistanceToEntity(entity);
            			if(distance < nearDistance && distance > 5.0D)//距離が５m以上で、距離が近いなら一番近いスキマとして保存
            			{
            				nearDistance = distance;
            				nearSukima = setSukima;
            			}
            		}
            	}
            }
        	if(nearSukima != null)//範囲内に有効なスキマがあればワープさせる
        	{
        		float angleNS = nearSukima.rotationYaw / 180F * 3.141593F;
        		warpPosX = nearSukima.posX + (double)Math.sin(angleNS)*1.8D;
        		warpPosY = nearSukima.posY;
        		warpPosZ = nearSukima.posZ - (double)Math.cos(angleNS)*1.8D;
        		warpAngle = 180F - (rotationYaw - nearSukima.rotationYaw);
        		warp = true;
        	}
        	else//範囲内に有効なスキマがなければ何も起きない
        	{
        		warp = false;
        	}
        }
	}
    
	@SideOnly(Side.CLIENT)
	public int patternSukima()
	{
		return pattern/4;
	}
	
}
