package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityTHLaser extends EntityTHShot
{
	//レーザー系のEntityの共通処理
	
	public double laserLength;

	
	
	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityTHLaser(World world)
    {
        super(world);
    }
	
	public EntityTHLaser(World world, EntityLiving entityUser, Entity entity,
		double xPos, double yPos, double zPos,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	double gravity, int damage, int c, float size, int dead, double length)
    {
        super(world, entityUser, entity, xPos, yPos, zPos, xVector, yVector, zVector,
        		firstSpeed, maxSpeed, addSpeed, 0.0D, gravity, 0.0D, damage, c, size, dead);
    	setLaserLength(length);
    }

	
	//Entity生成時に一度だけ呼ばれる
	@Override
	protected void entityInit()
	{
		super.entityInit();
		dataWatcher.addObject(21, new Integer(0));
	}
	
	//衝突処理
	@Override
	public void hitCheck()
	{
		double length2 = getLaserLength() / 2.0D;
	    //始点（現在地）
    	Vec3 vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX - xVec * length2, posY - yVec * length2, posZ - zVec * length2);
    	//終点（現在地に移動量を足した点）
    	Vec3 vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX + motionX + xVec * length2, posY + motionY + yVec * length2, posZ + motionZ + zVec * length2);
        //始点と終点からブロックとの当たりを取得
    	MovingObjectPosition movingObjectPosition = worldObj.rayTraceBlocks(vec3d, vec3d1);
    	vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX - xVec * length2, posY - yVec * length2, posZ - zVec * length2);
    	vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX + motionX + xVec * length2, posY + motionY + yVec * length2, posZ + motionZ + zVec * length2);
    	//何らかのブロックに当たっているなら
        if (movingObjectPosition != null)
        {
        	//終点を当たった点に変更
        	vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(movingObjectPosition.hitVec.xCoord, movingObjectPosition.hitVec.yCoord, movingObjectPosition.hitVec.zCoord);
        }
    	
    	
        Entity entity = null;//実際に当たったことにするEntity
    	double d = 0.0D;//そのEntityまでの仮の距離
    	//ここから移動量分の線分を作り、それに弾の大きさの２倍の肉付けをし直方体を作る。それに当たったEntityをリスト化する
        List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.addCoord(motionX, motionY, motionZ).expand(shotSize*2D, shotSize*2D, shotSize*2D));//指定範囲内のEntityをリストに登録

    	for (int j = 0; j < list.size(); j++)
        {
            Entity entity1 = (Entity)list.get(j);//entity1にリストの先端のentityを保存
        	//entity1が、当たり判定を取らない　または　entity1が使用者　または　飛んで25カウント以下？　または　EntityTHShotならパス
            if ( !entity1.canBeCollidedWith() || entity1.isEntityEqual(userEntity) || entity1.isEntityEqual(shootingEntity) || entity1 instanceof EntityTHShot)
            {
                continue;
            }
        	//float f2 = 0.3F;
        	//判定を弾の大きさに変更
            AxisAlignedBB axisalignedbb = entity1.boundingBox.expand(shotSize, shotSize, shotSize);
            MovingObjectPosition movingObjectPosition1 = axisalignedbb.calculateIntercept(vec3d, vec3d1);
        	//この判定で何も当たっていないならパス
            if (movingObjectPosition1 == null)
            {
                continue;
            }
        	//当たっているならここからその点までの距離を取得
            double d1 = vec3d.distanceTo(movingObjectPosition1.hitVec);
        	//今までの一番近くにいるなら、一番近いEntityを更新する
            if (d1 < d || d == 0.0D)
            {
                entity = entity1;
                d = d1;
            }
        }

    	//当たったEntityがいるなら、当たったEntityをMovingObjectPositionで登録
        if (entity != null)
        {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
    	//MovingObjectPositionで当たっているなら
        if (movingObjectPosition != null)
        {
        	//当たった場合の処理をする
            onImpact(movingObjectPosition);
        }
	}

	//ブロックやEntityに当たった時の処理
	@Override
    protected void onImpact(MovingObjectPosition movingobjectposition)
    {
    	//当たった時の処理
    	if (!worldObj.isRemote)
    	{
    		Entity hitEntity = movingobjectposition.entityHit;
        
    		//当たったEntityがいるなら
    		if ( hitEntity != null )
        	{
        		//それがEntityTHShotに属していないなら
        		if(hitEntity instanceof EntityTHShot == false)
        		{
        			//指定したダメージ分の魔法ダメージを与える
					if (!hitEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity), shotDamage));
        		}
        		//EntityTHShotに属しているなら
        		else
        		{
        			EntityTHShot entityTHShot = (EntityTHShot)hitEntity;
        			//弾の強さを比べる
        			//同じなら
        			if(getShotStrength() == entityTHShot.getShotStrength())
        			{
        				//setDead();
        				//entityTHShot.setDead();
        			}
        			//相手の方が強いなら
        			else if(getShotStrength() < entityTHShot.getShotStrength())
        			{
        				//この弾を消滅させる
        				this.setDead();
        			}
        			//自分の方が強いなら
        			else
        			{
        				//相手の弾を消滅させる
        				entityTHShot.setDead();
        			}
        		}
			}
    		else
    		{
        		this.setDead();//ブロックに当たったら消滅
    		}
    	}
    }
    	

    //Entityからの攻撃を受けたときの処理　要は跳ね返す処理
	@Override
    public boolean attackEntityFrom(DamageSource damagesource, int i)
    {
		return false;
    }
	
	
	//レーザーの長さを設定
	public void setLaserLength(double length)
	{
		dataWatcher.updateObject(21, Integer.valueOf((int)(length * 10000.0D)));
	}
	//レーザーの長さを返す
	public double getLaserLength()
	{
		return (double)dataWatcher.getWatchableObjectInt(21) / 10000.0D;
	}
}
