package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityTHShot extends Entity
{
	//ショット系のEntityの共通処理

	
	//種類特性変数
	protected String texture;
	protected float shotSize;//弾のサイズ
	
	//個別特性変数
	public EntityLiving userEntity;//発射した大元
	public Entity shootingEntity;//発射したEntity
	public double shotSpeed;//弾のスピード
	public double shotMaxSpeed;//弾の最高速度
	public double shotAddSpeed;//弾の加速力
	public boolean hasAccelerations;//加速するか
	public double shotGravityX;//受ける重力値　0.0Dでデフォルト
	public double shotGravityY;
	public double shotGravityZ;
	boolean isGravity;//重力の影響を受けるかどうか
	protected int shotDamage;//弾によるダメージ
	public int color;//弾の色
	public int deadTime;//消滅時間
	public double xVec;//X軸方向の移動ベクトル
	public double yVec;//Y軸方向の移動ベクトル
	public double zVec;//Z軸方向の移動ベクトル
	public int shotType;//弾独自の動作を表す 0は何もしない
	
	protected int xTile;
    protected int yTile;
    protected int zTile;
    protected int inTile;
    protected boolean inGround;//地面に触れているかのチェック
    protected int ticksAlive;//
    protected int ticksInAir;//空中にいる時間
    public double accelerationX;//X軸方向の加速度
    public double accelerationY;//Y軸方向の加速度
    public double accelerationZ;//Z軸方向の加速度
	
	public static double GRAVITY_DEFAULT = -0.03D;//標準の重力値

	
	
	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityTHShot(World world)
    {
        super(world);
        xTile = -1;
        yTile = -1;
        zTile = -1;
        inTile = 0;
        inGround = false;
        ticksInAir = 0;
        setSize(1.0F, 1.0F);
    	deadTime = this.deadTime;
    	//color = this.color;
    	
    }

	/*
	*わからんので、翻訳機使用　描画判定のチェックか？
	*エンティティかどうかをチェックするには、遠くに過去を使用し、その平均エッジと比較することで、レンダリングする範囲内にある
	*長さ* 64 * renderDistanceWeightの引数：距離
	*/
	@SideOnly(Side.CLIENT)
    public boolean isInRangeToRenderDist(double d)
    {
        double d1 = boundingBox.getAverageEdgeLength() * 4D;
        d1 *= 64D;
        return d < d1 * d1;
    }
	
	public EntityTHShot(World world, EntityLiving entityUser, Entity entity,
		double xPos, double yPos, double zPos,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	double xVectorG, double yVectorG, double zVectorG, int damage, int c, float size, int dead, int type)
    {
        super(world);
    	userEntity = entityUser;
    	shootingEntity = entity;
    	shotSpeed = firstSpeed;
    	/*if(xVectorG == 0.0D && yVectorG == 0.0D && zVectorG == 0.0D)
    	{
    		isGravity = false;
    		shotGravityX = xVector;
    		shotGravityY = yVector;
    		shotGravityZ = zVector;
    	}
    	else
    	{
    		isGravity = true;
    		shotGravityX = xVectorG;
    		shotGravityY = yVectorG;
    		shotGravityZ = zVectorG;
    	}*/
    	isGravity = false;
    	shotGravityX = xVectorG;
    	shotGravityY = yVectorG;
    	shotGravityZ = zVectorG;
    	shotDamage = damage;
    	color = c;
		deadTime = dead;
    	shotType = type;
    	xTile = -1;
        yTile = -1;
        zTile = -1;
        inTile = 0;
        inGround = false;
        ticksInAir = 0;
    	setShotSize(size);
        setSize(0.5F, 0.5F);
    	xVec = xVector;
    	yVec = yVector;
    	zVec = zVector;
    	motionX = xVec * firstSpeed;
    	motionY = yVec * firstSpeed;
    	motionZ = zVec * firstSpeed;
    	rotationYaw = (float)Math.atan2(motionX, motionZ) / 3.141593F * 180F;
    	rotationPitch = (float)Math.atan2( motionY, Math.sqrt(motionX * motionX + motionZ * motionZ)) / 3.141593F * 180F;
    	rotationPitch %= 90F;
        setLocationAndAngles(xPos, yPos, zPos, rotationYaw, rotationPitch);
    	if(entity instanceof EntityLiving)
    	{
    		setPosition(xPos+xVec*0.2D, yPos+yVec * 0.2D+(double)entityUser.getEyeHeight() - 0.10000000149011612D - 0.15D, zPos+zVec*0.2D);
    	}
    	else
    	{
    		setPosition(xPos+xVec*0.2D, yPos+yVec * 0.2D, zPos+zVec*0.2D);
    	}
        yOffset = 0.0F;//発射地点の高さ
    	if(hasAccelerations = firstSpeed != maxSpeed)
    	{
        	accelerationX = xVec * maxSpeed * addSpeed;
        	accelerationY = yVec * maxSpeed * addSpeed;
        	accelerationZ = zVec * maxSpeed * addSpeed;
    	}
    	else
    	{
    		accelerationX = 0.0D;
        	accelerationY = 0.0D;
        	accelerationZ = 0.0D;
    	}
    	shotMaxSpeed = maxSpeed;
    	shotAddSpeed = addSpeed;
    	setShotColor(color);
    	setDeadTime(deadTime);
    	//setVector();
    }
	
	//通常弾の基本設定
	public EntityTHShot(World world, EntityLiving entityUser, Entity entity,
		double xPos, double yPos, double zPos,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	double xVectorG, double yVectorG, double zVectorG, int damage, int c, float size, int dead)
    {
    	this(world, entityUser, entity, xPos, yPos, zPos, xVector, yVector, zVector, 
    		firstSpeed, maxSpeed, addSpeed, xVectorG, yVectorG, zVectorG, damage, c, size, dead, 0);
    }
	
	/*public EntityTHShot(World world, EntityLiving entityLiving, Entity entity,
		double xPos, double yPos, double zPos,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	int damage, int color, float size, int dead)
    {
    	this(world, entityLiving,entity, xPos, yPos, zPos,
    		xVector, yVector, zVector, firstSpeed, maxSpeed, addSpeed, 0.0D, 0.0D, 0.0D, damage, color, size, dead);
    }*/
	
	public EntityTHShot(World world, EntityLiving entityLiving,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	int damage, int color, float size, int dead)
    {
    	this(world, entityLiving, entityLiving, entityLiving.posX, entityLiving.posY, entityLiving.posZ,
    		xVector, yVector, zVector, firstSpeed, maxSpeed, addSpeed, damage, color, size, dead);
    }

	//発射地点が発射元と同じ場合の基本設定
    public EntityTHShot(World world, EntityLiving entityUser, Entity entity,
    	double xVector, double yVector, double zVector,
    	double firstSpeed, double maxSpeed, double addSpeed,
    	double xVectorG, double yVectorG, double zVectorG, int damage, int c, float size, int dead)
    {
    	this(world, entityUser, entity, entity.posX, entity.posY, entity.posZ, xVector, yVector, zVector,
    		firstSpeed, maxSpeed, addSpeed, xVectorG, yVectorG, zVectorG, damage, c, size, dead, 0);
    }
	
	//最も一般的なショット　加速なし、機動変化なし
	public EntityTHShot(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector,double speed, int damage, int c ,float size)
    {
    	this(world, entityLiving, entityLiving, xVector, yVector, zVector,
    		speed, speed, 1.0D, 0.0D, 0.0D, 0.0D, damage, c, size, 120);
    }
	
	//最も一般的なショットに初速度と最高速と加速度があるもの
	public EntityTHShot(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector,
		double firstSpeed, double maxSpeed, double addSpeed, int damage, int c, float size)
    {
    	this(world, entityLiving, entityLiving, xVector, yVector, zVector,
    		firstSpeed, maxSpeed, addSpeed, 0.0D, 0.0D, 0.0D, damage, c, size, 120);
    }
	
	//Entity生成時に一度だけ呼ばれる
	protected void entityInit()
	{
		dataWatcher.addObject(18, new Integer(0));
		dataWatcher.addObject(19, new Integer(0));
		dataWatcher.addObject(20, new Integer(0));
	}
	
	//弾の速度を返す
	public double getSpeed()
	{
		return (double)MathHelper.sqrt_double( motionX * motionX + motionY * motionY + motionZ * motionZ);
	}

	//向きを更新する
	public void setVector()
	{
		//if (prevRotationPitch == 0.0F && prevRotationYaw == 0.0F)
        {
            //float xzVec = MathHelper.sqrt_double(motionX * motionX + motionZ * motionZ);
            //prevRotationYaw = rotationYaw = (float)(Math.atan2(motionX, motionZ) * 180.0D / Math.PI);
            //prevRotationPitch = rotationPitch = (float)(Math.atan2(motionY, (double)xzVec) * 180.0D / Math.PI);
        	//setRotation(rotationYaw, rotationPitch);
        	xVec =  (double)MathHelper.sin( rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos( rotationPitch / 180F * 3.141593F);//X方向　水平方向
        	yVec =  (double)MathHelper.sin( rotationPitch / 180F * 3.141593F);//Y方向　上下
        	zVec =  (double)MathHelper.cos( rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos( rotationPitch / 180F * 3.141593F);//Z方向　水平方向
        	if(hasAccelerations)
        	{
        		accelerationX = xVec * shotMaxSpeed * shotAddSpeed;
        		accelerationY = yVec * shotMaxSpeed * shotAddSpeed;
        		accelerationZ = zVec * shotMaxSpeed * shotAddSpeed;
        	}
        	/*if(hasGravityLevel())
    		{
        		accelerationY = yVec * shotMaxSpeed * shotAddSpeed;
    		}
        	else
        	{
        		accelerationY = 0.0D;
        	}*/
        }
	}
	
	//ショットが存在する限り呼び出されるメソッド
	@Override
    public void onUpdate()
    {	
    	//弾の主がいないか、死んでいる場合消える
    	if (!worldObj.isRemote && (userEntity == null || userEntity.isDead))
        {
            setDead();
        	return;
        }
    	else
    	{
    		super.onUpdate();
    	}
    	
    	//消滅時間を過ぎたら消滅
    	if(ticksExisted >= getDeadTime())
    	{
    		setDead();
    	}
    	
    	extinguish();//火はつかないようにする

    	//衝突処理
    	hitCheck();
    	
    	//弾に重力を加える
    	//if(isGravity)
    	{
    		setGravityLevel();
    	}
    	/*if(motionX == 0.0D && motionY == 0.0D && motionZ == 0.0D)//弾が静止してるなら進行方向に進める
    	{
    		setGravityLevel();
    	}*/
    	/*if(hasGravityLevel() && accelerationY > 0.0D)
    	{
    		accelerationY -= shotGravity;
    	}*/
    	//弾ごとの特殊な動作を発生させる
    	specialMotion();
    	setVector();
    	//最終的な移動量を現在地に加える
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
    	
    	//向いている方向を整理
        float f = MathHelper.sqrt_double(motionX * motionX + motionZ * motionZ);
        rotationYaw = (float)((Math.atan2(motionX, motionZ) * 180D) / 3.1415927410125732D);
        for (rotationPitch = (float)((Math.atan2(motionY, f) * 180D) / 3.1415927410125732D); rotationPitch - prevRotationPitch < -180F; prevRotationPitch -= 360F) { }
        for (; rotationPitch - prevRotationPitch >= 180F; prevRotationPitch += 360F) { }
        for (; rotationYaw - prevRotationYaw < -180F; prevRotationYaw -= 360F) { }
        for (; rotationYaw - prevRotationYaw >= 180F; prevRotationYaw += 360F) { }
        rotationPitch = prevRotationPitch + (rotationPitch - prevRotationPitch) * 0.2F;
        rotationYaw = prevRotationYaw + (rotationYaw - prevRotationYaw) * 0.2F;
    	
    	//加速処理と限界速度処理
    	if(getSpeed() < shotMaxSpeed)
    	{
    		this.motionX += this.accelerationX;
        	this.motionY += this.accelerationY;
        	this.motionZ += this.accelerationZ;
    	}

        setPosition(this.posX, this.posY, this.posZ);
    }
	
	//衝突処理
	public void hitCheck()
	{
	    //始点（現在地）
    	Vec3 vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX, posY, posZ);
    	//終点（現在地に移動量を足した点）
    	Vec3 vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX + motionX, posY + motionY, posZ + motionZ);
        //始点と終点からブロックとの当たりを取得
    	MovingObjectPosition movingObjectPosition = worldObj.rayTraceBlocks(vec3d, vec3d1);
    	vec3d = worldObj.getWorldVec3Pool().getVecFromPool(posX, posY, posZ);
    	vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(posX + motionX, posY + motionY, posZ + motionZ);
    	//何らかのブロックに当たっているなら
        if (movingObjectPosition != null)
        {
        	//終点を当たった点に変更
        	vec3d1 = worldObj.getWorldVec3Pool().getVecFromPool(movingObjectPosition.hitVec.xCoord, movingObjectPosition.hitVec.yCoord, movingObjectPosition.hitVec.zCoord);
        }
    	
    	
        Entity entity = null;//実際に当たったことにするEntity
    	double d = 0.0D;//そのEntityまでの仮の距離
		float hitSize = getShotSize() * 0.3F;
    	//ここから移動量分の線分を作り、それに弾の大きさの２倍の肉付けをし直方体を作る。それに当たったEntityをリスト化する\\
        List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.addCoord(motionX, motionY, motionZ).expand(hitSize, hitSize, hitSize));//指定範囲内のEntityをリストに登録
		
    	for (int j = 0; j < list.size(); j++)
        {
            Entity entity1 = (Entity)list.get(j);//entity1にリストの先端のentityを保存
        	//entity1が、当たり判定を取らない　または　entity1が使用者　または　飛んで25カウント以下？　または　EntityTHShotならパス
            if ( entity1.canBeCollidedWith() && !entity1.isEntityEqual(userEntity) && !entity1.isEntityEqual(shootingEntity) && !hitCheckEx(entity1) )
        	{
        		//判定を弾の大きさに変更
            	AxisAlignedBB axisalignedbb = entity1.boundingBox.expand(hitSize, hitSize, hitSize);
            	MovingObjectPosition movingObjectPosition1 = axisalignedbb.calculateIntercept(vec3d, vec3d1);
        		//この判定で当たっているなら
            	if (movingObjectPosition1 != null)
            	{
        			//当たっているならここからその点までの距離を取得
            		double d1 = vec3d.distanceTo(movingObjectPosition1.hitVec);
        			//今までの一番近くにいるなら、一番近いEntityを更新する
            		if (d1 < d || d == 0.0D)
            		{
                		entity = entity1;
                		d = d1;
            		}
        		}
        	}
        }

    	//当たったEntityがいるなら、当たったEntityをMovingObjectPositionで登録
        if (entity != null)
        {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
		
		if (movingObjectPosition != null && movingObjectPosition.entityHit != null && movingObjectPosition.entityHit instanceof EntityPlayer)
        {
        	EntityPlayer entityPlayer = (EntityPlayer)movingObjectPosition.entityHit;

            if (entityPlayer.capabilities.disableDamage || shootingEntity instanceof EntityPlayer && !((EntityPlayer)shootingEntity).func_96122_a(entityPlayer))
            {
            	movingObjectPosition = null;
            }
        }
		
    	//MovingObjectPositionで当たっているなら
        if (movingObjectPosition != null)
        {
        	//当たった場合の処理をする
            onImpact(movingObjectPosition);
        }
	}
	
	//独自の動きを追加するためのもの
	public void specialMotion()
	{
	}

	//ブロックやEntityに当たった時の処理
    protected void onImpact(MovingObjectPosition movingObjectPosition)
    {
    	//当たった時の処理
    	if (!worldObj.isRemote)
    	{
    		Entity hitEntity = movingObjectPosition.entityHit;
        
    		//当たったEntityがいるなら
    		if ( hitEntity != null )
        	{
        		//それがEntityTHShotに属していないなら
        		if(hitEntity instanceof EntityTHShot == false)
        		{
        			//指定したダメージ分の魔法ダメージを与える
					if (!hitEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity), shotDamage));
        			//弾を消滅させる
        			setDead();
        		}
        		//EntityTHShotに属しているなら
        		else
        		{
        			EntityTHShot entityTHShot = (EntityTHShot)hitEntity;
        			//弾の強さを比べる
        			//同じなら
        			/*if(getShotStrength() == entityTHShot.getShotStrength())
        			{
        				//setDead();
        				//entityTHShot.setDead();
        			}
        			//相手の方が強いなら
        			else if(getShotStrength() < entityTHShot.getShotStrength())
        			{
        				//この弾を消滅させる
        				this.setDead();
        			}
        			//自分の方が強いなら
        			else
        			{
        				//相手の弾を消滅させる
        				entityTHShot.setDead();
        			}*/
        			if(userEntity != entityTHShot.userEntity)//使用者の違う弾同士は打ち消し合う
        			{
        				setDead();
        				entityTHShot.setDead();
        			}
        		}
			}
    		else
    		{
    			blockHitSpecialProcess();
        		this.setDead();//ブロックに当たったら消滅
    		}
    	}
    }
	
	//ブロックとの衝突時の特別な処理 shotTypeで処理は決めている
	private void blockHitSpecialProcess()
	{
		switch(this.shotType)
		{
			case 1:
				flowerWorld();
				break;
			default:
				break;
			
		}
	}
	
	//着弾地点に花を咲かす
	private void flowerWorld()
	{
		Random random = new Random();
    	int hitPointX = (int)posX;
    	int hitPointY = (int)(posY - 0.3D);
    	int hitPointZ = (int)posZ;
    	int hitPointBlock = worldObj.getBlockId(hitPointX, hitPointY, hitPointZ);
    	if(hitPointBlock == Block.grass.blockID)
    	{
    		int setX = hitPointX;
    		int setY = hitPointY + 1;
    		int setZ = hitPointZ;
    		if(worldObj.isAirBlock(setX, setY, setZ))
    		{
    			if(getShotColor() % 8 == 3)//黄色の弾幕なら
    			{
    				if(!worldObj.isRemote)
    				{
    					//黄色い花を咲かす
    					worldObj.setBlock(setX, setY, setZ, BlockFlower.plantYellow.blockID, 1, 3);
    				}
    			}
    			else if(getShotColor() % 8 == 0)//赤色の弾幕なら
    			{
    				if(!worldObj.isRemote)
    				{
    					//赤い花を咲かす
    					worldObj.setBlock(setX, setY, setZ, BlockFlower.plantRed.blockID, 1, 3);
    				}
    			}
    		}
    	}
	}

    //データを保存する
	@Override
    public void writeEntityToNBT(NBTTagCompound nbtTagCompound)
    {
        nbtTagCompound.setShort("xTile", (short)this.xTile);
        nbtTagCompound.setShort("yTile", (short)this.yTile);
        nbtTagCompound.setShort("zTile", (short)this.zTile);
        nbtTagCompound.setByte("inTile", (byte)this.inTile);
        nbtTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbtTagCompound.setTag("direction", this.newDoubleNBTList(new double[] {this.motionX, this.motionY, this.motionZ}));
    }

    //データを読み込む
	@Override
    public void readEntityFromNBT(NBTTagCompound nbtTagCompound)
    {
        this.xTile = nbtTagCompound.getShort("xTile");
        this.yTile = nbtTagCompound.getShort("yTile");
        this.zTile = nbtTagCompound.getShort("zTile");
        this.inTile = nbtTagCompound.getByte("inTile") & 255;
        this.inGround = nbtTagCompound.getByte("inGround") == 1;

        if (nbtTagCompound.hasKey("direction"))
        {
            NBTTagList var2 = nbtTagCompound.getTagList("direction");
            this.motionX = ((NBTTagDouble)var2.tagAt(0)).data;
            this.motionY = ((NBTTagDouble)var2.tagAt(1)).data;
            this.motionZ = ((NBTTagDouble)var2.tagAt(2)).data;
        }
        else
        {
            this.setDead();
        }
    }
	
	//当たり判定の追加
	public boolean hitCheckEx(Entity entity)
	{
		return false;
	}
    	
    //弾の強さ
    public int getShotStrength()
    {
    	return 10;
    }
	
	//重力値を設定　0.0Dで通常の重力になる
	public void setGravityLevel()
	{
		motionX += shotGravityX;
		motionY += shotGravityY;
		motionZ += shotGravityZ;
		//motionY -= g;
	}
	
	//重力の影響を受けるかどうか返す
	public boolean hasGravityLevel()
	{
		if(shotGravityX == 0.0D && shotGravityY == 0.0D && shotGravityZ == 0.0D)
		{
			return false;
		}
		else
		{
			return true;
		}
	}

    public boolean canBeCollidedWith()
    {
        return true;
    }

    public float getCollisionBorderSize()
    {
        return 1.0F;
    }
    	
    //跳ね返せる弾かどうか
    protected boolean isReturnableShot()
    {
    	return false;
    }

    //Entityからの攻撃を受けたときの処理　要は跳ね返す処理
    public boolean attackEntityFrom(DamageSource damageSource, int i)
    {
        setBeenAttacked();
        if (isReturnableShot() && damageSource.getEntity() != null)
        {
            Vec3 vec3d = damageSource.getEntity().getLookVec();
            if (vec3d != null)
            {
                motionX = vec3d.xCoord;
                motionY = vec3d.yCoord;
                motionZ = vec3d.zCoord;
            	xVec = vec3d.xCoord;
            	yVec = vec3d.yCoord;
            	zVec = vec3d.zCoord;
                accelerationX = motionX * 0.10000000000000001D;
                accelerationY = motionY * 0.10000000000000001D;
                accelerationZ = motionZ * 0.10000000000000001D;
            }
            if (damageSource.getEntity() instanceof EntityLiving)
            {
                shootingEntity = (EntityLiving)damageSource.getEntity();
            }
            return true;
        }
        else
        {
            return false;
        }
    }
	
	//消滅時間を設定
	public void setDeadTime(int time)
	{
		dataWatcher.updateObject(18, Integer.valueOf(time));
	}
	//消滅時間を返す
	public int getDeadTime()
	{
		return dataWatcher.getWatchableObjectInt(18);
	}
	
	//ショットの色を設定
	public void setShotColor(int par1)
	{
		dataWatcher.updateObject(19, Integer.valueOf(par1));
	}
	//ショットの色を返す
	public int getShotColor()
	{
		return dataWatcher.getWatchableObjectInt(19);
	}
	
	//ショットの大きさを設定（レーザーの場合は太さ）
	public void setShotSize(float size)
	{
		dataWatcher.updateObject(20, Integer.valueOf((int)(size * 100F)));
	}
	
	//ショットの大きさを返す（レーザーの場合は太さ）
	public float getShotSize()
	{
		return (float)dataWatcher.getWatchableObjectInt(20) / 100F;
	}

	@SideOnly(Side.CLIENT)
    public float getShadowSize()
    {
        return 0.0F;
    }

    public float getBrightness(float f)
    {
        return 1.0F;
    }

	@SideOnly(Side.CLIENT)
    public int getBrightnessForRender(float f)
    {
        return 0xf000f0;
    }
	
}
