package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityUmiware extends EntityTHShot
{
	//海の割れる日
	

	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityUmiware(World par1World)
    {
        super(par1World);
        xTile = -1;
        yTile = -1;
        zTile = -1;
        inTile = 0;
        inGround = false;
        ticksInAir = 0;
        setSize(1.0F, 1.0F);
    	
    }

    public EntityUmiware(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector,
    		double speed)
    {
        super(world, entityLiving, xVector, yVector, zVector, speed, 60, 0, 0.3F);
    }

	//存在する限り呼び出されるメソッド
    public void onUpdate()
    {
        super.onUpdate();
    	
    	
    	int pi;
    	int px  = (int)posX;
    	int pyd = (int)posY;
    	int pyu = pyd;
    	int pz  = (int)posZ;
    	double pxr = posX;
    	double pxl = posX;
    	double pzr = posZ;
    	double pzl = posZ;
    	double movingLengthX;
    	double movingLengthZ;
    	Material mate = null;
    	movingLengthX = -Math.sin( (rotationYaw+90F) / 180F * 3.141593F)*0.5D;
    	movingLengthZ =  Math.cos( (rotationYaw+90F) / 180F * 3.141593F)*0.5D;
    	while(( worldObj.getBlockMaterial(px, pyd, pz) == Material.water || worldObj.isAirBlock(px, pyd, pz) ) && pyd > 0)
    	{
    		//worldObj.setBlockAndMetadataWithNotify(px, pyd, pz, 0, 0, 0);//空気を設置
    		worldObj.setBlock(px, pyd, pz, 0, 0, 0);//空気を設置

    		pxr = posX;
    		pxl = posX;
    		pzr = posZ;
    		pzl = posZ;
    		pi = 0;
    		do
    		{
    			pxr += movingLengthX;
    			pzr -= movingLengthZ;
    			if( (mate = worldObj.getBlockMaterial((int)pxr, pyd, (int)pzr)) == Material.water)
    			{
    				//worldObj.setBlockAndMetadataWithNotify((int)pxr, pyd, (int)pzr, 0, 0, 0);
    				worldObj.setBlock((int)pxr, pyd, (int)pzr, 0, 0, 0);
    			}
    			pi++;
    		}while(pi <= 12 && (mate == Material.water  || worldObj.isAirBlock((int)pxr, pyd, (int)pzr)));
    		pi = 0;
    		do
    		{
    			pxl -= movingLengthX;
    			pzl += movingLengthZ;
    			if( (mate = worldObj.getBlockMaterial((int)pxl, pyd, (int)pzl)) == Material.water)
    			{
    				//worldObj.setBlockAndMetadataWithNotify((int)pxl, pyd, (int)pzl, 0, 0, 0);
    				worldObj.setBlock((int)pxl, pyd, (int)pzl, 0, 0, 0);
    			}
    			pi++;
    		}while(pi <= 12 && (mate == Material.water ||  worldObj.isAirBlock((int)pxl, pyd, (int)pzl)));
    		pyd--;
    	}
    	while(( worldObj.getBlockMaterial(px, pyu, pz) == Material.water || worldObj.isAirBlock(px, pyu, pz) ) && pyu < 256)
    	{
    		//worldObj.setBlockAndMetadataWithNotify(px, pyu, pz, 0, 0, 0);//空気を設置
    		worldObj.setBlock(px, pyu, pz, 0, 0, 0);//空気を設置
    		
    		pxr = posX;
    		pxl = posX;
    		pzr = posZ;
    		pzl = posZ;
    		pi = 0;
    		do
    		{
    			pxr += movingLengthX;
    			pzr -= movingLengthZ;
    			if( (mate = worldObj.getBlockMaterial((int)pxr, pyu, (int)pzr)) == Material.water)
    			{
    				//worldObj.setBlockAndMetadataWithNotify((int)pxr, pyu, (int)pzr, 0, 0, 0);
    				worldObj.setBlock((int)pxr, pyu, (int)pzr, 0, 0, 0);
    			}
    			pi++;
    		}while(pi <= 12 && (mate == Material.water  || worldObj.isAirBlock((int)pxr, pyu, (int)pzr)));
    		pi = 0;
    		do
    		{
    			pxl -= movingLengthX;
    			pzl += movingLengthZ;
    			if( (mate = worldObj.getBlockMaterial((int)pxl, pyu, (int)pzl)) == Material.water)
    			{
    				//worldObj.setBlockAndMetadataWithNotify((int)pxl, pyu, (int)pzl, 0, 0, 0);
    				worldObj.setBlock((int)pxl, pyu, (int)pzl, 0, 0, 0);
    			}
    			pi++;
    		}while(pi <= 12 && (mate == Material.water ||  worldObj.isAirBlock((int)pxl, pyu, (int)pzl)));
    		pyu++;
    	}

    }
	
	//玉の色を返す
	public int getPattern()
	{
		int pattern;
		pattern = ticksExisted % 2;
		return pattern;
	}
}
