package net.minecraft.thKaguyaMod;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityYouryokuSpoiler extends EntityTHShot
{
	//妖力スポイラー
	//敵に大ダメージを与え、その分の体力を吸収する
	
	private EntityLiving lastHitEntity;
	private boolean endFlag;
	private int befHP;
	

	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityYouryokuSpoiler(World par1World)
    {
        super(par1World);
    	
    }

    public EntityYouryokuSpoiler(World world, EntityLiving entityLiving, double xVector, double yVector, double zVector, double firstSpeed, double maxSpeed, double addSpeed, int damage)
    {
        super(world, entityLiving, xVector, yVector, zVector, firstSpeed, maxSpeed, addSpeed, damage, 0, 0.3F);
    	lastHitEntity = null;
    	endFlag = false;
    }

	//存在する限り呼び出されるメソッド
    @Override
	public void onUpdate()
    {
        super.onUpdate();

    	if(endFlag)
    	{
    		if(lastHitEntity != null && userEntity != null && !userEntity.isDead)
    		{
	    		int health;
	    		lastHitEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, userEntity),20);
	    		health = lastHitEntity.getHealth();
	    		if(health < 0)
	    		{
	    			health = 0;
	    		}
	    		userEntity.setEntityHealth(userEntity.getHealth() + (befHP - health) );//減らした分回復　ガードが硬いと回復しないかも
    		}
    		if(!worldObj.isRemote)
    		{
    			setDead();
    		}
    	}
    	
    }

	//ブロックやEntityに当たった時の処理
	@Override
    protected void onImpact(MovingObjectPosition movingobjectposition)
    {
    	//当たった時の処理
        if ( !worldObj.isRemote && movingobjectposition.entityHit instanceof EntityLiving )
        {
        	lastHitEntity = (EntityLiving)movingobjectposition.entityHit;
        	befHP = 0;//lastHitEntity.health;
			endFlag = true;
        }
    }
	
	public int getPattern()
	{
		return ticksExisted % 2;
	}
}
