package net.minecraft.thKaguyaMod;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityYuukaParasol extends Entity
{
	//幽香の日傘

	public EntityPlayer usePlayer;
	public int damage;

	//ワールド読み込み時に呼び出されるコンストラクト
    public EntityYuukaParasol(World par1World)
    {
        super(par1World);
        /*preventEntitySpawning = true;
        setSize(2.0F, 0.0F);//サイズを設定　平面上の横と奥行きサイズ、高さ
        yOffset = 0.0F;//高さを設定*/
    }

	//出現時に呼び出されるコンストラクト
    public EntityYuukaParasol(World par1World,EntityPlayer entityPlayer, int damage)
    {
        this(par1World);
    	setSize(2.0F, 0.0F);//ワールド読み込み時のコンストラクトと同じ
        yOffset = 0.0F;//同上
    	usePlayer = entityPlayer;
    	prevPosX = entityPlayer.posX;
        prevPosY = entityPlayer.posY;
        prevPosZ = entityPlayer.posZ;
        setPosition(entityPlayer.posX, entityPlayer.posY+1.4D, entityPlayer.posZ);//初期位置を設定(x,y,z)
    	setRotation(entityPlayer.rotationYaw,  0.0F);
    }
	
	//生成時に呼ばれる
    protected void entityInit()
    {
    	dataWatcher.addObject(19, new Integer(0));
    }

	/**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
	@Override
    protected boolean canTriggerWalking()
    {
        return false;
    }

	//当たり判定の有無　falseだと右クリックの選択ですらできない。trueならsetSize()で設定したボックスの当たり判定が出現する
	@Override
    public boolean canBeCollidedWith()
    {
        return true;
    }
	
	//幽香の日傘の効果が切れた時の処理
	private void finish()
	{
		if(usePlayer != null)
		{

			//if(entityPlayer != null)//使用者がいるならインベントリに戻す
			//{
			if(usePlayer.inventory.addItemStackToInventory(new ItemStack(mod_thKaguya.yuukaParasolItem, 1, damage)) == false)
			{
				//インベントリが一杯なら使用者の目の前でアイテム化
				//（クリエイティブでは常にインベントリには物が吸収される仕様があるらしく、クリエイティブでは落とさない（false判定がでない)）
				if(!worldObj.isRemote)
				{
					//usePlayer.dropItemWithOffset(mod_thKaguya.yuukaParasolItem.shiftedIndex, 1, damage, 0.0F);
					entityDropItem(new ItemStack(mod_thKaguya.yuukaParasolItem.itemID, 1, damage), 0.0F);
				}
			}
			//}
		}
		else//使用者がいない場合（再起動した際など）にはその場にアイテム化
		{
			if(!worldObj.isRemote)
			{
				entityDropItem(new ItemStack(mod_thKaguya.yuukaParasolItem.itemID, 1, damage), 0.0F);
				//dropItemWithOffset(mod_thKaguya.yuukaParasolItem.shiftedIndex, 1, 0.0F);
			}
    	}
		setDead();
	}

	//Entityが存在する限り毎フレーム呼び出されるメソッド
	@Override
    public void onUpdate()
    {
    	if(!worldObj.isRemote && usePlayer == null)
    	{
    		setDead();
    	}
    	super.onUpdate();

    	
    	if(usePlayer != null)
    	{
        	prevPosX = posX;
        	prevPosY = posY;
        	prevPosZ = posZ;

    		posX = usePlayer.posX - Math.sin((usePlayer.rotationYaw+23F) / 180F * (float)Math.PI) ;
    		posY = usePlayer.posY + 1.4D;
    		posZ = usePlayer.posZ + Math.cos((usePlayer.rotationYaw+23F) / 180F * (float)Math.PI) ;
    		rotationYaw = usePlayer.rotationYaw;
    		
    		if(usePlayer.onGround)
    		{
    			finish();
    		}

    		//if(usePlayer.motionY < -0.2D)
			{
				if(usePlayer.motionY < -0.5D)
				{
					//damage++;
				}
				usePlayer.motionY *= 0.3F;
				usePlayer.fallDistance *= 0.7F;
				//usePlayer.fallDistance = 0.0F;
			}
    	}
    	setPosition(posX, posY, posZ);
    	if(damage >= 60)
    	{
    		setDead();
    	}


    	if(rotationYaw >  180F)rotationYaw -= 360F;
    	if(rotationYaw < -180F)rotationYaw += 360F;
    	if(rotationPitch >  180F)rotationPitch -= 360F;
    	if(rotationPitch < -180F)rotationPitch += 360F;

    	setRotation(rotationYaw, rotationPitch);
    }


	protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound)
    {
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound)
    {
    }
}
