package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

import java.util.List;
import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemAjaRedStone extends ItemBow
{
	
	//主に弓を元に改造。　360度飛ぶ弾幕を発射するアイテム
	//上下を向いている場合の発射角度に不具合あり。
	
	public ItemAjaRedStone(int i)
	{
		super(i);
		setMaxDamage(300);//耐久値だが、ここではチャージの具合を表すものとして使用している。
	}

	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	ArrowNockEvent event = new ArrowNockEvent(entityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled())
        {
            return event.result;
        }
    	entityPlayer.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));//アイテムの使用継続時間を記憶させる
    	
    	EntityAjaRedStoneEffect entityAjaRedStoneEffect = new EntityAjaRedStoneEffect( world, entityPlayer);
    	if(!world.isRemote)
    	{
    		world.spawnEntityInWorld(entityAjaRedStoneEffect);
    	}
    	return itemStack;
    }
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	//@SideOnly(Side.CLIENT)
	public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityPlayer, int usedTime)
    {

   	}
	
	//アイテムを使ったときのアクションを指定
	@Override
	public EnumAction getItemUseAction(ItemStack par1ItemStack)
    {
        return EnumAction.block;//右クリック時は剣のガードアクション
    }
	
		//アイテムを発光させる。 trueなら発光
	@Override
    @SideOnly(Side.CLIENT)
	public boolean hasEffect(ItemStack itemstack)
	{   
		return true;
    }
	
	//エンチャント不可
    @Override
	public int getItemEnchantability()
    {
        return 0;
    }
}