package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.potion.PotionEffect;

import java.util.List;

public class ItemClosedThirdEye extends Item
{
	
	//こいしの閉じた第三の目
	
	public ItemClosedThirdEye(int itemID)
	{
		super(itemID);
		maxStackSize = 1;//一つしか持てない
		setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
	}
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	entityPlayer.addPotionEffect(new PotionEffect(14, 20, 0));//敵に気づかれなくなる
    	Entity entity = null;
    	List list = world.getEntitiesWithinAABBExcludingEntity(entityPlayer, entityPlayer.boundingBox.expand(30.0D, 30.0D,30.0D));//プレイヤーを中心に10ブロックの立方体内の当たりを取得
    	double ax, ay, az, dx, dy, dz, power;

        if (list != null && list.size() > 0)
        {
            for (int j1 = 0; j1 < list.size(); j1++)
            {
                entity = (Entity)list.get(j1);
            	if ( entity instanceof EntityLiving)//生物なら
            	{
            		EntityLiving entityLiving = (EntityLiving)entity;
            		if(!entityLiving.canEntityBeSeen(entityPlayer) || entityLiving.getDistanceToEntity(entityPlayer) > 8.0D)//間に壁があるか、ある程度の距離があれば有効
            		{
            			if(entityLiving.getAttackTarget() == entityPlayer)
            			{
            				entityLiving.setAttackTarget(null);//使用者をターゲットから外す
            			}
            		}
                }
            }
        }
    	return itemStack;
    }
}