package net.minecraft.thKaguyaMod;

import net.minecraft.*;
import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.block.Block;

import java.util.List;

public class ItemDeathScythe extends ItemSword
{

	//死神の大鎌
	//周囲の動物やモンスターを引き寄せたり、離したりできる
	
    public ItemDeathScythe(int par1, EnumToolMaterial par2EnumToolMaterial)
    {
        super(par1, par2EnumToolMaterial);
        setMaxDamage(444);
        //weaponDamage = 6;
    }
	
	/*@Override
	public String getTextureFile()
	{
		return "/gui/thKaguyaTerrain.png";
	}*/
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
   	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {
    	//entityplayer.displayWorkbenchGUI((int)entityplayer.posX+1, (int)entityplayer.posY, (int)entityplayer.posZ+1);
    	//プレイヤーの当たり判定を取得して、周囲のEntityとの接触を調べる
    	Entity entity = null;
    	List list = world.getEntitiesWithinAABBExcludingEntity(entityplayer, entityplayer.boundingBox.expand(10.0D, 10.0D,10.0D));//プレイヤーを中心に10ブロックの立方体内の当たりを取得
    	double ax, ay, az, dx, dy, dz, power;
		float angleXZ, angleY;
    	float epYaw = (360F-entityplayer.rotationYaw) % 360F;
    	if(epYaw < 0F)
    	{
    		epYaw -= 360F;
    	}
    	boolean check;
    	power = 0.3D;//引力、斥力の力

        if (list != null && list.size() > 0)
        {
            for (int j1 = 0; j1 < list.size(); j1++)
            {
                entity = (Entity)list.get(j1);
                if ( (entity.canBePushed() || entity instanceof EntityPlayer) && entity instanceof EntityLiving)//押すことができて、生物なら
            	{
            		EntityLiving entityliving = (EntityLiving)entity;
            		if(entityplayer.canEntityBeSeen(entityliving))//間に壁があれば無効
            		{
						dx = entityliving.posX - entityplayer.posX;//Entityと使用者の各要素の距離を保存
						dy = entityliving.posY - entityplayer.posY;
						dz = entityliving.posZ - entityplayer.posZ;
			
						angleY  = (float)Math.atan2(dx, dz);//平面上の角度を求める
						angleXZ = (float)Math.atan2( Math.sqrt(dx*dx + dz*dz), dy);//上下方向の角度を求める
	            		check = false;
	            		
	            		float angleYDeg = angleY / 3.141593F * 180F;
	            		//水平方向の判定　見ている方向の-20～+20の角度をカバー
	            		if(angleYDeg < 0F)
	            		{
	            			angleYDeg += 360F;
	            		}
	            		
            			//見ている角度epYawとEntityまでの角度angleYDegを0～360に固定して判定
            			//20～340のときはそのまま判定
	            		if(epYaw > 20F && epYaw < 340F)
	            		{
	            			if(epYaw-20F < angleYDeg && epYaw+20F > angleYDeg)
	            			{
	            				check = true;
	            			}
	            		}
            			//20以下のときは少し特殊な判定を与えないとできない
	            		else if(epYaw <= 20F)
	            		{
	            			if( (0F <= angleYDeg && epYaw+20F >= angleYDeg ) || 
	            				(360F-epYaw < angleYDeg && 360F > angleYDeg))
	            			{
	            				check = true;
	            			}
	            		}
            			//340以上　同上
	            		else
	            		{
	            			if( (20F-(360F-epYaw) >= angleYDeg && 0F <= angleYDeg ) || 
	            				(epYaw-20F < angleYDeg && 360F > angleYDeg))
	            			{
	            				check = true;
	            			}
	            		}
	            		if(check)
	            		{
	                		if(entityplayer.isSneaking())//スニークなら斥力
	                		{
	                			entityliving.motionX += MathHelper.sin(angleY) * power;//powerの分だけ斥力を働かせる
	                			entityliving.motionY += MathHelper.sin(angleXZ) * power;
	                			entityliving.motionZ += MathHelper.cos(angleY) * power;
		                	}
		                	else//スニークじゃないなら引力
		                	{
		                		entityliving.motionX -= MathHelper.sin(angleY) * power;//powerの分だけ引力を働かせる
		                		entityliving.motionY -= MathHelper.sin(angleXZ) * power;
		                		entityliving.motionZ -= MathHelper.cos(angleY) * power;
		                	}
	            			itemstack.damageItem(1, entityplayer);//距離を操った生物の数だけ耐久が減る
	            		}
            		}
                }
            }
        }
       	return itemstack;
    }
	
	@Override
	public int getDamageVsEntity(Entity par1Entity)
    {
        return 6;
    }

	@Override
    public boolean canHarvestBlock(Block par1Block)
    {
    	return false;//特にブロックを壊せるわけではない
    }

	//エンチャンができるか
	@Override
    public int getItemEnchantability()
    {
        return 7;//エンチャントができる
    }
	

	
}
