package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.IArmorTextureProvider;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;

public class ItemHinezumi extends ItemArmor// implements IArmorTextureProvider//ItemArmorを継承。これを継承しないと簡単に鎧を着ることができない。
{	
	
	//火鼠の皮衣
	//炎に耐性のある衣 着ても持っても炎に対しては強い
	
    public ItemHinezumi(int i, EnumArmorMaterial enumarmormaterial, int j, int k)
    {
    	super(i,enumarmormaterial,j,k);//鎧の素材を、独自のものにしたいなら、EnumArmorMaterialを独自のものに変更すればいいはず
    	setMaxDamage(0);//アイテムの耐久設定。　0なら無限
    }
	
	/*@Override
	public String getTextureFile()
	{
		return "/gui/thKaguyaTerrain.png";
	}*/
	
	//アイテムをクラフトしたときに呼び出されるメソッド
	/*public void onCreated(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {
   		itemstack.addEnchantment(Enchantment.fireProtection, 5);//fireProtection　レベル５を付加
    	//他のエンチャント効果を付けたいのなら、Enchantment.javaを参照
    	//ちなみにShiftでアイテムを回収した場合にエンチャントがつかないのは、このメソッドのバグ？
    }*/
	/*public void onItemPickup(EntityPlayer entityplayer, ItemStack itemstack)
	{
		itemstack.addEnchantment(Enchantment.fireProtection, 5);//fireProtection　レベル５を付加
	}*/
	/*public void onCreated(ItemStack itemStack, World world, EntityPlayer entityPlayer)
	{
		itemStack.addEnchantment(Enchantment.fireProtection, 5);//fireProtection　レベル５を付加
	}*/
	
	public void takenFromCrafting(EntityPlayer entityplayer, ItemStack itemstack, IInventory iinventory)
    {
    	itemstack.addEnchantment(Enchantment.fireProtection, 5);//fireProtection　レベル５を付加
    	//他のエンチャント効果を付けたいのなら、Enchantment.javaを参照
    	//ちなみにShiftでアイテムを回収した場合にエンチャントがつかないのは、このメソッドのバグ？
    }
	
	//左クリックでEntityに当たった場合に呼び出されるメソッド
	@Override
	public boolean hitEntity(ItemStack par1ItemStack, EntityLiving par2EntityLiving, EntityLiving par3EntityLiving)
    {
        //par1ItemStack.damageItem(0, par3EntityLiving);//耐久値を０減らす　（いらない？）
    	par2EntityLiving.setFire(20);//当たったEntityに着火　数値が大きいほど長くなるのかな？
        return true;
    }
	
	//右クリック時にとる行動。
	@Override
	public EnumAction getItemUseAction(ItemStack par1ItemStack)
    {
        return EnumAction.block;//ガードの構えをする
    }
	
	//右クリックを押している時間の最大時間
	public int getMaxItemUseDuration(ItemStack par1ItemStack)
    {
        return 72000;
    }
	
	//右クリック時の処理
	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
    {
    	if(!par1ItemStack.isItemEnchanted())//エンチャントがついていないなら、炎耐性５を付与（救済処置）
    	{
    		par1ItemStack.addEnchantment(Enchantment.fireProtection, 5);
    	}
    	par3EntityPlayer.setItemInUse(par1ItemStack, getMaxItemUseDuration(par1ItemStack));
    	par3EntityPlayer.extinguish();//使用者の炎を消す
        return par1ItemStack;
    }
	
	//アイテムの表示サイズ。　trueなら剣の様に大きく表示される
	@Override
    public boolean isFull3D()
    {
        return true;
    }
    
	//アイテムを発光させるか。 trueなら発光
	@SideOnly(Side.CLIENT)
	@Override
    public boolean hasEffect(ItemStack itemstack)
    {   
		return true;
    }
	
	//エンチャントの可否
	@Override
	public int getItemEnchantability()
    {
        return 0;//エンチャント不可
    }
	
	@SideOnly(Side.CLIENT)
    public boolean requiresMultipleRenderPasses()
    {
        return false;
    }
	
	/*
	 * IArmorTextureProviderで防具のテクスチャファイルを適当させているだけです。
	 */
	@SideOnly(Side.CLIENT)
	public String getArmorTextureFile(ItemStack itemstack)
	{
		return "/armor/hinezumi_1.png";
	}
	
	//アーマースロットに入っているときに呼び出される（Forge追加）
	public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack)
    {
		player.extinguish();//着用者の炎を消す
    }

	
}