package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.IShearable;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.item.EntityItem;

import java.util.Random;
import java.util.ArrayList;

public class ItemHisou extends ItemSword
{

	//緋想の剣
	//5レベル以上なら「全人類の緋想天」を放てる
	//相手の弱点を取得する（しない・・・(´・ω・｀)
	
	
    public ItemHisou(int par1, EnumToolMaterial par2EnumToolMaterial)
    {
        super(par1, par2EnumToolMaterial);
        setMaxDamage(200);
        //weaponDamage = 7;
    }
	
	//ブロックを破壊したときに呼び出される
	@Override
	public boolean onBlockDestroyed(ItemStack par1ItemStack, World world, int par2, int par3, int par4, int par5, EntityLiving par6EntityLiving)
    {
        if (par2 == Block.leaves.blockID && par4 > 128)
        {
        	Random random = new Random();
        	int rand = random.nextInt(25);
        	if( rand == 1 )
        	{
        		EntityItem entityItem = new EntityItem(par6EntityLiving.worldObj, par3, par4, par5, new ItemStack(mod_thKaguya.heavenlyPeachItem));
        		if(!world.isRemote)
        		{
        			par6EntityLiving.worldObj.spawnEntityInWorld(entityItem);
        		}
        	}
            return true;
        }
        else
        {
            return super.onBlockDestroyed(par1ItemStack, world, par2, par3, par4, par5, par6EntityLiving);
        }
    }
	
	

	//ブロックに対する強さ
	@Override
    public float getStrVsBlock(ItemStack par1ItemStack, Block par2Block)
    {
    	if (par2Block.blockID == Block.leaves.blockID)
        {
            return 15F;
        }

        if (par2Block.blockID == Block.cloth.blockID)
        {
            return 10F;
        }
        else
        {
            return super.getStrVsBlock(par1ItemStack, par2Block);
        }
    }
	

	
	
	/*@Override
    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) 
    {
    	if (player.worldObj.isRemote)
        {
            return false;
        }
    	int id = player.worldObj.getBlockId(x, y, z);
        if (Block.blocksList[id] instanceof IShearable)//id == Block.leaves.blockID && y > 128)
        {
        	IShearable target = (IShearable)Block.blocksList[id];
            if (target.isShearable(itemstack, player.worldObj, x, y, z))
            {
        	 	ArrayList<ItemStack> drops = target.onSheared(itemstack, player.worldObj, x, y, z,
                        EnchantmentHelper.getEnchantmentLevel(Enchantment.fortune.effectId, itemstack));
        		//Random random = new Random();
        		//int rand = random.nextInt(25);
        		//if( rand == 1 )
        		//{
        			for(ItemStack stack : drops)
                	{
        				//EntityItem entityItem = new EntityItem(player.worldObj, x, y, z, new ItemStack(mod_thKaguya.heavenlyPeachItem));
						//entityItem.delayBeforeCanPickup = 10;
        				//player.worldObj.spawnEntityInWorld(entityItem);
                    float f = 0.7F;
                    double d  = (double)(1.0F - f) * 0.5D;
                    double d1 = (double)(1.0F - f) * 0.5D;
                    double d2 = (double)(1.0F - f) * 0.5D;
                    EntityItem entityitem = new EntityItem(player.worldObj, (double)x + d, (double)y + d1, (double)z + d2, stack);
                    entityitem.delayBeforeCanPickup = 10;
                    player.worldObj.spawnEntityInWorld(entityitem);
                	}
        		//}
            }
        }
		return false;
    }*/
	
	//アイテムを発光させる。 trueなら発光
	@Override
	public boolean hasEffect(ItemStack itemstack)
	{   
		return true;
    }
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
   	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {
    	//「全人類の緋想天」を使用する
    	if(entityplayer.experienceLevel >= 5)//レベルが５より上なら使用可能
    	{
    		//entityplayer.removeExperience(5);//経験値を５消費
    		entityplayer.addExperienceLevel(-5);//レベルを5消費
    		EntityHisou[] entityHisou = new EntityHisou[8];
    		
    		entityHisou[7] = new EntityHisou(world, entityplayer,null, 7+1, itemstack.getItemDamageForDisplay());
    		if(!world.isRemote)
    		{
         		world.spawnEntityInWorld(entityHisou[7]);//バールのようなものの本体
    			itemstack.stackSize--;//スタックから消滅させる
    		}
    		for(int i = 6; i > 0; i--)
    		{
    			entityHisou[i] = new EntityHisou(world, entityplayer, entityHisou[7], i+1, 0);
         		if(!world.isRemote)
    			{
    				world.spawnEntityInWorld(entityHisou[i]);//バールのようなものの残像
    			}
    		}
    	}
    		
       	return itemstack;
    }

	//武器の威力
	@Override
    public int getDamageVsEntity(Entity par1Entity)
    {
        return 7;
    }

	//エンチャント
	@Override
    public int getItemEnchantability()
    {
        return 0;//エンチャントできない
    }
	
}
