package net.minecraft.thKaguyaMod;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Icon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import java.util.Random;

public class ItemHisyaku extends Item
{
    //舟幽霊の柄杓
	//Shift+右クリックでモード変更ができる
	//空のアイコンのときは無限に水源を除去できる
	//水のアイコンのときは水源を有限回設置可能
	//何もブロックがないところで使うと足元が水源になる
	//クリエイティブではモード変更ができない
	
	public static final String iconName[] =
	{
		"hisyaku_0", "hisyaku_1",
	};
	@SideOnly(Side.CLIENT)
    private Icon[] icon;

    public ItemHisyaku(int par1)
    {
        super(par1);
        maxStackSize = 1;
    	setMaxDamage(60);
    	setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
    }
	
	//ダメージ値でアイテムアイコンを変える
	/*public int getIconFromDamage(int par1)
    {
    	if (par1 % 2 == 0)//ダメージ値を2で割った余りが0なら
        {
            return 100;//getTextureFileで取得した画像ファイルを16x16に分けたときの、100番目の画像を使用。左上を0、右下を255とする
        }
    	else
    	{
    		return 101;
    	}
    }*/
	
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public Icon getIconFromDamage(int damage)
    {
        //int i = MathHelper.clamp_int(damage, 0, 1);
    	int i = 0;
    	if(damage % 2 == 1)
    	{
    		i = 1;
    	}
        return this.icon[i];
    }
	
	@SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister)
    {
        this.icon = new Icon[iconName.length];

        for (int i = 0; i < iconName.length; ++i)
        {
            this.icon[i] = par1IconRegister.registerIcon(iconName[i]);
        }
    }

    //右クリックを押したときに呼び出される
	@Override
    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	int mode = itemStack.getItemDamage() % 2;
    	if(entityPlayer.isSneaking())
    	{
    		if(mode == 0)
    		{
    			itemStack.setItemDamage(itemStack.getItemDamage() - 1);
    		}
    		else
    		{
    			itemStack.setItemDamage(itemStack.getItemDamage() + 1);
    		}
    		return itemStack;
    	}
    	
    	float f = 1.0F;
        double d = entityPlayer.prevPosX + (entityPlayer.posX - entityPlayer.prevPosX) * (double)f;
        double d1 = (entityPlayer.prevPosY + (entityPlayer.posY - entityPlayer.prevPosY) * (double)f + 1.6200000000000001D) - (double)entityPlayer.yOffset;
        double d2 = entityPlayer.prevPosZ + (entityPlayer.posZ - entityPlayer.prevPosZ) * (double)f;
    	int i = 0, j = 0,k = 0;
        boolean flag = mode == 1;
    	
        MovingObjectPosition movingobjectposition = getMovingObjectPositionFromPlayer(world, entityPlayer, flag);
        
        if(mode == 1)
        {
        	if (movingobjectposition != null)
        	{
        		i = movingobjectposition.blockX;
				j = movingobjectposition.blockY;
        		k = movingobjectposition.blockZ;
	            if (world.getBlockMaterial(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0)
	        	{
	                //world.setBlockWithNotify(i, j, k, 0);
	        		//world.setBlockAndMetadataWithNotify(i, j, k, 0, 0, 0);
	        		//world.func_94571_i(i, j, k);
	        		world.setBlockToAir(i, j, k);
	            }
	        }
		}
        
        else
        {
            if (movingobjectposition == null)
            {
            	i = (int)(entityPlayer.posX - 0.5D);
            	j = (int)(entityPlayer.posY - entityPlayer.yOffset + 0.5D);
            	k = (int)(entityPlayer.posZ - 0.5D);
            }
            else
            {
            	i = movingobjectposition.blockX;
				j = movingobjectposition.blockY;
        		k = movingobjectposition.blockZ;
	            
            	if (movingobjectposition.sideHit == 0)
	            {
	                j--;
	            }

	            if (movingobjectposition.sideHit == 1)
	            {
	                j++;
	            }

	            if (movingobjectposition.sideHit == 2)
	            {
	                k--;
	            }

	            if (movingobjectposition.sideHit == 3)
	            {
	                k++;
	            }

	            if (movingobjectposition.sideHit == 4)
	            {
	                i--;
	            }

	            if (movingobjectposition.sideHit == 5)
	            {
	                i++;
	            }
            }
            	

            if (world.isAirBlock(i, j, k) || !world.getBlockMaterial(i, j, k).isSolid())
            {
                if (world.provider.isHellWorld)
                {
                    world.playSoundEffect(d + 0.5D, d1 + 0.5D, d2 + 0.5D, "random.fizz", 0.5F, 2.6F + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8F);

                    for (int l = 0; l < 8; l++)
                    {
                        world.spawnParticle("largesmoke", (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0D, 0.0D, 0.0D);
                    }
                }
                else
                {
                    //world.setBlockAndMetadataWithNotify(i, j, k, 8, 0, 0);//水を設置
                	world.setBlock(i, j, k, 8, 0, 3);
                	itemStack.damageItem(2, entityPlayer);
                }

            }
        }
		return itemStack;
    }
	
	@SideOnly(Side.CLIENT)
	//クリエイトモードのアイテム欄に、ダメージ値の違うアイテムも表示できるようにする
    public void getSubItems(int itemID, CreativeTabs par2CreativeTabs, List par3List)
    {
        par3List.add(new ItemStack(itemID, 1, 0));
    	par3List.add(new ItemStack(itemID, 1, 1));
    }

}
