package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

public class ItemHomingAmulet extends Item
{
	//霊夢のホーミングアミュレット
	
	public ItemHomingAmulet(int i)
	{
		super(i);
		maxStackSize = 64;
		setHasSubtypes(true);
		setMaxDamage(0);
		setCreativeTab(CreativeTabs.tabCombat);//クリエイティブの武器タブに登録
	}
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityplayer)
    {
    	double ax,ay,az;
    	EntityHomingAmulet entityHomingAmulet;

    	if(entityplayer.isSneaking())//低速モード
    	{
    		float angle = -10F;
    		for(int i = 0; i < 2; i++)
    		{
   				ax = -MathHelper.sin(((entityplayer.rotationYaw + angle) / 180F) * 3.141593F) * MathHelper.cos(((entityplayer.rotationPitch) / 180F) * 3.141593F);//X方向　水平方向
    			ay = -MathHelper.sin(((entityplayer.rotationPitch) / 180F) * 3.141593F);// * MathHelper.cos((0F/180F) * 3.141593F);//Y方向　上下
   				az =  MathHelper.cos(((entityplayer.rotationYaw + angle) / 180F) * 3.141593F) * MathHelper.cos(((entityplayer.rotationPitch) / 180F) * 3.141593F);//Z方向　水平方向
   				entityHomingAmulet = new EntityHomingAmulet(world, (EntityLiving)entityplayer, ax*0.5D, ay*0.5D, az*0.5D, 0.5D,4, 1, 2.0F);
       			if(!world.isRemote)
       			{
          			world.spawnEntityInWorld(entityHomingAmulet);//ホーミングアミュレットを出現させる
       			}
    			angle += 20F;
    		}
    	}
    	else//高速モード
    	{
    		float angle = -50F;
    		for(int i = 0; i < 5; i++)
    		{
   				ay = -MathHelper.sin(((entityplayer.rotationPitch) / 180F) * 3.141593F);// * MathHelper.cos((0F/180F) * 3.141593F);//Y方向　上下
   				ax = -MathHelper.sin(((entityplayer.rotationYaw + angle) / 180F) * 3.141593F) * MathHelper.cos(((entityplayer.rotationPitch) / 180F) * 3.141593F);//X方向　水平方向
   				az =  MathHelper.cos(((entityplayer.rotationYaw + angle) / 180F) * 3.141593F) * MathHelper.cos(((entityplayer.rotationPitch) / 180F) * 3.141593F);//Z方向　水平方向
   				entityHomingAmulet = new EntityHomingAmulet(world, (EntityLiving)entityplayer, ax*0.5D, ay*0.5D, az*0.5D, 0.5D,2, 0, 1.2F);
       			if(!world.isRemote)
       			{
          			world.spawnEntityInWorld(entityHomingAmulet);//ホーミングアミュレットを出現させる
       			}
    			angle += 25F;
    		}
    	}
    	world.playSoundAtEntity(entityplayer, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
    	itemStack.stackSize--;//一つ消費
    	
        return itemStack;
    }
}