package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.*;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class ItemHotokeHachi extends ItemTool
{
	private static Block blocksEffectiveAgainst[];
	
	//仏の御石の鉢
	//石の複合ツール 剣、ツルハシ、スコップ、斧の役割を持つ
	//ただし、剣のガード、スコップの雪回収等の細かな機能はない
	//石だから、金やダイヤの採取も不可
	
	private int weaponDamage;
	
	public ItemHotokeHachi(int i, EnumToolMaterial enumtoolmaterial)
	{
		super(i, 2, enumtoolmaterial, blocksEffectiveAgainst);
		blocksEffectiveAgainst = blocksEffectiveAgainst;
		setMaxDamage(enumtoolmaterial.getMaxUses());
		weaponDamage = 5;
	}

	//アイテムを発光させる。 trueなら発光
	@SideOnly(Side.CLIENT)
	@Override
   	public boolean hasEffect(ItemStack itemstack)
   {   
		return true;
    }


	//ブロックの壊し安さを設定。　大きいほど壊れやすい。
	@Override
	public float getStrVsBlock(ItemStack itemstack, Block block)
	{
		return 4F;
	}

	//Entityに当たったときの処理
	@Override
	public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1)
	{
		return true;
	}

	//ブロックを破壊したときの処理
	@Override
	public boolean onBlockDestroyed(ItemStack itemstack, World world, int i, int j, int k, int l, EntityLiving entityliving)
	{
		return true;
	}
	
	@Override
	public int getDamageVsEntity(Entity entity)
	{
		return weaponDamage;
	}
	
	//インベントリにある限り常時呼び出される
	/*public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag)
    {
    	//world.setLightValue(EnumSkyBlock.Sky, (int)entity.prevPosX, (int)entity.prevPosY, (int)entity.prevPosZ, 0);
    	
    	
    	//world.setLightValue(EnumSkyBlock.Block, (int)entity.posX, (int)entity.posY, (int)entity.posZ, 14);
		//world.setLightValue(EnumSkyBlock.Sky, (int)entity.posX, (int)entity.posY, (int)entity.posZ, 6);
    	//if( ((int)entity.posX != (int)entity.prevPosX) || ((int)entity.posY != (int)entity.prevPosY) || ((int)entity.posZ != (int)entity.prevPosZ) )
    	//{
    		
    		//world.setLightValue(EnumSkyBlock.Block, (int)entity.prevPosX, (int)entity.prevPosY, (int)entity.prevPosZ, 0);
    		//world.updateAllLightTypes( (int)entity.prevPosX, (int)entity.prevPosY, (int)entity.prevPosZ);
    	//}
    	
    	
    }*/
	
	@Override
	public boolean isFull3D()
	{
		return false;
	}

	//採取可能なブロック
	@Override
    public boolean canHarvestBlock(Block par1Block)
    {
        if (par1Block == Block.obsidian)
        {
            return toolMaterial.getHarvestLevel() == 3;
        }

        if (par1Block == Block.blockDiamond || par1Block == Block.oreDiamond)
        {
            return toolMaterial.getHarvestLevel() >= 2;
        }

        if (par1Block == Block.blockGold || par1Block == Block.oreGold)
        {
            return toolMaterial.getHarvestLevel() >= 2;
        }

        if (par1Block == Block.blockIron || par1Block == Block.oreIron)
        {
            return toolMaterial.getHarvestLevel() >= 1;
        }

        if (par1Block == Block.blockLapis || par1Block == Block.oreLapis)
        {
            return toolMaterial.getHarvestLevel() >= 1;
        }

        if (par1Block == Block.oreRedstone || par1Block == Block.oreRedstoneGlowing)
        {
            return toolMaterial.getHarvestLevel() >= 2;
        }

        if (par1Block.blockMaterial == Material.rock)
        {
            return true;
        }

        return par1Block.blockMaterial == Material.iron;
    }

    static 
    {
        blocksEffectiveAgainst = (new Block[] {
            Block.cobblestone, /*Block.stairDouble, Block.stairSingle,*/ Block.stone, Block.sandStone, Block.cobblestoneMossy, Block.oreIron, Block.blockIron, Block.oreCoal, Block.blockGold, 
            Block.oreGold, Block.oreDiamond, Block.blockDiamond, Block.ice, Block.netherrack, Block.oreLapis, Block.blockLapis, Block.oreRedstone, Block.oreRedstoneGlowing, Block.rail, 
            Block.railDetector, Block.railPowered
        });
    }
	
	//エンチャントできない。　できるとかなりのチートアイテム化する。
	@Override
	public int getItemEnchantability()
    {
        return 0;
    }

}