package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Icon;

import net.minecraft.util.Vec3;// 変更１

import java.util.List;
import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemHouraiEda extends ItemBow
{
       
	//主に弓を元に改造。　360度飛ぶ弾幕を発射するアイテム
	
	public static final String houraiEdaIconName[] =
	{
		"houraiEda", "houraiEda_4","houraiEda_3", "houraiEda_2", "houraiEda_1", "houraiEda_0"
	};
	@SideOnly(Side.CLIENT)
    private Icon[] icon;

	public ItemHouraiEda(int itemID)
	{
		super(itemID);
		setMaxDamage(301);//耐久値だが、ここではチャージの具合を表すものとして使用している。
		setHasSubtypes(true);
		setNoRepair();//修理不可
	}
	
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public Icon getIconFromDamage(int damage)
    {
    	int i = 5;
    	if(damage == 0)
    	{
    		i = 0;
    	}
    	else if(damage <= 100)
    	{
    		i = 1;
    	}
    	else if(damage <= 150)
    	{
    		i = 2;
    	}
    	else if(damage <= 200)
    	{
    		i = 3;
    	}
    	else if(damage <= 250)
    	{
    		i = 4;
    	}
        return this.icon[i];
    }
	
	@SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        this.icon = new Icon[houraiEdaIconName.length];

        for (int i = 0; i < houraiEdaIconName.length; ++i)
        {
            this.icon[i] = iconRegister.registerIcon(houraiEdaIconName[i]);
        }
    }
	

	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
	{
		ArrowNockEvent event = new ArrowNockEvent(entityPlayer, itemStack);
		MinecraftForge.EVENT_BUS.post(event);
		if (event.isCanceled())
		{
			return event.result;
		}
		entityPlayer.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));
		/*if(!world.isRemote && itemStack.getItemDamageForDisplay() < 259)
		{
			itemStack.damageItem(40, entityPlayer);//耐久を50/300減らす　連射は6回までということになる
		}*/
		return itemStack;
	}
       
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer entityPlayer, int usedTime)
	{
		int i,j,rand,shotNum;
		shotNum = 32 + getMaxItemUseDuration(itemStack)-usedTime;//発射される弾数を代入。　最低32発。　getMaxItemUseDuration(itemstack)-usedTimeは右クリック継続時間で変化うする部分

		ArrowLooseEvent event = new ArrowLooseEvent(entityPlayer, itemStack, shotNum);
		MinecraftForge.EVENT_BUS.post(event);
		if (event.isCanceled())
		{
			return;
		}

		if(shotNum > 72)
		{
			shotNum = 72;//最大でも72発まで
		}
		float f = 20F, angle = 0F, spanAngle;

		// 変更2
		double X1,X2,Z1,Z2,angleXZ = 0,angleY = 0,ay,ax,az;
		Vec3 lookAt = entityPlayer.getLookVec();
		lookAt.rotateAroundY((float)Math.PI*2);

		spanAngle = 360F/(float)shotNum; //あらゆる弾数でも360度飛ぶように、弾の間隔を代入
		Random random = new Random();
		EntityTHShot[] entityTHShot = new EntityTHShot[72]; //配列でEntityHouraiTama（蓬莱の玉）を72個作成
		float degTrans = 3.141593F / 180F;
		float pitchDis = entityPlayer.rotationPitch / ((float)shotNum / 4.0F);
		float rotationPitch = entityPlayer.rotationPitch;

		if(itemStack.getItemDamageForDisplay() < 250)//受けているダメージが249より小さいなら使用可能　つまり耐久値が50/300より大きいなら使用できる
		{
			if(entityPlayer.isSneaking())//スニーク状態なら
			{
				//弾幕を発射。　単純な全方位ではなく、弾速の違う３つをセットに全方位に放つ
				for(i = 0; i < shotNum; i+=3)
				{
					for(j = 0; j < 3; j ++)
					{
						rand = 8 + random.nextInt(7);//弾の色をランダムで決める
						//飛ぶ方向を設定
						// 変更3
						angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
						angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る

						X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
						Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
						X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
						Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
						
						ay = -Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch - angleY)/ 180.0F * Math.PI);//Y方向　上下
						ax =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
						az =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
						
						entityTHShot[i+j] = new EntityTHShot(world, entityPlayer, ax, ay, az, 0.3D+(double)(j*0.2), 2.0D, 0.03D, 5,rand, 0.3F);//蓬莱の弾の配列に方向、色などを代入
						angle += spanAngle;//飛ばす方向を360/弾数分増やす
						rotationPitch -= pitchDis * Math.cos(rotationPitch * degTrans);
					}
				}
			}
			else//スニーク状態でないなら
			{
				angle = -15.0F;
				spanAngle = spanAngle/4.0F;
				//こっちは前方集中
				for(i = 0; i < shotNum / 3 + 1; i++)
				{
					rand = 8 + random.nextInt(7);//弾の色をランダムで決める
					//飛ぶ方向を設定
					
					// 変更3
					angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
					angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る
                      
					X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					
					ay = -Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch - angleY)/ 180.0F * Math.PI);//Y方向　上下
					ax =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
					az =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
					
					entityTHShot[i] = new EntityTHShot(world, entityPlayer, ax, ay, az, 0.3D,2.0D, 0.03D, 5, rand, 0.3F);//蓬莱の弾の配列に方向、色などを代入
					angle += spanAngle;//飛ばす方向を360/弾数分増やす
				}
			}
			
			world.playSoundAtEntity(entityPlayer, "random.orb", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
			
			if(!world.isRemote)
			{
				if(entityPlayer.isSneaking())
				{
					for(i = 0; i < shotNum; i++)
					{
						world.spawnEntityInWorld(entityTHShot[i]);//配列に保存した設定で蓬莱の弾を出現させる
					}
				}
				else
				{
					for(i = 0; i < shotNum / 3 + 1; i++)
					{
						world.spawnEntityInWorld(entityTHShot[i]);//配列に保存した設定で蓬莱の弾を出現させる
					}
				}
			}
			
			itemStack.damageItem(50, entityPlayer);//耐久を50/300減らす　連射は6回までということになる
			//itemStack.damageItem(-(shotNum - 32), entityPlayer);
			//itemStack.setItemDamage(itemStack.getItemDamage() -40);
			//itemStack.animationsToGo += 40;
		}
		else
		{
			if(getMaxItemUseDuration(itemStack)- usedTime > 30)
			{
				itemStack.setItemDamage(0);
			}
		}
	}
	
	//アイテムを使ったときのアクションを指定
	@Override
	public EnumAction getItemUseAction(ItemStack itemStack)
	{
		return EnumAction.block;//右クリック時は剣のガードアクション
	}

	//インベントリにある限り常時呼び出されるメソッド
	@Override
	public void onUpdate(ItemStack itemStack, World world, Entity entity, int i, boolean flag)
	{
		//耐久が減っていたら徐々に回復
		//if(  /*itemStack.isItemDamaged() == true &&*/ entity.ticksExisted % 5 == 0)
		{
			if(entity instanceof EntityPlayer)
			{
				EntityPlayer entityPlayer = (EntityPlayer)entity;
				//itemStack.damageItem(5, entityPlayer);//毎フレーム耐久を1回復
				/*if(!world.isRemote)
				{
					itemStack.setItemDamage(itemStack.getItemDamage() - 5);
				}*/
				//itemStack.animationsToGo -= 5;
				if(!world.isRemote && itemStack.getItemDamage() > 300)
				{
					itemStack.setItemDamage(300);
				}
				/*if(itemStack.animationsToGo > 300)
				{
					itemStack.animationsToGo = 300;
				}*/
			}
		}
	}

	//アイテムを発光させる。 trueなら発光
	@Override
	@SideOnly(Side.CLIENT)
	public boolean hasEffect(ItemStack itemStack)
	{   
		return true;
	}
	
	//エンチャント不可
	@Override
	public int getItemEnchantability()
	{
		return 0;
	}
}