package net.minecraft.thKaguyaMod;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Icon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemHouraiPearl extends Item
{
	//蓬莱の玉　　なにもできないアイテム
	
	public static final String houraiPearlNames[] =
    {
        "Red Pearl", "Blue Pearl", "Green Pearl", "Yellow Pearl", "Purple Pearl", "Aqua Pearl", "Orange Pearl"
    };
	public static final String houraiPearlIconName[] =
	{
		"redPearl", "bluePearl", "greenPearl", "yellowPearl", "purplePearl", "aquaPearl", "orangePearl"
	};
	
	@SideOnly(Side.CLIENT)
    private Icon[] icon;

	public ItemHouraiPearl(int itemID)
	{
		super(itemID);
		setHasSubtypes(true);
		setMaxDamage(0);
		setCreativeTab(CreativeTabs.tabMaterials);//クリエイティブの素材タブに登録
	}
	
	public String getUnlocalizedName(ItemStack itemStack)
    {
        int i = MathHelper.clamp_int(itemStack.getItemDamage(), 0, 15);
        return super.getUnlocalizedName() + "." + houraiPearlNames[i];
    }
	
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public Icon getIconFromDamage(int damage)
    {
        int i = MathHelper.clamp_int(damage, 0, 6);
        return this.icon[i];
    }
	
	@SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister)
    {
        this.icon = new Icon[houraiPearlIconName.length];

        for (int i = 0; i < houraiPearlIconName.length; ++i)
        {
            this.icon[i] = par1IconRegister.registerIcon(houraiPearlIconName[i]);
        }
    }

	
	@SideOnly(Side.CLIENT)
	//クリエイトモードのアイテム欄に、ダメージ値の違うアイテムも表示できるようにする
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
        for (int i = 0; i < 5; i++)
        {
            par3List.add(new ItemStack(par1, 1, i));
        }
    	par3List.add(new ItemStack(par1, 1, 6));
    }
	
}