package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.entity.player.EntityPlayer;

public class ItemKabenuke extends Item
{
	
	//壁抜けの鑿
	//壁の向こうに空間があれば、そこまで通り抜けできる
	
	public ItemKabenuke(int itemID)
	{
		super(itemID);
		maxStackSize = 1;
		setMaxDamage(122);
		setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
	}
	
	//Forgeの追加メソッド
	@Override
	public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int par4, int par5, int par6, int par7, float hitX, float hiyY, float hitZ) 
	{
		int px = 0;
    	int py = 0;
    	int pz = 0;
    	int n = 0;
    	switch(par7)
    	{
    		case 0:
    			py = 1;
    			break;
    		case 1:
    			py = -1;
    			break;
    		case 2:
    			pz = 1;
    			break;
    		case 3:
    			pz = -1;
    			break;
    		case 4:
    			px = 1;
    			break;
    		default:
    			px = -1;
    			break;
    	}
    		
    	for(int i = 0; i < 16; i++)//最大16回の空間チェックの判定　最大16ブロック抜けられる
    	{
    		if( world.isAirBlock(par4, par5  ,par6))//空気ブロックかどうかの判定
    		{
    			if( world.isAirBlock(par4, par5+1, par6))//標準より上も空気ブロックかどうか？
    			{
    				world.playSoundAtEntity(entityPlayer, "random.fizz", 0.5F, 1.0F);//音を出す
    				entityPlayer.posX = (double)par4 + 0.5D;
    				entityPlayer.posY = (double)par5 + entityPlayer.yOffset;
    				entityPlayer.posZ = (double)par6 + 0.5D;
    				entityPlayer.motionX = 0.0D;
    				entityPlayer.motionY = 0.0D;
    				entityPlayer.motionZ = 0.0D;
    				entityPlayer.setPosition( (double)par4 + 0.5D, (double)par5 + entityPlayer.yOffset, (double)par6 + 0.5D);
    				itemStack.damageItem(1, entityPlayer);
    				return false;
    			}
    			else if( world.isAirBlock(par4, par5-1,par6))//標準より下も空気ブロックかどうか？
    			{
    				world.playSoundAtEntity(entityPlayer, "random.fizz", 0.5F, 1.0F);//音を出す
    				entityPlayer.posX = (double)par4 + 0.5D;
    				entityPlayer.posY = (double)par5 + entityPlayer.yOffset - 1.0D;
    				entityPlayer.posZ = (double)par6 + 0.5D;
    				entityPlayer.motionX = 0.0D;
    				entityPlayer.motionY = 0.0D;
    				entityPlayer.motionZ = 0.0D;
    				entityPlayer.setPosition( (double)par4 + 0.5D, (double)par5 + entityPlayer.yOffset - 1.0D, (double)par6 + 0.5D);
    				itemStack.damageItem(1, entityPlayer);
    				return false;
    			}
    		}
    		if(world.getBlockId(par4, par5, par6) == 7)//岩盤があったら失敗する 岩盤は壁抜け不可
    		{
    			return false;
    		}
    		par4 += px;
    		par5 += py;
    		par6 += pz;
    		n++;
    	}
    	
    	
    	return false;
	}
	
}