package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Icon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemKaigo extends ItemSword
{

	//悔悟の棒
	//相手の体力を3/4にする　体力が3/4より低い時は無効
	
	public static final String iconName[] =
	{
		"kaigoStick_0", "kaigoStick_1"
	};
	@SideOnly(Side.CLIENT)
    private Icon[] icon;
	
    public ItemKaigo(int itemID, EnumToolMaterial enumToolMaterial)
    {
        super(itemID, enumToolMaterial);
    	setHasSubtypes(true);
        setMaxDamage(0);
    }
	
	//Entityに当たったときに呼び出される
	@Override
    public boolean hitEntity(ItemStack itemStack, EntityLiving entityLiving, EntityLiving entityLiving2)
    {
    	if((double)entityLiving.getMaxHealth() * 0.75D <= (double)entityLiving.getHealth() && itemStack.getItemDamage() == 0)
    	{
    		entityLiving.setEntityHealth((int)((double)entityLiving.getMaxHealth() * 0.75D));
    		itemStack.setItemDamage(1);
    	}
        return true;
    }
	
	//Blockを破壊したときに呼び出される
	@Override
	public boolean onBlockDestroyed(ItemStack itemStack, World world, int par2, int par3, int par4, int par5, EntityLiving entityLiving)
    {
        itemStack.damageItem(0, entityLiving);//耐久は減らない
        return true;
    }
	
	//右クリックを押したときに呼び出される
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	int ikachan = -1;
    	for(int i = 0; i < entityPlayer.inventory.mainInventory.length; i++)
    	{
    		if (entityPlayer.inventory.mainInventory[i] != null && 
    			entityPlayer.inventory.mainInventory[i].itemID == Item.dyePowder.itemID &&//染料かつ
    			entityPlayer.inventory.mainInventory[i].getItemDamage() == 0)//それが黒なら
            {
                ikachan = i;
            	break;
            }
    	}
    	//イカスミを消費して耐久を回復
    	if (ikachan >= 0 && itemStack.getItemDamage() == 1)
        {
        	entityPlayer.inventory.mainInventory[ikachan].stackSize--;//イカスミを消費
        	if(entityPlayer.inventory.mainInventory[ikachan].stackSize <= 0)//マルチ化の影響か、最後の一つがうまく消えないから後処理
        	{
        		entityPlayer.inventory.mainInventory[ikachan] = null;
        	}
        	itemStack.setItemDamage(0);//効果回復
        }
    	entityPlayer.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));
        return itemStack;
    }

	@Override
    public int getDamageVsEntity(Entity entity)
    {
        return 1;
    }

	@Override
    public boolean isFull3D()
    {
        return false;
    }

	@Override
    public boolean canHarvestBlock(Block block)
    {
    	return false;
    }

	//エンチャントはできない
	@Override
    public int getItemEnchantability()
    {
        return 0;
    }
	
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public Icon getIconFromDamage(int damage)
    {
        int i = MathHelper.clamp_int(damage, 0, 1);
        return this.icon[i];
    }
	
	@SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister)
    {
        this.icon = new Icon[iconName.length];

        for (int i = 0; i < iconName.length; ++i)
        {
            this.icon[i] = par1IconRegister.registerIcon(iconName[i]);
        }
    }
	
	//アイテムを発光させる。 trueなら発光
	@Override
	public boolean hasEffect(ItemStack itemStack)
	{   
		return itemStack.getItemDamage() == 0;
    }

}
