package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.IArmorTextureProvider;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;

public class ItemKappaCap extends ItemArmor// implements IArmorTextureProvider//ItemArmorを継承。これを継承しないと簡単に鎧を着ることができない。
{	
	
	//河童の帽子
	//着用すると水中での移動が速くなる
	//水中にいないとどんどん壊れる
	
    public ItemKappaCap(int i, EnumArmorMaterial enumarmormaterial, int j, int k)
    {
    	super(i,enumarmormaterial,j,k);//鎧の素材を、独自のものにしたいなら、EnumArmorMaterialを独自のものに変更すればいいはず
    	setMaxDamage(500);//アイテムの耐久設定
    }
	
	//エンチャントの可否
	@Override
	public int getItemEnchantability()
    {
        return 0;//エンチャント不可
    }
	
	@SideOnly(Side.CLIENT)
    public boolean requiresMultipleRenderPasses()
    {
        return false;
    }
	
	/*
	 * IArmorTextureProviderで防具のテクスチャファイルを適当させているだけです。
	 * 頭、胴、足は"/armor/hogearmor_1.png"から
	 * 脚は"/armor/hogearmor_2.png"を参照させています。
	 */
	@SideOnly(Side.CLIENT)
	public String getArmorTextureFile(ItemStack itemstack)
	{
		return "/armor/hinezumi_1.png";
	}
	
	//アーマースロットに入っているときに呼び出される（Forge追加）
	public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack)
    {
    	if(player.isInWater())//水中にいるなら
    	{
    		player.motionX *= 1.2D;//速度を1.2倍する
    		if(player.motionY > 0.0D)
    		{
    			player.motionY *= 1.2D;
    		}
    		player.motionZ *= 1.2D;
    		double maxSpeed = 0.5D;
    		if(player.motionX > maxSpeed)
    		{
    			player.motionX = maxSpeed;
    		}
    		else if(player.motionX < -maxSpeed)
    		{
    			player.motionX = -maxSpeed;
    		}
    		if(player.motionY > maxSpeed)
    		{
    			player.motionY = maxSpeed;
    		}
    		if(player.motionZ > maxSpeed)
    		{
    			player.motionZ = maxSpeed;
    		}
    		else if(player.motionZ < -maxSpeed)
    		{
    			player.motionZ = -maxSpeed;
    		}
    		if(itemStack.isItemDamaged() == true)
    		{
    			itemStack.damageItem(-3, player);//耐久を3増やす
    		}
    	}
    	else//地上にいるなら
    	{
    		if(player.isWet())//濡れているなら
    		{
    			itemStack.damageItem(-1, player);//耐久を1増やす
    		}
    		else
    		{
    			
    			if(itemStack.getItemDamage() < 498)
    			{
    				itemStack.damageItem(1, player);//耐久を1減らす
    			}
    		}
    	}
    }

	
}