package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import java.util.List;
import java.util.Random;

public class ItemKinkakuzi extends Item
{
	//巨大な板を投げつけるアイテム
	
	public ItemKinkakuzi(int i)
	{
		super(i);
		maxStackSize = 1;
		setCreativeTab(CreativeTabs.tabCombat);//クリエイティブの武器タブに登録
	}
	
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {
    	//double pow = 0.3 + (double)(getMaxItemUseDuration(itemstack)-par4)/30.0;
    	double pow = 0.7;
    	/*if(pow > 3.0)
    	{
    		pow = 3.0;
    	}*/
    	if(entityplayer.isSneaking())
    	{
    		pow = 1.0;
    	}
    	EntityKinkakuzi entitykinkakuzi;
    	//飛ばす角度を設定
   		//double angleX = -MathHelper.sin((entityplayer.rotationYaw / 180F) * 3.141593F) * MathHelper.cos(((entityplayer.rotationPitch) / 180F) * 3.141593F);
   		//double angleZ =  MathHelper.cos((entityplayer.rotationYaw / 180F) * 3.141593F) * MathHelper.cos(((entityplayer.rotationPitch) / 180F) * 3.141593F);
    	//使用者の上方向に発射
    	entitykinkakuzi = new EntityKinkakuzi(world, (EntityLiving)entityplayer, pow);
       	world.playSoundAtEntity(entityplayer, "random.drr", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
       	if(!world.isRemote)
       	{
         	world.spawnEntityInWorld(entitykinkakuzi);//金閣寺の一枚天井を出現させる
       	}
    	itemstack.stackSize--;//スタックから消滅させる
    		
       	return itemstack;
    }
	
	
	//右クリック時の行動を設定
	@Override
    public EnumAction getItemUseAction(ItemStack par1ItemStack)
    {
        return EnumAction.bow;//弓の構えをする
    }
	
	//右クリック時のカウントの最大値を指定
	public int getMaxItemUseDuration(ItemStack par1ItemStack)
    {
        return 72000;
    }
	
	//アイテムを発光させる。 trueなら発光
	@Override
	public boolean hasEffect(ItemStack itemstack)
	{   
		return true;
    }
}