package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.monster.EntityMob;

import java.util.List;

public class ItemMikoSword extends ItemSword
{

	//神子の持つ宝剣　１０人の言葉を同時に聞き取れる
	//基本鉄の剣と同じ
	
    public ItemMikoSword(int itemID, EnumToolMaterial enumToolMaterial)
    {
        super(itemID, enumToolMaterial);
    }
		
	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	entityPlayer.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));//アイテムの使用継続時間を記憶させる
    	//のちにgetMaxItemUseDuration(par1ItemStack)を呼び出せば継続時間で大きくなる
        return itemStack;
    }
	
	//右クリックを押し終わったときに呼び出されるメソッド
	@Override
	public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityPlayer, int usedTime)
    {
    	Entity[] nearEntitys;//11番目の空間はゴミ箱
    	double[] nearDistance;
    	nearEntitys = new Entity[11];
    	nearDistance = new double[11];
    	double recognizeDistance = (double)(72000 - usedTime);
    	if(recognizeDistance > 50D) recognizeDistance = 50D;
    	int i;
    	for(i = 0; i < 11; i++)
    	{
    		nearEntitys[i] = null;
    		nearDistance[i] = 999.9D;
    	}
		Entity entitys = null;
		List list = world.getEntitiesWithinAABBExcludingEntity(entityPlayer, entityPlayer.boundingBox.expand(recognizeDistance, recognizeDistance,recognizeDistance));
        double d = 0.0D;
        for (int j = 0; j < list.size(); j++)
        {
			Entity entity1 = (Entity)list.get(j);
        	double distance = entityPlayer.getDistanceToEntity(entity1);
        	if(entity1 instanceof EntityLiving)
        	{
        		int n = 0;
        		boolean flag = false;
        		while(n < 10 && !flag)
        		{
        			if(nearDistance[n] > distance)
        			{
        				for(int k = 10; k > n; k--)
        				{
        					nearEntitys[k] = nearEntitys[k-1];
        					nearDistance[k] = nearDistance[k-1];
        				}
        				nearEntitys[n] = entity1;
        				nearDistance[n] = distance;
        				flag = true;
        			}
        			n++;
        		}
        	}
        }
    	String str;
    	String strPos;
    	String strUpDown;
    	String strColor;
    	String strNum;
    	int num;
    	double dx;
    	double dz;
    	float angle = (360F-entityPlayer.rotationYaw) % 360F;
    	float angle2;
    	//if(angle < 0F)epYaw -= 360F;
    	if(angle < -180F) angle += 360F;
    	if(angle >  180F) angle -= 360F;
    	i = 0;
    	while(i < 10 && nearEntitys[i] != null)
    	{
    		dx = nearEntitys[i].posX - entityPlayer.posX;//Entityと使用者の各要素の距離を保存
			dz = nearEntitys[i].posZ - entityPlayer.posZ;
			
    		angle2  = ((float)Math.atan2(dx, dz) / 3.141593F * 180F) % 360F;//平面上の角度を求める
    		if(angle2 < -180F) angle += 360F;
    		if(angle2 >  180F) angle -= 360F;
    		angle2 -= angle;
    		if(angle2 < -135F || angle2 > 135F) strPos = "Back";
    		else if(angle2 < -45F) strPos = "Right";
    		else if(angle2 <  45F) strPos = "Front";
    		else strPos = "Left";
    		if(entityPlayer.posY > nearEntitys[i].posY + 3.0D) strUpDown = "Down";
    		else if(entityPlayer.posY < nearEntitys[i].posY - 3.0D) strUpDown = "Up";
    		else strUpDown = "";
    		if(nearEntitys[i] instanceof EntityMob) strColor = "\u00a74";
    		else if(nearEntitys[i] instanceof EntityAnimal) strColor = "\u00a7a";
    		else strColor = "\u00a73";
    		num = i+1;
    		strNum = num + ". ";
    		if(num != 10) strNum = " " + strNum;
    		str = strColor + strNum + EntityList.getEntityString( nearEntitys[i] ) + " " + strPos + " " + strUpDown + "  "+ (int)nearDistance[i] + "m" + "  " ;
    		if(!world.isRemote)
    		{
    			entityPlayer.addChatMessage( str );
    		}
    		i++;
    	}
   	}

	//エンチャント可能か？
	@Override
    public int getItemEnchantability()
    {
        return 0;//エンチャント不可
    }
	
}
