package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

public class ItemMiniHakkero extends Item
{

	/*
	ミニ八卦炉
	おなじみ、マスタースパークの撃てるあれ
	*/
	
	
    public ItemMiniHakkero(int par1)
    {
        super(par1);
    	maxStackSize = 1;
    	setCreativeTab(CreativeTabs.tabCombat);//クリエイティブの武器タブに登録
    }
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
   	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {	
    	//マスタースパークの使用を許可しない設定なら何も起きない
    	if(!mod_thKaguya.UsingMasterSpark)
    	{
    		return itemstack;
    	}
    	
    	//ミニ八卦炉の設置地点にブロックがないことを確認
    	if(!world.isBlockNormalCube((int)(entityplayer.posX - (double)MathHelper.sin(entityplayer.rotationYaw   / 180F * 3.141593F) * MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 1.3D),
    						(int)(entityplayer.posY - (double)MathHelper.sin(entityplayer.rotationPitch / 180F * 3.141593F) * 1.3D + entityplayer.getEyeHeight()),
    						(int)(entityplayer.posZ + (double)MathHelper.cos(entityplayer.rotationYaw   / 180F * 3.141593F) * MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 1.3D)) )
    	{
    		//ファイアーチャージを32個消費
    		if(!entityplayer.inventory.hasItem(Item.fireballCharge.itemID))
    		{
    			return itemstack;
    		}
    		
    		int i = 0;
    		int count = 0;
    		
    		for(i = 0; i < entityplayer.inventory.mainInventory.length; i++){
    			if(entityplayer.inventory.mainInventory[i] != null && 
    				entityplayer.inventory.mainInventory[i].itemID == Item.fireballCharge.itemID)
    			{
    				count += entityplayer.inventory.mainInventory[i].stackSize;
    			}
    		}
    		
    		if(count >= 32)
    		{
    			for( i = 0; i < 32; i ++)
    			{
        				entityplayer.inventory.consumeInventoryItem(Item.fireballCharge.itemID);
    			}
    		}
    		else
    		{
    			return itemstack;
    		}
    		
    		EntityMiniHakkero entityMiniHakkero;
    		
    		entityMiniHakkero = new EntityMiniHakkero(world, entityplayer, itemstack.getItemDamageForDisplay());
       		if(!world.isRemote)
       		{
        		world.spawnEntityInWorld(entityMiniHakkero);//ミニ八卦炉を出す
       			itemstack.stackSize--;//スタックから消滅させる
       		}
    	}
    		
       	return itemstack;
    }
	
}
