package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

import java.util.List;
import java.util.Random;

public class ItemPendulum extends Item
{
	
	//ナズーリンペンデュラム
	//ナズーリンの持つペンデュラム
	//使用時の横に持っていたアイテム（ブロックのみ）が周囲にあるか探索する
	//ダイヤの探索などに使える。といっても、この仕様ではダイヤ鉱石もっていないと・・・
	//Shiftで使用すると高感度モードになる
	
	public ItemPendulum(int itemID)
	{
		super(itemID);
		maxStackSize = 1;
		setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
	}
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	int blockID = -1;
    	Item item = null;
    	ItemStack searchItem = entityPlayer.inventory.mainInventory[entityPlayer.inventory.currentItem + 1];
    	if(entityPlayer.inventory.currentItem < 8 && searchItem != null)
    	{
    		blockID = searchItem.itemID;
    		item = searchItem.getItem();
    	}
    	else
    	{
    		return itemStack;
    	}
    	if(searchItem.itemID > 255)//ブロック以外のアイテムはサーチできなくする
    	{
    		return itemStack;
    	}
    	
    	int mode = 0;
    	if(entityPlayer.isSneaking())//スニークなら高感度ナズーリンペンデュラムになる
    	{
    		mode = 1;
    	}
    	
    	EntityPendulum entityPendulum;
    	entityPendulum = new EntityPendulum(world, entityPlayer, mode, blockID);
    	world.playSoundAtEntity(entityPlayer, "random.orb", 0.5F, 0.9F);
       	if(!world.isRemote)
       	{
        	world.spawnEntityInWorld(entityPendulum);//ペンデュラムを出現させる
       		itemStack.stackSize--;//スタックから消滅させる
       	}
    	
    	//使用時のメッセージを表示
    	String str;
    	if(mode == 0)
    	{
    		str = "Pendulum started searching for " + item.getItemDisplayName(searchItem);
    	}
    	else
    	{
    		str = "Pendulum started searching for " + item.getItemDisplayName(searchItem) + " by High sensitivity mode!";
    	}
    	if(!world.isRemote)
    	{
    		entityPlayer.addChatMessage( str );
    	}
    	
    	return itemStack;
   	}

}