package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;

import java.util.List;

public class ItemRoukanken extends ItemSword
{

	//楼観剣　アンデッドに特攻　ガードはできない
	//基本鉄の剣と同じ
	
    public ItemRoukanken(int par1, EnumToolMaterial par2EnumToolMaterial)
    {
        super(par1, par2EnumToolMaterial);
        //weaponDamage = 8;
    }
	
	/*@Override
	public String getTextureFile()
	{
		return "/gui/thKaguyaTerrain.png";
	}*/
	
	//ブロックに対する強さ
	@Override
    public float getStrVsBlock(ItemStack par1ItemStack, Block par2Block)
    {
    	if (par2Block.blockID == Block.web.blockID || par2Block.blockID == Block.leaves.blockID)
        {
            return 30F;
        }

        if (par2Block.blockID == Block.cloth.blockID)
        {
            return 20F;
        }
        else
        {
            return super.getStrVsBlock(par1ItemStack, par2Block)*3F;
        }
    }

	//Entityに当たった時に呼び出される
	@Override
    public boolean hitEntity(ItemStack par1ItemStack, EntityLiving par2EntityLiving, EntityLiving par3EntityLiving)
    {
    	World world = par2EntityLiving.worldObj;
    	//アンデットに大ダメージ
    	if(par2EntityLiving.getCreatureAttribute() == EnumCreatureAttribute.UNDEAD)
    	{
    		par2EntityLiving.attackEntityFrom(DamageSource.causeMobDamage(par3EntityLiving), 20);
    	}
        par1ItemStack.damageItem(1, par3EntityLiving);
    	
        return true;
    }

	//Entityへのダメージ
	@Override
    public int getDamageVsEntity(Entity par1Entity)
    {
        return 8;
    }
	
	
		
	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
    {
    	par3EntityPlayer.setItemInUse(par1ItemStack, getMaxItemUseDuration(par1ItemStack));//アイテムの使用継続時間を記憶させる？
    	//のちにgetMaxItemUseDuration(par1ItemStack)を呼び出せば継続時間で大きくなっているっぽい。よくわからん。
        return par1ItemStack;
    }
	
	//右クリックを押し終わったときに呼び出されるメソッド
	@Override
	public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityPlayer, int par4)
    {
    	//int i,j,rand,shotnum,shotnum3;
    	EntityLiving entityplayer = (EntityLiving)entityPlayer;
    	if(entityplayer.onGround)
    	{
    		double power;
	    	power = (double)getMaxItemUseDuration(itemstack)-par4;//発射される弾数を代入。　最低32発。　getMaxItemUseDuration(itemstack)-par4は右クリック継続時間で変化うする部分
	    	if(power > 20.0)
	    	{
	    		power = 20.0;
	    	}
	    	power *= 0.3;
	    	entityplayer.motionX = (double)-MathHelper.sin(entityplayer.rotationYaw / 180F * 3.141593F) * power;
	    	entityplayer.motionZ = (double) MathHelper.cos(entityplayer.rotationYaw / 180F * 3.141593F) * power;
       		//if(!world.isRemote)//マルチでないなら
       		//{
       			itemstack.damageItem(1, entityplayer);//
       		//}
    	}
   	}
	
	//所持している限り常に呼ばれるメソッド
	@Override
	public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag)
	{
		//プレイヤーでなければ失敗する
		if(entity instanceof EntityPlayer)
		{
			EntityPlayer entityPlayer = (EntityPlayer)entity;
			
			if(entityPlayer.inventory.getCurrentItem() != null)
			{
			//プレイヤーが手にしているものが楼観剣なら
			if(entityPlayer.inventory.getCurrentItem().getItem() == mod_thKaguya.roukankenItem)
			{
				double xx, zz;
				xx = entity.motionX;
				zz = entity.motionZ;
				if( Math.sqrt(xx*xx + zz*zz) > 3.0)
				{
					Entity entitys = null;
					//指定範囲内のEntityのリストを取得
					List list = world.getEntitiesWithinAABBExcludingEntity(entity, entity.boundingBox.addCoord(entity.motionX, entity.motionY, entity.motionZ).expand(1.0D, 1.0D, 1.0D));
        			double d = 0.0D;
        			for (int j = 0; j < list.size(); j++)
        			{
						 Entity entity1 = (Entity)list.get(j);
            			if (!entity1.canBeCollidedWith())
            			{
                			continue;
            			}
        				MovingObjectPosition movingobjectposition = new MovingObjectPosition(entity1);
        				//if (!movingobjectposition.entityHit.attackEntityFrom(DamageSource.causeMobDamage((EntityLiving)entity), 8))
        				//{
    						if(movingobjectposition.entityHit instanceof EntityLiving)
    						{
    							EntityLiving entityLiving = (EntityLiving)movingobjectposition.entityHit;
    							if(entityPlayer.canEntityBeSeen(entityLiving))
    							{
    								if(entityLiving.getCreatureAttribute() == EnumCreatureAttribute.UNDEAD)//アンデッドに当たったなら
    								{
    									entityLiving.attackEntityFrom(DamageSource.causeMobDamage((EntityLiving)entity), 20);//20ダメージを追加する
    								}
    								else
    								{
    									entityLiving.attackEntityFrom(DamageSource.causeMobDamage((EntityLiving)entity), 8);//それ以外なら8ダメージ
    								}
    								world.playSoundAtEntity(entity, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
    							}
    						}
        					itemstack.damageItem(1, (EntityLiving)entity);//アイテムの耐久を1減らす
        					if(itemstack.getItemDamageForDisplay() == getMaxDamage())//アイテムの耐久が限界なら消す
        					{
        						itemstack.stackSize--;
        						break;
        					}
        				//}
        			}
					//world.playSoundAtEntity(entity, "random.bow", 0.5F, 2.0F);//音を出す
				}
			}

			}
			
		}
	}
	
	//右クリックを長押しした祭の動作を指定
	@Override
	public EnumAction getItemUseAction(ItemStack par1ItemStack)
    {
        return EnumAction.bow;//弓の構えをする
    }

	@Override
    public boolean canHarvestBlock(Block par1Block)
    {
    	return true;//なんでも取得可能　切れぬものはあんm（ry
    }

	//エンチャント可能か？
	@Override
    public int getItemEnchantability()
    {
        return 0;//エンチャント不可
    }
	
}
